funcdef float EaseFuncDef(float);

enum ElementAniProp {
	EL_X,
	EL_Y,
	EL_WIDTH,
	EL_HEIGHT
}

class Animate {
	UIElement@ target;
	float start;
	float end;
	int duration; 
	float elapsed = 0;
	Timer@ timer;
	EaseFuncDef @ease;
	ElementAniProp property;
	Animate() {
	
	}
	~Animate() {
		echo("argh, I perish...\n");
	}
	Animate(UIElement@ t, ElementAniProp prop, float s, float e, int d, Timer@ tim, EaseFuncDef @easeFunc) {
		property = prop;
		@target = @t;
		start = s;
		end = e;
		duration = d;
		@timer = @tim;
		@ease = @easeFunc;
		timer.elapsed += Action(this.eval);	
	}
	
	void eval() {
		elapsed += 1;
		if (elapsed > duration) {
			timer.elapsed -= Action(this.eval);	
			@ease = null;
			@target = null;
		} else {
			float progress = elapsed/duration;
			float delta = ease(progress);
			float value = start+(end*delta);
			switch (property) {
				case EL_X:
					target.setPosition(Vector3(value,target.position.y,target.position.z));
					break;
				case EL_Y:
					target.setPosition(Vector3(target.position.x,value,target.position.z));
					break;
				case EL_WIDTH:
					target.width = int(floor(value));
					break;
				case EL_HEIGHT:
					target.height = int(floor(value));
					break;
			}
		}		
	}
}


float EASE_LINEAR(float progress) {
	return progress;
}
float EASE_QUAD_IN(float progress) {
	return pow(progress, 2);
}
float EASE_CIRC_IN(float progress) {
	return 1 - sin(acos(progress));
}
float EASE_QUAD_OUT(float progress) {
	return 1 - EASE_QUAD_IN(1 - progress);
}
float EASE_ELASTIC_IN(float progress) {
	return pow(2, 10 * (progress-1)) * cos(20*PI*0.3/3*progress);
}
float EASE_ELASTIC_OUT(float progress) {
	return 1 - EASE_ELASTIC_IN(1 - progress);
}