class UIController:InputControllerInterface {
	Array<UIElement@> arrUiElements;
	InputController@ UIInputController;
	Timer@ timer;

	UIController() {
		control.Input.mouseBtnDown(PM_RIGHT) += MouseBtnCallback(myObject.myCallback);
	}

	UIController(Timer@ t) {
		@timer = @t;
		@UIInputController = InputController(@this, @timer);
		UIInputController.pairs.add(InputControlPair(PM_LEFT, UI_mouseButtonDown, false, T_DOWN));
		UIInputController.setActive();

	}

	void register(UIElement@ element) {
		arrUiElements.add(element);
	}

	void doAction(InputControllerAction action, int val) {
		switch(action){
			case UI_mouseButtonDown:

				this.checkCoords();
				break;
		}
	}

	private void checkCoords() {
		int cursorX;
		int cursorY;
		getCursorPos(cursorX, cursorY);
		//echo(String(cursorX)+", "+String(cursorY)+"\n");
		for (uint i = 0; i < arrUiElements.length(); i++) {
			if (arrUiElements[i].containsPoint(Vector3(cursorX-(MAIN_WINDOW.width/2), 0, cursorY-(MAIN_WINDOW.height/2)))) {
				//echo("True\n");
				UIEventInfo info = UIEventInfo();
				@info.element = arrUiElements[i];
				info.type = UIE_CLICK;
				arrUiElements[i].onClick(info);
			}
		}
	}

}
