enum UISubObjContained {
	SO_OBJECT,
	SO_ELEMENT,
}

class UIElementChildAdapter {
	Object@ object;
	UIElement@ element;
	UISubObjContained typeOf;
	Vector3 localPosition = Vector3(0,0,0);
	Scene@ scene;
	bool ignoreDepthManager = false;
	
	UIElementChildAdapter() {
		//constructor
	}
	UIElementChildAdapter(Object@ obj) {
		@object = obj;
		localPosition = object.position;
		typeOf = SO_OBJECT;
		
	}
	UIElementChildAdapter(UIElement@ el) {
		@element = el;
		localPosition = element.position;
		typeOf = SO_ELEMENT;
	}
	
	Vector3 position {
		get const {
			switch(this.typeOf) {
				case SO_OBJECT:
					return object.position;
				case SO_ELEMENT:
					return element.position;
			}
			return Vector3(1000,1000,1000);
		}
	}

	bool clickResponse {
		get const {
			switch(this.typeOf) {
				case SO_ELEMENT:
					return element.clickResponse;
			}
			return false;
		}	
		set {
			switch(this.typeOf) {
				case SO_ELEMENT:
					element.clickResponse = value;
			}		
		}
	}	
	
	void setPosition(Vector3 pos) {
		switch(this.typeOf) {
			case SO_OBJECT:
				object.setPosition(pos);
				break;
			case SO_ELEMENT:
				element.setPosition(pos);
				//echo("pos "+String(pos.x)+", "+String(pos.y)+", "+String(pos.z)+"\n");
				//echo(element.id+": "+String(element.position.x)+", "+String(element.position.y)+", "+String(element.position.z)+"\n");
				break;
		}	
	}
	
	void translate(Vector3 pos) {
		switch(this.typeOf) {
			case SO_OBJECT:
				object.translate(pos);
				break;
			case SO_ELEMENT:
				element.translate(pos);
				break;
		}	
	}	
	
	void addToScene(Scene@ s) {
		@scene = @s;
		switch(this.typeOf) {
			case SO_OBJECT:
				scene.add(object);
				break;
			case SO_ELEMENT:
				element.addToScene(scene);
				break;
		}		
	}
	
	void removeFromScene()	{
		switch(this.typeOf) {
			case SO_OBJECT:
				scene.remove(object);
				break;
			case SO_ELEMENT:
				element.removeFromScene();
				break;
		}
		@scene = null;
	}
	
	
}