UIDepthManager UI_DEPTH_MANAGER = UIDepthManager(0,1);

class UIDepthManager {
	Array<UIElementChildAdapter@> arrElementOrder;
	float baseIndex;
	float divideAmount = 100;



	UIDepthManager() {

	}

	UIDepthManager(float bIdx, float db=100 ) {
		baseIndex = bIdx;
		divideAmount = db;
	}

	void orderElements() {
		for (uint i = 0; i < arrElementOrder.length; i++) {
			arrElementOrder[i].setPosition(Vector3(arrElementOrder[i].position.x,getWorldPos(i)+arrElementOrder[i].position.y,arrElementOrder[i].position.z));
		}
	}

	float setIndex(UIElementChildAdapter@ element) {
		arrElementOrder.add(element);
		float worldPos = getWorldPos(arrElementOrder.length-1);
		//echo("setIndex "+String(element.typeOf)+" "+String(element.position.z)+"\n");
		element.translate(Vector3(0,worldPos,0));

		return worldPos;
	}

	float setIndex(UIElementChildAdapter@ element, int idx) {
		int oldIdx;
		float worldPos;
		arrElementOrder.removeAt(idx);

		if (int(arrElementOrder.length-1) < idx) {
			worldPos = this.setIndex(element);

		} else {
			arrElementOrder.insertAt(idx, element);
			orderElements();
			worldPos = getWorldPos(idx);
		}
		return worldPos;
	}

	float getWorldPos(int idx) {
		//return ((idx/divideAmount)+baseIndex)*-1;
		return ((idx/divideAmount))*-1;
	}

}
