
#include "game/Init.as";
#include "interface/UIElement.as";
#include "interface/UIInput.as";
#include "GameSettingsSave.as"
//#include "editor/init.as";
//#include "core/Entities/Actor.as";

Control@ CONTROL;

//EnvironmentLight@ light;
Quaternion Yaw;
Quaternion Pitch;

Scene@ MAIN_SCENE;
Scene@ INTERFACE_SCENE;
Scene@ HUD_SCENE;
Scene@ SKYBOX_SCENE;
Scene@ EFFECT_OVERLAY_SCENE;
Camera@ MAIN_CAM;
Camera@ MAIN_CAM2;
Camera@ INTERFACE_CAM;
Camera@ SKYBOX_CAM;
Camera@ HUD_CAM;
Camera@ EFFECT_OVERLAY_CAM;

Window@ MAIN_WINDOW;
Window@ SKYBOX_WINDOW;
ResourcePool@ pool;
Object@ sphere;
ObjectFactory@ objectFactory;
Timer@ MAIN_TIMER;
float tNr = 0;
Viewport@ v1;
Viewport@ v2;
DebugInfo@ debugInfo;
int gameWidth = 1280;
int gameHeight = 720;
bool fullscreen = false;
String ASSETS_LOCATION = "../../Assets/";

Display@ ACTIVE_DISPLAY;
Renderer@ renderer;
GameSettingsSave@ GAME_SETTINGS;

bool EFFECTS_MUTED = false;

void main(Control@ c) {
	@GAME_SETTINGS = GameSettingsSave("settings");
	@CONTROL = c;
	@MAIN_TIMER = CONTROL.createTimer(10, true);
	MAIN_TIMER.start();


	@pool = ResourcePool();

	@objectFactory = ObjectFactory(pool);

	@renderer = OpenGL4Renderer();
	CONTROL.setRenderer(renderer);

	int loadedScreenWidth;
	int loadedScreenHeight;
	bool loadedIsFullscreen;
	if(GAME_SETTINGS.loadInt("screenWidth",loadedScreenWidth) &&
		GAME_SETTINGS.loadInt("screenHeight", loadedScreenHeight)) {
			gameWidth = loadedScreenWidth;
			gameHeight = loadedScreenHeight;
		}

	if(GAME_SETTINGS.loadBool("fullscreen",loadedIsFullscreen)){
		fullscreen = loadedIsFullscreen;
	}

	//@stepHandler = CONTROL.createDelegate("void doStep(pUInt)");
	// @t = CONTROL.createTimer(10, true);
	// @moveTest = CONTROL.createDelegate("void doMove()", t);
	// t.start();
	@MAIN_WINDOW = renderer.createWindow(gameWidth, gameHeight, fullscreen);
	MAIN_WINDOW.VSync = true;
	MAIN_WINDOW.open();

	//setGameWindow(gameWidth,gameHeight,false);
	@ACTIVE_DISPLAY = renderer.getDisplay(MAIN_WINDOW.getDisplayIndex());

	//MAIN_WINDOW.GrabInput = true;
	// OctreePartition p1;
	// OctreePartition p2;
	// OctreePartition p3;
	Partition p1;
	Partition p2;
	Partition p3;
	@MAIN_SCENE = Scene(p1);
	@SKYBOX_SCENE = Scene(p3);
	@INTERFACE_SCENE = Scene(p2);
	@HUD_SCENE = Scene(OctreePartition());
	@EFFECT_OVERLAY_SCENE = Scene(Partition());

	@MAIN_CAM = Camera(60, pFloat(MAIN_WINDOW.width)/MAIN_WINDOW.height, 0.1f, 1000.0f);
	//@MAIN_CAM2 = Camera(60, pFloat(MAIN_WINDOW.width)/MAIN_WINDOW.height, 0.1f, 100.0f);
	@SKYBOX_CAM = Camera(60, pFloat(MAIN_WINDOW.width)/MAIN_WINDOW.height, 0.1f, 1000.0f);
	//@c2 = Camera(pFloat(-MAIN_WINDOW.width)/2, pFloat(MAIN_WINDOW.width)/2, pFloat(-MAIN_WINDOW.height)/2, pFloat(MAIN_WINDOW.height)/2, 0.1f, 1000.0f);
	pUInt hWidth = MAIN_WINDOW.width/2;
	pUInt hHeight = MAIN_WINDOW.height/2;
	@INTERFACE_CAM = Camera(-hWidth, hWidth, hHeight,-hHeight, 0.0f, 100.0f);
	INTERFACE_CAM.translate(0,-100,0);
	//@INTERFACE_CAM = Camera(60, pFloat(MAIN_WINDOW.width)/MAIN_WINDOW.height, 0.1f, 1000.0f);
	@HUD_CAM = Camera(-MAIN_WINDOW.width / 2, MAIN_WINDOW.width / 2, MAIN_WINDOW.height/2, -MAIN_WINDOW.height/2, 0, 10);
	//@EFFECT_OVERLAY_CAM = Camera(-MAIN_WINDOW.width / 2, MAIN_WINDOW.width / 2, MAIN_WINDOW.height/2, -MAIN_WINDOW.height/2, 0, 1000);
	@EFFECT_OVERLAY_CAM = Camera(-256, 256, 256, -256, 0, 1000);
	//Viewport @v1 = Viewport(0, 0, MAIN_WINDOW.width / 2, MAIN_WINDOW.height / 2);
	@v1 = Viewport(0, 0, MAIN_WINDOW.width, MAIN_WINDOW.height);
	@v2 = Viewport(0, 0, MAIN_WINDOW.width, MAIN_WINDOW.height);

	v1.addCamera(0, SKYBOX_CAM);
	v1.addCamera(1, MAIN_CAM);
	v1.addCamera(2, HUD_CAM);
	//v1.addCamera(1, MAIN_CAM2);
	v1.addCamera(3, INTERFACE_CAM);
	v1.addCamera(4, EFFECT_OVERLAY_CAM);
	//v1.enableClear(Color(BG_COLOR));
	v1.enableClear(Color(120, 180, 210, 255));
	v2.enableClear(Color(100, 100, 100, 255));

	MAIN_WINDOW.addViewport(v1);
	//sMAIN_WINDOW.addViewport(v2);

	MAIN_SCENE.add(MAIN_CAM);
	HUD_SCENE.add(HUD_CAM);
	//@MAIN_CAM2.sceneRef = MAIN_SCENE;
	SKYBOX_SCENE.add(SKYBOX_CAM);
	INTERFACE_SCENE.add(INTERFACE_CAM);
	EFFECT_OVERLAY_SCENE.add(EFFECT_OVERLAY_CAM);

	//MAIN_CAM2.disable();
	MAIN_CAM.enable();
	INTERFACE_CAM.enable();
	SKYBOX_CAM.enable();
	HUD_CAM.enable();
	EFFECT_OVERLAY_CAM.enable();

	CONTROL.addScene(MAIN_SCENE);
	CONTROL.addScene(INTERFACE_SCENE);
	CONTROL.addScene(SKYBOX_SCENE);
	CONTROL.addScene(EFFECT_OVERLAY_SCENE);

	
	@debugInfo = DebugInfo();
	debugInfo.proxies = false;
	debugInfo.skeletons = false;
	//debugInfo.boundingvolumes = true;
	debugInfo.setDefaultMat(pool.getMaterial("Resources/Renderer/GL4Deferred/Materials/defaultDebug.pmat"));
	@MAIN_CAM.debugInfoRef = debugInfo;

	//init();

	game_init();
	menu_init();

}

void setGameWindow(int width, int height, bool isFullscreen){
	gameWidth = width;
	gameHeight = height;
	GAME_SETTINGS.saveValue("screenWidth",width);
	GAME_SETTINGS.saveValue("screenHeight",height);
	GAME_SETTINGS.saveValue("fullscreen",isFullscreen);
	GAME_SETTINGS.save();

	MAIN_WINDOW.close();
	@MAIN_WINDOW = renderer.createWindow(width, height, isFullscreen);
	MAIN_WINDOW.VSync = true;
	MAIN_WINDOW.open();
	@v1 = Viewport(0, 0, MAIN_WINDOW.width, MAIN_WINDOW.height);

	pUInt hWidth = MAIN_WINDOW.width/2;
	pUInt hHeight = MAIN_WINDOW.height/2;


	INTERFACE_CAM.setOrthogonal(-hWidth, hWidth, hHeight,-hHeight, 0.0f, 100.0f);
	HUD_CAM.setOrthogonal(-hWidth, hWidth, hHeight, -hHeight, 0, 10);
	MAIN_CAM.setPerspective(60, pFloat(MAIN_WINDOW.width)/MAIN_WINDOW.height, 0.1f, 1000.0f);
	SKYBOX_CAM.setPerspective(60, pFloat(MAIN_WINDOW.width)/MAIN_WINDOW.height, 0.1f, 1000.0f);

	v1.addCamera(0, SKYBOX_CAM);
	v1.addCamera(1, MAIN_CAM);
	v1.addCamera(2, HUD_CAM);
	v1.addCamera(3, INTERFACE_CAM);
	v1.enableClear(Color(120, 180, 210, 255));
	v2.enableClear(Color(100, 100, 100, 255));

	MAIN_WINDOW.addViewport(v1);
}
