#include "Messages.as"
#include "NetworkPlayer.as"

pCollisionGroupBitmask bit(pCollisionGroupBitmask x) { return 1<<x; }

pCollisionGroupBitmask COL_NOTHING 	 = 0;
pCollisionGroupBitmask COL_BONES 	 = bit(1);
pCollisionGroupBitmask COL_CHARACTER = bit(2);
pCollisionGroupBitmask COL_ALL 	 	 = MAX_PUINT;

funcdef void ConnectionCallback(pConnectionState );


enum GameState
{
	GS_NotRunning,
	GS_Started,
	GS_Ended,
}

class Client
{
	private NetworkPeer mPeer;
	Map<pUByte, NetworkPlayer@> mPlayers;
	NetworkPlayer@ Me = NetworkPlayer();

	private Timer@ mUpdateTimer;
	private Player@ mPlayer;
	private PeerID@ mServer;
	private bool mSpawned = false;

	pUInt mMaxPlayers = 0;
	private Object@ mDeathObj;

	Object@ cube;
	Animation@ animation;
	Array<SubAnimation@> subAnimations;
	int animActive = 0;
	pUByte currentAnimState = 0;

	funcdef void GameStateCallback(GameState);

	ConnectionCallback@ resultCallback;
	GameStateCallback@ gameCallback;

	Timer@ statTimer;


	Client(){}
	~Client()
    {
	  echo ("Distroying client");
      shutDown();
    }

	void shutDown()
	{
		mPeer.shutDown();

		mPlayers.clear();
		@Me = null;
		@mUpdateTimer = null;
		@mPlayer = null;
		@mServer = null;
		mSpawned = false;
		@mUpdateTimer = null;

		@animation = null;
		subAnimations.length = 0;
		animActive = 0;
		currentAnimState = 0;
		@resultCallback = null;
		@gameCallback = null;
	}

	Client(ConnectionCallback@ cb, GameStateCallback@ gcb) { @resultCallback = cb; @gameCallback = gcb;}

	// void statPrinter()
	// {
		// echo ("Client to Host:");
		// mPeer.printStats();
	// }
	void setPlayer(Player@ player)
	{
		@mPlayer = player;
	}

	NetworkPlayer@ getLocalPlayer()
	{
		return Me;
	}

	void Connect(String address, pUInt port, String Passwrd)
	{

		//We expect the following messages...
		mPeer.registerMessageClass(AssignID(0), NetMessageCallback(this.handleAssignID));
		mPeer.registerMessageClass(SpawnPlayer(), NetMessageCallback(this.handleSpawnPlayer));
		mPeer.registerMessageClass(SyncPlayer(), NetMessageCallback(this.handleSyncPlayer));
		mPeer.registerMessageClass(PlayerJoined(), NetMessageCallback(this.handlePlayerJoined));
		mPeer.registerMessageClass(FireWeapon(), NetMessageCallback(this.handleFireWeapon));
		mPeer.registerMessageClass(HitDamage(), NetMessageCallback(this.handleHitDamage));
		mPeer.registerMessageClass(PlayerDied(), NetMessageCallback(this.handlePlayerDied));
		mPeer.registerMessageClass(PlayerLeft(), NetMessageCallback(this.handlePlayerLeft));
		mPeer.registerMessageClass(ManagePickup(), NetMessageCallback(this.handlePickup));
		mPeer.registerMessageClass(GameStart(), NetMessageCallback(this.handleGameStart));
		mPeer.registerMessageClass(GameSettings(), NetMessageCallback(this.handleGameSettings));
		mPeer.registerMessageClass(GameEnd(), NetMessageCallback(this.handleGameEnd));


		echo("Starting client...\n");
		mPeer.connect(address, port, ConStateCallback(this.ConnectionStateCB), Passwrd);


		// @statTimer = CONTROL.createTimer(5000, true);

		// statTimer.elapsed += Action(this.statPrinter);
		// statTimer.start();
	}

	void ConnectionStateCB(pConnectionState state, PeerID@ peerID, pInt receipt)
	{
		switch (state)
		{
		case CS_CONNECTING:
			echo("Connecting...\n");
			break;
		case CS_CONNECTED:{
				echo ("Connected!\n");
				NewUser user;
				user.name = gPlayerName;
				mPeer.send(user, peerID, NR_RELIABLE, NP_IMMEDIATE, OC_Generic);

				@mServer = peerID;
			}
		}


		if (resultCallback !is null)
			resultCallback(state);
	}
	
	void reset() 
	{
		echo ("RESET!");
		
		for(auto it = mPlayers.begin(); it++;) {
			NetworkPlayer@ np = cast<NetworkPlayer>(it.value);
			if (np is null) continue;
			
			echo ("Resetting " + np.username);
			
			np.deaths = 0;
			np.kills = 0;
			np.dead = false;
			np.health = 100;
			np.winner = false;
		}
	}
	

	bool checkMessageType (iNetMessage@ _message, MessageType mt, String func, String type)
	{
		MessageType t = MessageType(_message.getType());
		if (t != mt) {
			echo ("Received a messages in my" + func + " that wasn't" + type + "! What is this!? Piko3D is broken! (or I made a copy/paste error)");
			return false;
		}
		return true;
	}

	void handleGameStart(iNetMessage@ _message, PeerID@)
	{
		reset();
		if (!checkMessageType(_message, MT_GameStart, "handleGameStart", "GameStart")) return;
		if (gameCallback !is null)
			gameCallback(GS_Started);
	}

	void handleGameSettings(iNetMessage@ _message, PeerID@)
	{
		if (!checkMessageType(_message, MT_GameSettings, "handleGameSettings", "GameSettings")) return;
		GameSettings@ gs = cast<GameSettings>(_message);
		mMaxPlayers = gs.maxPlayerCount;
	}
	
	
	void handleGameEnd(iNetMessage@ _message, PeerID@)
	{
		if (!checkMessageType(_message, MT_GameEnd, "handleGameEnd", "GameEnd")) return;
		GameEnd@ gs = cast<GameEnd>(_message);
		
		NetworkPlayer@ winner = mPlayers[gs.winner];
		winner.winner = true;
		
		if (gameCallback !is null)
			gameCallback(GS_Ended);
	}
	

	void handleAssignID(iNetMessage@ _message, PeerID@)
	{
		if (!checkMessageType(_message, MT_AssignID, "handleAssignID", "AssignID")) return;
		AssignID@ aid = cast<AssignID>(_message);
		Me.id = aid.id;
		Me.username = gPlayerName;
		echo ("ID assigned: I am: " + String(aid.id) + "\n");

		@mPlayers[Me.id] = @Me;
	}

	void handlePlayerJoined(iNetMessage@ _message, PeerID@)
	{
		if (!checkMessageType(_message, MT_PlayerJoined, "handlePlayerJoined", "PlayerJoined")) return;
		PlayerJoined@ pj = cast<PlayerJoined>(_message);

		echo ("Player joined with ID:" + String(pj.id));
		NetworkPlayer@ player = NetworkPlayer(pj.id);
		player.connected = true;
		player.username = pj.name;

		WeaponHitCallback@ mHitCallback;
		@player.weapons[WT_RayGun] = RayGun(50, 800, mHitCallback);

		if (player.obj is null)
			createPlayerAvatar(player);

		if (pj.spawned) {
			MAIN_SCENE.add(@player.weaponObj);
			MAIN_SCENE.add(@player.obj);
		}

		player.deaths = pj.deaths;
		player.kills = pj.kills;

		@mPlayers[pj.id] = @player;
	}

	void handlePlayerLeft(iNetMessage@ _message, PeerID@)
	{
		echo ("Received player left message");
		if (!checkMessageType(_message, MT_PlayerLeft, "handlePlayerLeft", "PlayerLeft")) return;
		PlayerLeft@ pl = cast<PlayerLeft>(_message);

		switch (pl.state)
		{
			case CS_CLIENTLOST:
			{
				NetworkPlayer@ player = mPlayers[pl.id];
				player.obj.scale(2);
				MAIN_SCENE.remove(player.obj);
				MAIN_SCENE.remove(player.weaponObj);				
				MAIN_SCENE.remove(player.nameLbl);
				
				mPlayers.erase(pl.id);
				break;
			}
			default:
			 echo ("Unknown player left message: " + String(pl.state));
		}
	}

	void handleSpawnPlayer(iNetMessage@ _message, PeerID@)
	{
		if (!checkMessageType(_message, MT_SpawnPlayer, "handleSpawnPlayer", "SpawnPlayer")) return;

		SpawnPlayer@ sp = cast<SpawnPlayer>(_message);

		echo ("Player spawned!");

		//spawn yourself or other players
		if (sp.id == Me.id)	{
			spawn(Me, sp.xForm);
			if (mPlayer is null)
				echo ("Player is null");
			else if (@mPlayer.body is null)
				echo ("Body is null");
			MAIN_SCENE.add(mPlayer.controller.weapon);
			@mPlayer.body.userRef = PlayerInfo(Me.id);
			mPlayer.controller.disabled = false;
		} else {
			NetworkPlayer@ player = mPlayers[sp.id];
			spawn(player, sp.xForm);
		}

		//startPlayerSync();
	}

	void spawn(NetworkPlayer@ player, Transform xform)
	{
		if (player.id == Me.id) {
			if (mDeathObj !is null) 
				MAIN_SCENE.remove(mDeathObj);
			
			if (mPlayer !is null) {
					mPlayer.body.xForm = xform;
					echo ("Got spawned at location: " + xform.toString());
					mSpawned = true;
					Me.health = 100;
					
					//player.dead = false;
				}
				mUpdateTimer.start();
		} else {
			MAIN_SCENE.remove(player.obj);
			MAIN_SCENE.remove(player.weaponObj);
			
			if (player.obj.ragdoll !is null) {
				player.obj.ragdoll.controller.mode = CM_ANIMATIONDRIVEN;
				player.obj.ragdoll.collidesWithBitmask = COL_NOTHING;
			}
			player.obj.xForm = xform;

			player.weaponObj.proxy.type = PT_KINEMATIC;
			player.weaponObj.proxy.collidesWithBitmask = (COL_ALL & ~COL_BONES) & ~COL_CHARACTER;
			player.obj.skeleton.getBone("bone_hand_right").link.add(player.weaponObj);
						
			player.obj.animator.play(subAnimations[0]);
			animActive = 0;
			
			MAIN_SCENE.add(@player.obj);
			MAIN_SCENE.add(@player.weaponObj);
		}
	}

	void handleSyncPlayer(iNetMessage@ _message, PeerID@)
	{
		if (!checkMessageType(_message, MT_SyncPlayer, "handleSyncPlayer", "SyncPlayer")) return;

		SyncPlayer@ message = cast<SyncPlayer>(_message);
		Object@ obj = null;

		if (message.id == Me.id)
			return;

		NetworkPlayer@ player = mPlayers[message.id];
		if (player is null) return;

		if (player.obj is null)
			return;


		if (currentAnimState != message.animState) {

			switch (message.animState) {
				case 0:
					player.obj.animator.stop(subAnimations[animActive]);
					player.obj.animator.play(subAnimations[0]);
					animActive = 0;
					break;
				case 1:
					player.obj.animator.stop(subAnimations[animActive]);
					player.obj.animator.play(subAnimations[1], true);
					animActive = 1;
					break;
				case 2:
					player.obj.animator.stop(subAnimations[animActive]);
					player.obj.animator.play(subAnimations[1], true, -1);
					animActive = 1;
					break;
				case 3:
					player.obj.animator.stop(subAnimations[animActive]);
					player.obj.animator.play(subAnimations[2], true);
					animActive = 2;
					break;
				case 4:
					player.obj.animator.stop(subAnimations[animActive]);
					player.obj.animator.play(subAnimations[3], true);
					animActive = 3;
					break;
			}
			currentAnimState = message.animState;
		}

		player.obj.xForm = message.xForm;
		//player.obj.relTranslate(0,0,0.03);
		player.obj.linVel = message.velocity;
		player.obj.angVel = message.angVel;
	}

	void handlePickup(iNetMessage@ _message, PeerID@ peer) {
		echo("pickup");
		ManagePickup@ message = cast<ManagePickup>(_message);
		if (message.picked) {
			MAIN_SCENE.remove(LEVEL.arrHealthPickup[message.id].pObj);
			if (message.player_id == Me.id) {
				Me.health = message.health;
				mPlayer.showPickupEffect();
			}
		} else {
			MAIN_SCENE.add(LEVEL.arrHealthPickup[message.id].pObj);
		}
	}

	void handleFireWeapon(iNetMessage@ _message, PeerID@ peer) {
		echo("msg weapontype: ");
		if (!checkMessageType(_message, MT_FireWeapon, "handleFireWeapon", "FireWeapon")) return;
		FireWeapon@ message = cast<FireWeapon>(_message);

		NetworkPlayer@ player = mPlayers[message.id];

		switch (message.weaponType) {
			case WT_RayGun: {
				auto@ rg = player.weapons[WT_RayGun];
				rg.fire(message.xForm, 100);
				break;
			}
		}
		//Projectile @p = Projectile(message.xForm);
		//p.createBeam(1000, 100);

		//Another player has fired a weapon! We have to do something!!!!
		echo ("Player " + String(message.id) + " has fired a weapon! (client.as)");
	}

	void handleHitDamage(iNetMessage@ _message, PeerID@) {
		if (!checkMessageType(_message, MT_HitDamage, "handleHitDamage", "HitDamage")) return;
		HitDamage@ message = cast<HitDamage>(_message);


		// Object@ obj = objectFactory.createCube();
		// obj.scale(0.1);
		// obj.model.setColor(RED);
		// obj.position = message.position;
		// obj.model.setDrawMode(DM_EMISSIVE);
		// NetworkPlayer@ player = mPlayers[message.id];
		// player.emitter.xForm = player.obj.xForm;
		// player.emitter.emit(10);		
		for (int i = 0; i < 20; i++) {
			Object@ o = objectFactory.createSphere();
			o.model.setColor(Color(190,0,0,255));
			o.model.setDrawMode(DM_EMISSIVE); 
			float s = float (rand() % (30 + 1 - 10) + 10)/100;
			Gib(message.position, Vector3(0,0,0), o, s, 20, 30, 0.0004, false, true );
		}		
		//MAIN_SCENE.add(obj);

		if (message.id == Me.id) {
			//I got hit!!!
			Me.health -= message.damage;
			mPlayer.showDamageEffect();
		}
	}

	void handlePlayerDied(iNetMessage@ _message, PeerID@)
	{
		if (!checkMessageType(_message, MT_PlayerDied, "handlePlayerDied", "PlayerDied")) return;
		PlayerDied@ message = cast<PlayerDied>(_message);

		if (message.killer_id != message.killed_id)//not a suicide
		{
			NetworkPlayer@ killer = mPlayers[message.killer_id];
			if (killer is null)
			{
				echo ("No killer?! what the fuck!?");
				return;
			}
			killer.kills++;
			if(@messageTicker != null){
				messageTicker.CreateMessage(mPlayers[message.killer_id].username+" killed "+mPlayers[message.killed_id].username);
			}
		} else {
			if(@messageTicker != null){
				messageTicker.CreateMessage(mPlayers[message.killer_id].username+" didn't watch his vector, Victor..");
			}
		}
		
		bool useRagdoll = message.ragdoll;

		if (message.killed_id == Me.id)
		{
			//OMG I am dead!
			MAIN_SCENE.remove(mPlayer.controller.weapon);
			mPlayer.controller.disabled = true;
			if (useRagdoll) {
				@mDeathObj = Object();
				mDeathObj.xForm = mPlayer.cam.xForm;
				@mDeathObj.proxy = MAIN_SCENE.world.createProxy(PT_DYNAMIC);
				mDeathObj.proxy.addCapsule(0.2,0.4,1);
				mDeathObj.proxy.collisionGroupBitmask = COL_CHARACTER;
				mDeathObj.proxy.collidesWithBitmask = (COL_ALL & ~COL_CHARACTER) & ~COL_BONES;
				mDeathObj.proxy.gravity = mPlayer.body.proxy.gravity;
				MAIN_SCENE.add(@mDeathObj);
				
				mDeathObj.link.add(@mPlayer.cam);
			
				// @mDeathObj = objectFactory.load("../../Assets/3D/character_animation.fbx");
				// createRagdoll(mDeathObj);
				// MAIN_SCENE.add(@mDeathObj);
				// mDeathObj.ragdoll.gravity = mPlayer.body.proxy.gravity;				
				// mDeathObj.skeleton.getBone("bone_head").link.add(@mPlayer.cam);
			} else {
				mPlayer.cam.relTranslate(0,-0.5,1.5);
				mPlayer.cam.relRotate(1,0,0, -0.35 * PI);
			
				Gib(mPlayer.body.position, mPlayer.body.proxy.gravity, objectFactory.load(ARR_GIBS_STRING[0]));
				Gib(mPlayer.body.position, mPlayer.body.proxy.gravity, objectFactory.load(ARR_GIBS_STRING[1]));
				Gib(mPlayer.body.position, mPlayer.body.proxy.gravity, objectFactory.load(ARR_GIBS_STRING[2]));
				for (int i = 0; i < 12; i++) {
					Gib(mPlayer.body.position, mPlayer.body.proxy.gravity, objectFactory.load(ARR_GIBS_STRING[RANDOM.get(3,6)]));
				}
			}
			mUpdateTimer.stop();
			Me.deaths++;
		}
		else
		{	
			NetworkPlayer@ player = mPlayers[message.killed_id];
			
			player.weaponObj.proxy.type = PT_DYNAMIC;
			player.weaponObj.proxy.collidesWithBitmask = COL_ALL & ~COL_CHARACTER;
			player.obj.skeleton.getBone("bone_hand_right").link.remove(player.weaponObj);
			
			player.deaths++;
			echo ( "Killing player...");			

			if (useRagdoll && player.obj.ragdoll !is null)
			{
				echo ("Ragdolling...");
				player.obj.ragdoll.controller.mode = CM_PHYSICSDRIVEN;
				player.obj.ragdoll.collidesWithBitmask = COL_ALL & ~COL_CHARACTER;
			}
			else
			{
				Gib(player.obj.position, player.obj.proxy.gravity, objectFactory.load(ARR_GIBS_STRING[0]));
				Gib(player.obj.position, player.obj.proxy.gravity, objectFactory.load(ARR_GIBS_STRING[1]));
				Gib(player.obj.position, player.obj.proxy.gravity, objectFactory.load(ARR_GIBS_STRING[2]));
				for (int i = 0; i < 12; i++) {
					Gib(player.obj.position, player.obj.proxy.gravity, objectFactory.load(ARR_GIBS_STRING[RANDOM.get(3,6)]));
				}
				MAIN_SCENE.remove(player.obj);
				MAIN_SCENE.remove(player.weaponObj);
				//player.obj.rotate(0,1,0, 0.5 * PI);
			}
		}


	}

	void syncPlayer()
	{
		if (mPlayer !is null && mSpawned) {
			SyncPlayer SPMessage;
			SPMessage.xForm = mPlayer.body.xForm;
			SPMessage.velocity = mPlayer.body.linVel;
			SPMessage.angVel = mPlayer.body.angVel;

			SPMessage.id = Me.id;
			SPMessage.animState = mPlayer.controller.animState;


			mPeer.send(SPMessage, mServer, NR_UNRELIABLE_SEQUENCED, NP_HIGH, OC_PlayerSync);

		}
	}

	void showWeaponFire(WeaponType weapon, Transform xForm)
	{
		Object@ obj = objectFactory.createCube();
		obj.scale(0.1);
		obj.model.setColor(RED);
		obj.position = xForm.position;
		obj.model.setDrawMode(DM_EMISSIVE);
	}

	void createPlayerAvatar(NetworkPlayer@ player)
	{
		@player.obj = objectFactory.load("../../Assets/3D/character_animation.fbx");		
		@player.obj.proxy = MAIN_SCENE.world.createProxy(PT_DYNAMIC);
		player.obj.proxy.collisionGroupBitmask = COL_CHARACTER;
		player.obj.proxy.collidesWithBitmask = COL_ALL & ~COL_BONES;
		
		@player.weaponObj = objectFactory.load("../../Assets/3D/c64_gun.fbx");
		@player.weaponObj.proxy = MAIN_SCENE.world.createProxy(PT_KINEMATIC);
		player.weaponObj.proxy.collisionGroupBitmask = COL_CHARACTER;
		player.weaponObj.proxy.collidesWithBitmask = (COL_ALL & ~COL_BONES) & ~COL_CHARACTER;
		
		player.weaponObj.proxy.addBox(0.85, 0.08, 0.25, 1, Transform(Quaternion(), Vector3(0.32,-0.03,-0.13)));

		@animation = pool.getAnimation("../../Assets/3D/character_animation.fbx:Take 001");
		@player.obj.animator = Animator();

		subAnimations.add(SubAnimation(animation, 15, 15));
		subAnimations.add(SubAnimation(animation, 1, 13));
		subAnimations.add(SubAnimation(animation, 89, 101));
		subAnimations.add(SubAnimation(animation, 75, 87));

		//player.obj.animator.play(an, true);
		//0.04 offset to reduce jitter (the character controller sinks into the floor a bit. Compensating for that)
		player.obj.proxy.addCapsule(0.25, 1.3, 1, Transform(Quaternion(), Vector3(0,0,0.90 + 0.04)));


		player.obj.proxy.angularFactor = Vector3(0,0,0);

	//	echo("Player locator"+player.obj.skeleton.getBone(0).name);

		MAIN_SCENE.add(@player.emitter);
		Object@ obj = objectFactory.createSphere();
		@obj.proxy = MAIN_SCENE.world.createProxy(PT_DYNAMIC);
		obj.proxy.addSphere(1,1);
		player.emitter.addObjects(obj, 10, 25);
		player.emitter.setVelocity(20, 25);
		

		
		
		LEVEL.gravityManager.registerEntity(@player.obj);
		LEVEL.gravityManager.registerEntity(@player.weaponObj);

		@player.obj.userRef = PlayerInfo(player.id);
		
		//Add name tag...
		//ONE..BIG... STINKING.. REVISION.. HACK! :D
		Label@ name = Label(aldoFont, player.username);
		name.centerMesh();
		name.scale(0.0018);		
		name.model.getSurface(0).useSpriteHack = true;
		MAIN_SCENE.add(name);
		@player.nameLbl = name;


		name.setPosition(player.obj.position + Vector3(0,0, 2.0));
		player.obj.link.add(name,LM_CHILD);

		createRagdoll(player.obj);
		player.obj.ragdoll.controller.mode = CM_ANIMATIONDRIVEN;
		
		

		// @player.obj.proxy = MAIN_SCENE.world.createProxy(PT_DYNAMIC);
		// player.obj.proxy.addBox(1,1,1);


		//Player@ character = Player(MAIN_SCENE, @MAIN_TIMER , null);
		//character.body.xForm = sp.xForm;
		//@player.character = character;
	}
	
	void createRagdoll(Object@ obj) 
	{
		float density = 320.0;
		pProxyType dynamic = PT_DYNAMIC;

		pCollisionGroupBitmask bitCat = COL_BONES;
		pCollisionGroupBitmask bitCol = COL_NOTHING;//COL_ALL & ~COL_CHARACTER;

		Bone@ skelHead = obj.skeleton.getBone("bone_head");
		Bone@ skelRoot1 = obj.skeleton.getBone("bone_hip");
		Bone@ skelSpine1 = obj.skeleton.getBone("bone_torso_01");
		Bone@ skelSpine2 = obj.skeleton.getBone("bone_torso_02");
		Bone@ skelSpine3 = obj.skeleton.getBone("bone_torso_end");
		Bone@ skelLeftUpperArm = obj.skeleton.getBone("bone_arm_upper_left");
		Bone@ skelLeftLowerArm = obj.skeleton.getBone("bone_arm_lower_left");
		Bone@ skelLeftHand = obj.skeleton.getBone("bone_hand_left");
		Bone@ skelRightUpperArm = obj.skeleton.getBone("bone_arm_upper_right");
		Bone@ skelRightLowerArm = obj.skeleton.getBone("bone_arm_lower_right");
		Bone@ skelRightHand = obj.skeleton.getBone("bone_hand_right");	
		Bone@ skelLeftUpperLeg = obj.skeleton.getBone("bone_leg_upper_left");
		Bone@ skelLeftLowerLeg = obj.skeleton.getBone("bone_leg_lower_left");
		Bone@ skelLeftFoot = obj.skeleton.getBone("bone_ankle_left");
		Bone@ skelRightUpperLeg = obj.skeleton.getBone("bone_leg_upper_right");
		Bone@ skelRightLowerLeg = obj.skeleton.getBone("bone_leg_lower_right");
		Bone@ skelRightFoot = obj.skeleton.getBone("bone_ankle_right");	
		
		@obj.ragdoll = Ragdoll();
		
		Bone@ head = obj.ragdoll.addBone("head", "bone_head", Transform(Quaternion(Vector3(0,1,0), 0.5*PI), Vector3(0.08,0.02,-0.0)));
		Bone@ root1 = obj.ragdoll.addBone("root1", "bone_hip", Transform(Quaternion(Vector3(0,1,0), 0.0*PI), Vector3(0.07,0,0)));
		Bone@ spine1 = obj.ragdoll.addBone("spine1", "bone_torso_01", Transform(Quaternion(Vector3(0,1,0), 0.0*PI), Vector3(0.11,0,0)));
		Bone@ spine2 = obj.ragdoll.addBone("spine2", "bone_torso_02", Transform(Quaternion(Vector3(0,1,0), 0.0*PI), Vector3(0.11,0,0)));
		Bone@ spine3 = obj.ragdoll.addBone("spine3", "bone_torso_end", Transform(Quaternion(Vector3(0,1,0), 0.0*PI), Vector3(0.04,0,0)));
		Bone@ leftUpperArm = obj.ragdoll.addBone("left_upperarm", "bone_arm_upper_left", Transform(Quaternion(Vector3(0,1,0), 0.5*PI), Vector3(0.20,0,0)));
		Bone@ leftLowerArm = obj.ragdoll.addBone("left_lowerarm", "bone_arm_lower_left", Transform(Quaternion(Vector3(0,1,0), 0.5*PI), Vector3(0.15,0,0)));
		Bone@ leftHand = obj.ragdoll.addBone("left_hand", "bone_hand_left", Transform(Quaternion(), Vector3(0.09,0.01,-0.02)));
		Bone@ rightUpperArm = obj.ragdoll.addBone("right_upperarm", "bone_arm_upper_right", Transform(Quaternion(Vector3(0,1,0), 0.5*PI), Vector3(0.20,0,0)));
		Bone@ rightLowerArm = obj.ragdoll.addBone("right_lowerarm", "bone_arm_lower_right", Transform(Quaternion(Vector3(0,1,0), 0.5*PI), Vector3(0.15,0,0)));
		Bone@ rightHand = obj.ragdoll.addBone("right_hand", "bone_hand_right", Transform(Quaternion(), Vector3(0.09,0.01,-0.02)));	
		Bone@ leftUpperLeg = obj.ragdoll.addBone("left_upperleg", "bone_leg_upper_left", Transform(Quaternion(Vector3(0,1,0), 0.5*PI), Vector3(0.25,0,0)));
		Bone@ leftLowerLeg = obj.ragdoll.addBone("left_lowerleg", "bone_leg_lower_left", Transform(Quaternion(Vector3(0,1,0), 0.5*PI), Vector3(0.2,0,0)));
		Bone@ leftFoot = obj.ragdoll.addBone("left_foot", "bone_ankle_left", Transform(Quaternion(Vector3(0,0,1), 0.0*PI), Vector3(0.07,0.0,-0.1)));
		Bone@ rightUpperLeg = obj.ragdoll.addBone("right_upperleg", "bone_leg_upper_right", Transform(Quaternion(Vector3(0,1,0), 0.5*PI), Vector3(0.25,0,0)));
		Bone@ rightLowerLeg = obj.ragdoll.addBone("right_lowerleg", "bone_leg_lower_right", Transform(Quaternion(Vector3(0,1,0), 0.5*PI), Vector3(0.2,0,0)));
		Bone@ rightFoot = obj.ragdoll.addBone("right_foot", "bone_ankle_right", Transform(Quaternion(Vector3(0,0,1), 0.0*PI), Vector3(0.07,0.0,-0.1)));
				
	////////////////
	//Root
	////////////////
		// root1 (positioned below pelvis)
		@root1.proxy = MAIN_SCENE.world.createProxy(dynamic);
		root1.proxy.addCapsule(0.09, 0.15, density);
		root1.proxy.collisionGroupBitmask = bitCat;
		root1.proxy.collidesWithBitmask = bitCol;
	////////////////
	//Spine
	////////////////
		
		//spine1
		Vector3 spine1Anchor = skelRoot1.position;
		Quaternion spine1Jnt = skelRoot1.quaternion;
		@spine1.proxy = MAIN_SCENE.world.createProxy(dynamic);
		spine1.proxy.addCapsule(0.09, 0.15, density);
		spine1.proxy.collisionGroupBitmask = bitCat;
		spine1.proxy.collidesWithBitmask = bitCol;
		ConeTwistJoint@ s1Joint = MAIN_SCENE.world.createConeTwistJoint(spine1, root1, spine1Anchor, 
			spine1Jnt.rotVector3(Vector3(0,0,1)), spine1Jnt.rotVector3(Vector3(0,1,0)));
		s1Joint.setSwingSpan1(0.01*PI);
		s1Joint.setSwingSpan2(0.01*PI);
		s1Joint.setTwistSpan(0.01*PI);

		//spine2
		Vector3 spine2Anchor = skelSpine2.position;
		Quaternion spine2Jnt = skelSpine2.quaternion;
		@spine2.proxy = MAIN_SCENE.world.createProxy(dynamic);
		spine2.proxy.addCapsule(0.09, 0.15, density);
		spine2.proxy.collisionGroupBitmask = bitCat;
		spine2.proxy.collidesWithBitmask = bitCol;
		ConeTwistJoint@ s2Joint = MAIN_SCENE.world.createConeTwistJoint(spine2, spine1, spine2Anchor, 
			 spine2Jnt.rotVector3(Vector3(0,0,1)), spine2Jnt.rotVector3(Vector3(0,1,0)));
		s2Joint.setSwingSpan1(0.01*PI);
		s2Joint.setSwingSpan2(0.01*PI);
		s2Joint.setTwistSpan(0.01*PI);
		
		//spine3
		Vector3 spine3Anchor = skelSpine3.position;
		Quaternion spine3Jnt = skelSpine3.quaternion;
		@spine3.proxy = MAIN_SCENE.world.createProxy(dynamic);
		spine3.proxy.addCapsule(0.09, 0.2, density);
		spine3.proxy.collisionGroupBitmask = bitCat;
		spine3.proxy.collidesWithBitmask = bitCol;
		ConeTwistJoint@ s3Joint = MAIN_SCENE.world.createConeTwistJoint(spine3, spine2, spine3Anchor, 
			 spine3Jnt.rotVector3(Vector3(0,0,1)), spine3Jnt.rotVector3(Vector3(0,1,0)));
		s3Joint.setSwingSpan1(0.01*PI);
		s3Joint.setSwingSpan2(0.01*PI);
		s3Joint.setTwistSpan(0.01*PI);	
		
	////////////////
	//Head
	////////////////
		// head bone
		Vector3 headAnchor = skelHead.position;
		Quaternion headJnt = skelHead.quaternion;
		@head.proxy = MAIN_SCENE.world.createProxy(dynamic);
		head.proxy.addCapsule(0.09, 0.14, density);
		head.proxy.collisionGroupBitmask = bitCat;
		head.proxy.collidesWithBitmask = bitCol;
		ConeTwistJoint@ hJoint = MAIN_SCENE.world.createConeTwistJoint(head, spine3, headAnchor, 
			headJnt.rotVector3(Vector3(0,0,1)), headJnt.rotVector3(Vector3(0,1,0)));
		hJoint.setSwingSpan1(0.0*PI); // tilt left/right
		hJoint.setSwingSpan2(0.0*PI); // look left/right
		hJoint.setTwistSpan(0.12*PI); // tilt backward/forward

	////////////////
	//Left arm
	////////////////
		//left upper arm bone
		Vector3 leftShoulderAnchor = skelLeftUpperArm.position;
		Quaternion leftShoulderJnt = skelLeftUpperArm.quaternion;
		@leftUpperArm.proxy = MAIN_SCENE.world.createProxy(dynamic);
		leftUpperArm.proxy.addCapsule(0.03, 0.24, density);
		leftUpperArm.proxy.collisionGroupBitmask = bitCat;
		leftUpperArm.proxy.collidesWithBitmask = bitCol;
		UniversalJoint@ luaJoint = MAIN_SCENE.world.createUniversalJoint(leftUpperArm, spine3, leftShoulderAnchor, 
			 leftShoulderJnt.rotVector3(Vector3(0,0,1)), leftShoulderJnt.rotVector3(Vector3(0,1,0)));
		luaJoint.setLowerAngLimit(-0.0*PI, 0);
		luaJoint.setUpperAngLimit(0.45*PI, 0); // towards chest
		luaJoint.setLowerAngLimit(-0.45*PI, 1);
		luaJoint.setUpperAngLimit(0.75*PI, 1); // up
		
		// left lower arm bone
		Vector3 leftElbowAnchor = skelLeftLowerArm.position;
		Quaternion leftElbowJnt = skelLeftLowerArm.quaternion;
		@leftLowerArm.proxy = MAIN_SCENE.world.createProxy(dynamic);
		leftLowerArm.proxy.addCapsule(0.03, 0.25, density);
		leftLowerArm.proxy.collisionGroupBitmask = bitCat;
		leftLowerArm.proxy.collidesWithBitmask = bitCol;
		HingeJoint@ llaJoint = MAIN_SCENE.world.createHingeJoint(leftLowerArm, leftUpperArm, leftElbowAnchor, 
			 leftElbowJnt.rotVector3(Vector3(0,0,1)));
		llaJoint.setLowerAngLimit(-0.75*PI); // towards shoulder
		llaJoint.setUpperAngLimit(0.0*PI);
		
		// left hand bone
		Vector3 leftWristAnchor = skelLeftHand.position;
		Quaternion leftWristJnt = skelLeftHand.quaternion;
		@leftHand.proxy = MAIN_SCENE.world.createProxy(dynamic);
		leftHand.proxy.addBox(0.18, 0.03, 0.11, density);
		leftHand.proxy.collisionGroupBitmask = bitCat;
		leftHand.proxy.collidesWithBitmask = bitCol;
		ConeTwistJoint@ lhJoint = MAIN_SCENE.world.createConeTwistJoint(leftHand, leftLowerArm, leftWristAnchor, 
			 leftWristJnt.rotVector3(Vector3(0,0,1)), leftWristJnt.rotVector3(Vector3(0,1,0)));
		lhJoint.setSwingSpan1(0.2*PI);
		lhJoint.setSwingSpan2(0.25*PI); // up
		lhJoint.setTwistSpan(0.0*PI);

	////////////////
	//Right arm
	////////////////	
		// right upper arm bone
		Vector3 rightShoulderAnchor = skelRightUpperArm.position;
		Quaternion rightShoulderJnt = skelRightUpperArm.quaternion;
		@rightUpperArm.proxy = MAIN_SCENE.world.createProxy(dynamic);
		rightUpperArm.proxy.addCapsule(0.03, 0.24, density);
		rightUpperArm.proxy.collisionGroupBitmask = bitCat;
		rightUpperArm.proxy.collidesWithBitmask = bitCol;
		UniversalJoint@ ruaJoint = MAIN_SCENE.world.createUniversalJoint(rightUpperArm, spine3, rightShoulderAnchor, 
			 rightShoulderJnt.rotVector3(Vector3(0,0,1)), rightShoulderJnt.rotVector3(Vector3(0,1,0)));
		ruaJoint.setLowerAngLimit(-0.0*PI, 0);
		ruaJoint.setUpperAngLimit(0.45*PI, 0); // towards chest
		ruaJoint.setLowerAngLimit(-0.45*PI, 1);
		ruaJoint.setUpperAngLimit(0.75*PI, 1); // up
		
		// right lower arm bone
		Vector3 rightElbowAnchor = skelRightLowerArm.position;
		Quaternion rightElbowJnt = skelRightLowerArm.quaternion;
		@rightLowerArm.proxy = MAIN_SCENE.world.createProxy(dynamic);
		rightLowerArm.proxy.addCapsule(0.03, 0.18, density);
		rightLowerArm.proxy.collisionGroupBitmask = bitCat;
		rightLowerArm.proxy.collidesWithBitmask = bitCol;
		HingeJoint@ rlaJoint = MAIN_SCENE.world.createHingeJoint(rightLowerArm, rightUpperArm, rightElbowAnchor, 
			 rightElbowJnt.rotVector3(Vector3(0,0,1))); 
		rlaJoint.setLowerAngLimit(-0.75*PI); // towards shoulder
		rlaJoint.setUpperAngLimit(0.0*PI);
		
		// right hand bone
		Vector3 rightWristAnchor = skelRightHand.position;
		Quaternion rightWristJnt = skelRightHand.quaternion;
		@rightHand.proxy = MAIN_SCENE.world.createProxy(dynamic);
		rightHand.proxy.addBox(0.18, 0.03, 0.11, density);
		rightHand.proxy.collisionGroupBitmask = bitCat;
		rightHand.proxy.collidesWithBitmask = bitCol;
		ConeTwistJoint@ rhJoint = MAIN_SCENE.world.createConeTwistJoint(rightHand, rightLowerArm, rightWristAnchor, 
			 rightWristJnt.rotVector3(Vector3(0,0,1)), rightWristJnt.rotVector3(Vector3(0,1,0)));
		rhJoint.setSwingSpan1(0.2*PI);
		rhJoint.setSwingSpan2(0.25*PI); // up
		rhJoint.setTwistSpan(0.0*PI);

	////////////////
	//Left leg
	////////////////	
		// left upper leg bone
		Vector3 leftUpperLegAnchor = skelLeftUpperLeg.position;
		Quaternion leftUpperLegJnt = skelLeftUpperLeg.quaternion;
		@leftUpperLeg.proxy = MAIN_SCENE.world.createProxy(dynamic);
		leftUpperLeg.proxy.addCapsule(0.06, 0.4, density);
		leftUpperLeg.proxy.collisionGroupBitmask = bitCat;
		leftUpperLeg.proxy.collidesWithBitmask = bitCol;
		UniversalJoint@ lulJoint = MAIN_SCENE.world.createUniversalJoint(leftUpperLeg, root1, leftUpperLegAnchor, 
			 Vector3(0,0,1), Vector3(1,0,0));
		lulJoint.setLowerAngLimit(-0.45*PI, 0); // towards chest
		lulJoint.setUpperAngLimit(0.0*PI, 0); // towards back
		lulJoint.setLowerAngLimit(-0.1*PI, 1); // towards (his) right
		lulJoint.setUpperAngLimit(0.25*PI, 1); // towards (his) left

		// left lower leg bone
		Vector3 leftLowerLegAnchor = skelLeftLowerLeg.position;
		Quaternion leftLowerLegJnt = skelLeftLowerLeg.quaternion;
		@leftLowerLeg.proxy = MAIN_SCENE.world.createProxy(dynamic);
		leftLowerLeg.proxy.addCapsule(0.06, 0.3, density);
		leftLowerLeg.proxy.collisionGroupBitmask = bitCat;
		leftLowerLeg.proxy.collidesWithBitmask = bitCol;	
		HingeJoint@ lllJoint = MAIN_SCENE.world.createHingeJoint(leftLowerLeg, leftUpperLeg, leftLowerLegAnchor, 
			 leftLowerLegJnt.rotVector3(Vector3(0,0,1)));
		lllJoint.setLowerAngLimit(-0.0*PI); // towards chest
		lllJoint.setUpperAngLimit(0.6*PI); // towards back

		// left foot bone
		Vector3 leftFootAnchor = skelLeftFoot.position;
		Quaternion leftFootJnt = skelLeftFoot.quaternion;
		@leftFoot.proxy = MAIN_SCENE.world.createProxy(dynamic);
		leftFoot.proxy.addBox(0.06, 0.12, 0.3, density);
		leftFoot.proxy.collisionGroupBitmask = bitCat;
		leftFoot.proxy.collidesWithBitmask = bitCol;
		UniversalJoint@ lfJoint = MAIN_SCENE.world.createUniversalJoint(leftFoot, leftLowerLeg, leftFootAnchor, 
			 leftFootJnt.rotVector3(Vector3(0,1,0)), leftFootJnt.rotVector3(Vector3(1,0,0)));
		lfJoint.setLowerAngLimit(-0.0*PI, 0); // towards (his) left
		lfJoint.setUpperAngLimit(0.0*PI, 0); // towards (his) right
		lfJoint.setLowerAngLimit(-0.25*PI, 1); // down
		lfJoint.setUpperAngLimit(0.0*PI, 1); // up	

	////////////////
	//Right leg	
	////////////////
		// right upper leg bone
		Vector3 rightUpperLegAnchor = skelRightUpperLeg.position;
		Quaternion rightUpperLegJnt = skelRightUpperLeg.quaternion;
		@rightUpperLeg.proxy = MAIN_SCENE.world.createProxy(dynamic);
		rightUpperLeg.proxy.addCapsule(0.06, 0.4, density);
		rightUpperLeg.proxy.collisionGroupBitmask = bitCat;
		rightUpperLeg.proxy.collidesWithBitmask = bitCol;
		UniversalJoint@ rulJoint = MAIN_SCENE.world.createUniversalJoint(rightUpperLeg, root1, rightUpperLegAnchor, 
			 Vector3(0,0,1), Vector3(1,0,0));
		rulJoint.setLowerAngLimit(-0.45*PI, 0); // towards chest
		rulJoint.setUpperAngLimit(0.0*PI, 0); // towards back
		rulJoint.setLowerAngLimit(-0.25*PI, 1); // towards (his) right
		rulJoint.setUpperAngLimit(0.1*PI, 1); // towards (his) left	
		
		// right lower leg bone
		Vector3 rightLowerLegAnchor = skelRightLowerLeg.position;
		Quaternion rightLowerLegJnt = skelRightLowerLeg.quaternion;
		@rightLowerLeg.proxy = MAIN_SCENE.world.createProxy(dynamic);
		rightLowerLeg.proxy.addCapsule(0.06, 0.3, density);
		rightLowerLeg.proxy.collisionGroupBitmask = bitCat;
		rightLowerLeg.proxy.collidesWithBitmask = bitCol;	
		HingeJoint@ rllJoint = MAIN_SCENE.world.createHingeJoint(rightLowerLeg, rightUpperLeg, rightLowerLegAnchor, 
			 rightLowerLegJnt.rotVector3(Vector3(0,0,1)));
		rllJoint.setLowerAngLimit(-0.0*PI); // towards chest
		rllJoint.setUpperAngLimit(0.6*PI); // towards back
		
		// right foot bone
		Vector3 rightFootAnchor = skelRightFoot.position;
		Quaternion rightFootJnt = skelRightFoot.quaternion;
		@rightFoot.proxy = MAIN_SCENE.world.createProxy(dynamic);
		rightFoot.proxy.addBox(0.06, 0.12, 0.3, density);
		rightFoot.proxy.collisionGroupBitmask = bitCat;
		rightFoot.proxy.collidesWithBitmask = bitCol;	
		UniversalJoint@ rfJoint = MAIN_SCENE.world.createUniversalJoint(rightFoot, rightLowerLeg, rightFootAnchor, 
			 rightFootJnt.rotVector3(Vector3(0,1,0)), rightFootJnt.rotVector3(Vector3(1,0,0)));
		rfJoint.setLowerAngLimit(-0.0*PI, 0); // towards (his) left
		rfJoint.setUpperAngLimit(0.0*PI, 0); // towards (his) right
		rfJoint.setLowerAngLimit(-0.25*PI, 1); // down
		rfJoint.setUpperAngLimit(0.0*PI, 1); // up
	}

	void startPlayerSync()
	{
		@mUpdateTimer = CONTROL.createTimer(33, true);
		mUpdateTimer.elapsed += Action(this.syncPlayer);
		mUpdateTimer.start();
	}

	void fireWeapon(WeaponType t, Transform &in xform)
	{
		if (mSpawned == false) return;

		FireWeapon fw;
		fw.weaponType = pUByte(t);
		fw.xForm = xform;
		fw.id = Me.id;


		mPeer.send(fw, mServer, NR_RELIABLE, NP_IMMEDIATE, OC_WeaponSync);
	}

}
