#include "Messages.as"
#include "NetworkPlayer.as"



class Host
{
	private NetworkPeer mPeer;
	private Map<pUByte, PeerID@> mConnectedPlayers;
	private Map<pUByte, Vector3> mPlayerPositions;
	private pUByte mNextPeerID = 0;
	bool	mGameStarted = false;
	pUInt 	mMaxUsers = 0;
	pUInt 	mFragLimit = 0;
	
	int spawnNr;
	
	// void statPrinter()
	// {
		// echo ("Host: Connected clients:");
		// mPeer.printStats();
	// }
	
	
	void StartServer(pUInt port, pUInt maxUsers, String Passwrd)
	{
		//We expect the following messages...
		mPeer.registerMessageClass(NewUser(), NetMessageCallback(this.handleNewUser));
		mPeer.registerMessageClass(SyncPlayer(), NetMessageCallback(this.handleSyncPlayer));
		mPeer.registerMessageClass(FireWeapon(), NetMessageCallback(this.handleFireWeapon));
		mMaxUsers = maxUsers;
		
		//Start host.
		mPeer.host(port, maxUsers, ConStateCallback(this.ConnectionStateCB), Passwrd);
		
		//spawnNr = rand() % LEVEL.spawnLocations.length();
		spawnNr = rand() % 8;
		// @statTimer = CONTROL.createTimer(5000, true);
		
		// statTimer.elapsed += Action(this.statPrinter);
		// echo ("STARTING TIMER!");
		// statTimer.start();
	}
	
	void shutDown()
	{
		mPeer.shutDown();
		mConnectedPlayers.clear();
		mPlayerPositions.clear();
		mNextPeerID = 0;
		mGameStarted = false;
	}

	void ConnectionStateCB(pConnectionState state, PeerID@ peerID, pInt receipt)
	{
		switch (state)
		{
		case CS_NEWCONNECTION:
			handleNewConnection(peerID);
			break;
		case CS_CLIENTLOST:{
				ClientPlayer@ p = cast<ClientPlayer>(peerID.userRef);
				p.connected = false;
				
				PlayerLeft pl;
				pl.id = p.id;
				pl.state = pUInt(state);
				
				echo ("Sending player left message ");
				mPeer.send(pl, peerID, NR_RELIABLE, NP_IMMEDIATE, OC_Generic, true);
			}
			break;
		default:
			echo ("Unknown message : " + String(state));
		}

	}
	
	bool checkMessageType (iNetMessage@ _message, MessageType mt, String func, String type)
	{
		MessageType t = MessageType(_message.getType());
		if (t != mt) {
			echo ("Received a messages in my" + func + " that wasn't" + type + "! What is this!? Piko3D is broken! (or I made a copy/paste error)"); 
			return false;
		}
		return true;
	}
	
	void handleNewConnection(PeerID@ peer)
	{
		echo ("A new peer has connected!\n"); 
		if (peer.userRef is null) {
			//a new, unknown user.
			ClientPlayer@ p = ClientPlayer(mNextPeerID++, WeaponHitPlayerCallback(this.hitCallback), SpawnPlayerCallback(this.spawn));
			@peer.userRef = p;
			@mConnectedPlayers[p.id] = peer;
			mPlayerPositions[p.id] = Vector3(0,0,0);
			
			//Assign the new peer their ID:
		
			AssignID aid(p.id);
			mPeer.send(aid, peer, NR_RELIABLE, NP_IMMEDIATE, OC_Generic);
		}  else {
			echo ("I KNOW THIS GUY!!\n");
		}
		//if the userRef is already set, than this peer is reconnecting.

		ClientPlayer@ p = cast<ClientPlayer>(peer.userRef);
		p.connected = true;
	}
	
	void handleNewUser(iNetMessage@ _message, PeerID@ peer)
	{
	
		if (!checkMessageType(_message, MT_NewUser, "handleNewUser", "NewUser")) return;
		NewUser@ message = cast<NewUser>(_message);
		
		if (peer.userRef is null) {
			echo ("An unknown user send us a message some how?! Dropping connection...");
			mPeer.closeConnection(peer);
			return;
		}
		
		ClientPlayer@ p = cast<ClientPlayer>(peer.userRef);
		p.username = message.name;
		echo ("Welcome " + p.username + "!!!\n");
		
		PlayerJoined pj;
		pj.name = message.name;
		pj.id = p.id;
		
		//Tell everyone else this player joined.
		mPeer.send(pj, peer, NR_RELIABLE_ORDERED, NP_IMMEDIATE, OC_Generic, true);

		//Tell this player what settings we are using...
		GameSettings gs;
		gs.maxPlayerCount = mMaxUsers;
		gs.fragLimit = mFragLimit;
		
		mPeer.send(gs, peer, NR_RELIABLE_ORDERED, NP_HIGH, OC_Generic);
		
		//Tell this player who else is already connected....
		for(auto it = mConnectedPlayers.begin(); it++;) {
			ClientPlayer@ np = cast<ClientPlayer>(it.value.userRef);
			if (np.id == p.id) continue;
			if (np.connected == false) continue;
			
			PlayerJoined pj2;
			pj2.name = np.username;
			pj2.id = np.id;
			pj2.kills = np.kills;
			pj2.deaths = np.deaths;
			pj2.spawned = mGameStarted;
			
			mPeer.send(pj2, peer, NR_RELIABLE_ORDERED, NP_HIGH, OC_Generic);
		}
		
		if (mGameStarted)
			p.lateSpawn();
		
		//spawn(p);
		//startGame();
	}
	
	void reset()
	{
		for(auto it = mConnectedPlayers.begin(); it++;) {
			ClientPlayer@ np = cast<ClientPlayer>(it.value.userRef);
			np.deaths = 0;
			np.kills = 0;
			np.dead = false;
			np.health = 100;
		}
	}
		
	void startGame()
	{
		reset();
		
		mGameStarted = true;
			
		GameStart gs;
		mPeer.send(gs, null, NR_RELIABLE_ORDERED, NP_IMMEDIATE, OC_Generic, true);

		for(auto it = mConnectedPlayers.begin(); it++;) {
			ClientPlayer@ np = cast<ClientPlayer>(it.value.userRef);
			spawn(np);
		}
	}
	
	void spawn(ClientPlayer@ player, bool lateSpawn = false)
	{ 
		if (lateSpawn) {
			auto@ peer = mConnectedPlayers[player.id];

			//Let's find the peer here, and send him/her a game start message!
			GameStart gs;
			mPeer.send(gs, peer, NR_RELIABLE_ORDERED, NP_IMMEDIATE, OC_Generic);
		}
		
		player.health = 100;
		echo ("spawning player with id: " + String(player.id) + "\n");
		SpawnPlayer sp;
		sp.id = player.id;
		//manage spawn positions some how.
		
		sp.xForm  = Transform(Quaternion(), LEVEL.spawnLocations[spawnNr++ % 8]);

		mPeer.send(sp, null, NR_RELIABLE_ORDERED, NP_IMMEDIATE, OC_Generic, true);
	}

	void handleFireWeapon(iNetMessage@ message, PeerID@ peer)
	{
		if (!checkMessageType(message, MT_FireWeapon, "handleFireWeapon", "FireWeapon")) return;
		
		echo ("Fire!!");
		
		NetworkPlayer@ np = cast<NetworkPlayer>(peer.userRef);
		if (np.health  <= 0)
		{
			echo ("A dead player can't fire weapons!");
			return; //player can't fire a weapon! They're dead!
		}

		FireWeapon@ fw = cast<FireWeapon>(message);
		//Send everyone else the weapon message.
		
		ClientPlayer@ cp = cast<ClientPlayer>(peer.userRef);

		//Fire the actual weapon ....
		Weapon@ weapon = cp.weapons[WeaponType(fw.weaponType)];
		//if (!weapon.fire(fw.xForm, cp.id)) return;
		bool pick = weapon.pick(fw.xForm);

		
		if (!pick)
		return;
		//Let the others know a weapon was fired.
		mPeer.send(message, peer, NR_RELIABLE, NP_IMMEDIATE, OC_WeaponSync, true);
	}
	
		
	void hitCallback(WeaponType type, Object@ obj, Vector3 pos, Vector3 normal, uint damage, pUByte id)
	{
		echo("checking obj null");
		if (obj is null) return;
			

				
		PlayerInfo@ pi = cast<PlayerInfo>(obj.userRef);
		
		for(auto it = mPlayerPositions.begin(); it++;){
			//if (it.key+" "+it.value+"\n");
			Vector3 v = (pos - it.value);
			//echo("checking positions "+String(v.length()));
			echo("checking positions "+it.value.toString());
			if (v.length() < 2.0 && pi is null) {
				handleHitDamage(type, it.key, pos, normal, 20, id);
			}
		}
		if (pi is null) return;
		handleHitDamage(type, pi.networkID, pos, normal, damage, id);
	} 

	void handleHitDamage(WeaponType type, pUByte netId, Vector3 pos, Vector3 normal, uint damage, pUByte id) {
				
		HitDamage hd;
		hd.id = netId;
		hd.damage = damage;
		hd.normal = normal;
		hd.position = pos;
		
		mPeer.send(hd, null, NR_RELIABLE, NP_IMMEDIATE, OC_WeaponSync ,true);

		auto pid = mConnectedPlayers[netId];
		ClientPlayer@ cp = cast<ClientPlayer>(pid.userRef);
		if (cp is null) {
			echo ("ERROR! I hit someone who isn't connected!? What the fuck!?!?!?!?");
			return;
		}
		
		cp.health -= damage;
		
		//echo ("Damage: " + String(damage));
		//echo ("Health: " + String(cp.health));
		
		
		if (cp.health > 0) return;
		if (cp.dead) return;

		cp.die();
		//He dead!
		PlayerDied pd;
		pd.killer_id = id;
		pd.killed_id = netId;
		pd.ragdoll = (damage < 100) ? true : false;

		echo ("Host: Player" + String(pd.killer_id) + " killed " + String(pd.killed_id));
		
		
		auto killer_pid = mConnectedPlayers[id];
		ClientPlayer@ killer_cp = cast<ClientPlayer>(killer_pid.userRef);
		killer_cp.kills++;
		
		pd.weaponType = pUByte(type);
		mPeer.send(pd, null, NR_RELIABLE_ORDERED, NP_IMMEDIATE, OC_WeaponSync ,true);
		
		//Win condition...
		if (killer_cp.kills >= mFragLimit)
		{
			mGameStarted = false;
			GameEnd gameEnd;
			gameEnd.winner = id;
			mPeer.send(gameEnd, null, NR_RELIABLE_ORDERED, NP_IMMEDIATE, OC_WeaponSync, true);
		}
	}


	
	void handleSyncPlayer(iNetMessage@ _message, PeerID@ peer) 
	{
		if (!checkMessageType(_message, MT_SyncPlayer, "handleSyncPlayer", "SyncPlayer")) return;
		NetworkPlayer@ np = cast<NetworkPlayer>(peer.userRef);
		if (np.health  <= 0) return; //player can't move! They're dead!
		
		// temp code to chec if player is too far from center of level and kill them
		SyncPlayer pm = cast<SyncPlayer>(_message);
		ClientPlayer@ cp = cast<ClientPlayer>(peer.userRef);
		if (pm.xForm.position.length() > 300 && !cp.dead) {
			cp.die();
			//np.dead = true;
			PlayerDied pd;
			pd.killer_id = np.id;
			pd.killed_id = np.id;			
			mPeer.send(pd, null, NR_RELIABLE, NP_IMMEDIATE, 1 ,true);
		} 
		
		if (LEVEL !is null)
		{
			mPlayerPositions.erase(np.id);
			mPlayerPositions[np.id] = pm.xForm.position;
			//echo("player "+String(np.id)+" position "+mPlayerPositions[np.id].toString());
			for (uint i = 0; i < LEVEL.arrHealthPickup.length(); i++) {
				//echo("foo "+String(LEVEL.arrHealthPickupTaken[i]));
				if (LEVEL.arrHealthPickup[i].containsPoint(pm.xForm.position) && LEVEL.arrHealthPickupTaken[i] == 0) {
					if (np.health < 120) {
						if (np.health+50 < 121) 
							np.health += 50;
						else 
							np.health = 120;
						
						LEVEL.arrHealthPickupTaken[i] = 1500;
						
						ManagePickup pickupMessage;
						pickupMessage.id = i;
						pickupMessage.health = np.health;
						pickupMessage.player_id = np.id;
						pickupMessage.picked = true;
						mPeer.send(pickupMessage, null, NR_RELIABLE, NP_IMMEDIATE, OC_WeaponSync ,true);				
					}
				} else if (LEVEL.arrHealthPickupTaken[i] > 0) {
					//echo(String(LEVEL.arrHealthPickupTaken[i]));
					LEVEL.arrHealthPickupTaken[i] -= 1;
					if (LEVEL.arrHealthPickupTaken[i] == 0) {
						ManagePickup pickupMessage;
						pickupMessage.id = i;
						pickupMessage.picked = false;
						mPeer.send(pickupMessage, null, NR_RELIABLE, NP_IMMEDIATE, OC_WeaponSync ,true);					
					}
				}
			}
		}
		
		SyncPlayer@ message = cast<SyncPlayer>(_message);
		
		mPeer.send(message, peer, NR_UNRELIABLE_SEQUENCED, NP_MEDIUM, OC_PlayerSync, true);
	}
}