//Message types
enum OrderingChannels
{
	OC_Generic = 0,
	OC_PlayerSync = 1,
	OC_WeaponSync = 2,
}


enum MessageType
{
	MT_AssignID,
	MT_NewUser,
	MT_PlayerJoined, 
	MT_SpawnPlayer,
	MT_SyncPlayer,
	MT_FireWeapon,
	MT_HitDamage,
	MT_PlayerDied,
	MT_PlayerLeft,
	MT_ManagePickup,
	MT_GameStart,
	MT_GameEnd,
	MT_GameSettings,
}

class GameStart: iNetMessage
{
	pUByte getType() { return pUByte(MT_GameStart); }
}

class GameEnd: iNetMessage
{
	pUByte getType() { return pUByte(MT_GameEnd); }
	pUByte winner;
}

class GameSettings : iNetMessage
{
	pUByte getType() { return pUByte(MT_GameSettings); }
	pByte maxPlayerCount;
	pByte fragLimit;
}

class FireWeapon : iNetMessage
{
	pUByte getType() { return pUByte(MT_FireWeapon); }
	pUByte id;
	pUByte weaponType;
	Transform xForm;
}

class HitDamage : iNetMessage
{
	pUByte getType() { return pUByte(MT_HitDamage); }
	pUByte id;
	pUByte damage;
	bool headShot = false;
	Vector3 position;
	Vector3 normal;
}

class PlayerDied : iNetMessage
{
	pUByte getType() { return pUByte(MT_PlayerDied); }
	pUByte killed_id;
	pUByte killer_id;
	pUByte weaponType;
	bool ragdoll;
}

class AssignID : iNetMessage
{
	AssignID(){}
	AssignID(pUByte _id) { id = _id;}
	pUByte getType() { return pUByte(MT_AssignID); }
	pUByte id;
}

class NewUser : iNetMessage
{
	pUByte getType() { return pUByte(MT_NewUser); }
	String name;
}

class PlayerJoined : iNetMessage
{
	pUByte getType() { return pUByte(MT_PlayerJoined); }
	String name;
	pUByte id;
	pUByte kills = 0;
	pUByte deaths = 0;
	bool spawned = false;
}

class PlayerLeft : iNetMessage
{
	pUByte getType() { return pUByte(MT_PlayerLeft); }
	pUByte id;
	pUInt state;
}

// class PlayerDisconnected: iNetMessage
// {
	// pUByte getType() { return pUByte(MT_PlayerDisconnected)
// }

class SpawnPlayer : iNetMessage
{
	pUByte getType() { return pUByte(MT_SpawnPlayer); }
	pUByte id;
	Transform xForm;
}

class SyncPlayer : iNetMessage
{
	pUByte getType() { return pUByte(MT_SyncPlayer); }
	bool opEquals(const SyncPlayer &in other) {
		return xForm == other.xForm && velocity == other.velocity;
	}
	pUByte id;
	Transform xForm;
	Vector3 velocity;
	Vector3 angVel;
	pUByte animState;
}

class ManagePickup : iNetMessage {
	pUByte getType() { return pUByte(MT_ManagePickup); }
	pUByte id;
	bool picked;
	pByte health;
	pUByte player_id;
}

