
class NetworkPlayer : iRefObj
{
	String username;
	pUByte id = 0;
	pUByte kills = 0;
	pUByte deaths = 0;
	bool connected = false;
	bool dead = false;
	pByte health = 100;
	bool winner = false;
	
	Map<WeaponType, Weapon@> weapons;	

	Object@ obj;
	Object@ weaponObj;
	Label@ nameLbl;
	Emitter@ emitter = Emitter();
	NetworkPlayer() {}

	NetworkPlayer(pUByte _id)
	{
		id = _id;
	}
	
	~NetworkPlayer()
	{
		echo("NetworkPlayer destroyed...\n");
	}
	
	void live() {
		dead = false;
	}
}

funcdef void SpawnPlayerCallback(ClientPlayer@, bool late);
funcdef void WeaponHitPlayerCallback(WeaponType, Object@, Vector3, Vector3, uint, pUByte);


class ClientPlayer : NetworkPlayer
{
	WeaponHitPlayerCallback@ mHitCallback;
	bool mLate = false;
	ClientPlayer(pUByte _id, WeaponHitPlayerCallback@ cb, SpawnPlayerCallback@ spcb)
	{
		@mHitCallback = cb;
		@spawnCallback = spcb;
		super (_id);
		//200 ms leeway on cooldown verification
		@weapons[WT_RayGun] = RayGun(100, 800, WeaponHitCallback(this.hitCallback));
		respawnTimer.elapsed += Action(this.respawn);
	}
	
	void hitCallback(WeaponType t, Object@ obj, Vector3 pos, Vector3 norm, uint damage)
	{
		mHitCallback(t, obj, pos, norm, damage, id);
	}

	void die()
	{
		dead = true;
		respawnTimer.start();
		deaths++;
	}

	
	
	void respawn()
	{
		if (mLate) {
			spawnCallback(this, mLate);
			mLate = false;
			return;
		}

		//dead = false;
		echo ("RESPAWNING!");
		spawnCallback(this, false);
		dead = false;
	}
	
	void lateSpawn() 
	{
		mLate = true;
		respawnTimer.start();
	}

	SpawnPlayerCallback@ spawnCallback;
	Timer@ respawnTimer = CONTROL.createTimer(pFloat(5000), false);
}
