/*
 * Decompiled with CFR 0.152.
 */
package processing.javafx;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.SynchronousQueue;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Cursor;
import javafx.scene.ImageCursor;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SceneAntialiasing;
import javafx.scene.canvas.Canvas;
import javafx.scene.image.Image;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.WritableImage;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.WindowEvent;
import javafx.util.Duration;
import processing.core.PApplet;
import processing.core.PImage;
import processing.core.PSurface;
import processing.javafx.PGraphicsFX2D;

public class PSurfaceFX
implements PSurface {
    PApplet sketch;
    PGraphicsFX2D fx;
    Stage stage;
    Canvas canvas;
    final Animation animation;
    float frameRate = 60.0f;
    private SynchronousQueue<Throwable> drawExceptionQueue = new SynchronousQueue();
    List<Image> iconImages;
    Cursor lastCursor = Cursor.DEFAULT;
    static Map<EventType<? extends MouseEvent>, Integer> mouseMap = new HashMap<EventType<? extends MouseEvent>, Integer>();

    static {
        mouseMap.put((EventType<? extends MouseEvent>)MouseEvent.MOUSE_PRESSED, 1);
        mouseMap.put((EventType<? extends MouseEvent>)MouseEvent.MOUSE_RELEASED, 2);
        mouseMap.put((EventType<? extends MouseEvent>)MouseEvent.MOUSE_CLICKED, 3);
        mouseMap.put((EventType<? extends MouseEvent>)MouseEvent.MOUSE_DRAGGED, 4);
        mouseMap.put((EventType<? extends MouseEvent>)MouseEvent.MOUSE_MOVED, 5);
        mouseMap.put((EventType<? extends MouseEvent>)MouseEvent.MOUSE_ENTERED, 6);
        mouseMap.put((EventType<? extends MouseEvent>)MouseEvent.MOUSE_EXITED, 7);
    }

    public PSurfaceFX(PGraphicsFX2D graphics) {
        this.fx = graphics;
        this.canvas = new ResizableCanvas();
        KeyFrame keyFrame = new KeyFrame(Duration.millis((double)1000.0), (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                long startNanoTime = System.nanoTime();
                try {
                    PSurfaceFX.this.sketch.handleDraw();
                }
                catch (Throwable e) {
                    PSurfaceFX.this.drawExceptionQueue.offer(e);
                    PSurfaceFX.this.animation.stop();
                    return;
                }
                long drawNanos = System.nanoTime() - startNanoTime;
                if (PSurfaceFX.this.sketch.exitCalled()) {
                    Platform.exit();
                }
                if (PSurfaceFX.this.sketch.frameCount > 5) {
                    PSurfaceFX.this.animation.setRate((double)(-PApplet.min(1.0E9f / (float)drawNanos, PSurfaceFX.this.frameRate)));
                }
            }
        }, new KeyValue[0]);
        this.animation = new Timeline(new KeyFrame[]{keyFrame});
        this.animation.setCycleCount(-1);
        this.animation.setRate((double)(-this.frameRate));
    }

    @Override
    public Object getNative() {
        return this.canvas;
    }

    @Override
    public void initOffscreen(PApplet sketch) {
    }

    @Override
    public void initFrame(PApplet sketch) {
        this.sketch = sketch;
        PApplicationFX.surface = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                Application.launch(PApplicationFX.class, (String[])new String[0]);
            }
        }).start();
        while (this.stage == null) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.startExceptionHandlerThread();
        this.setProcessingIcon(this.stage);
    }

    private void startExceptionHandlerThread() {
        Thread exceptionHandlerThread = new Thread(() -> {
            Throwable drawException;
            try {
                drawException = this.drawExceptionQueue.take();
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            if (drawException != null && !(drawException instanceof ThreadDeath)) {
                if (drawException instanceof RuntimeException) {
                    throw (RuntimeException)drawException;
                }
                if (drawException instanceof UnsatisfiedLinkError) {
                    throw new UnsatisfiedLinkError(drawException.getMessage());
                }
                throw new RuntimeException(drawException);
            }
        });
        exceptionHandlerThread.setDaemon(true);
        exceptionHandlerThread.setName("Processing-FX-ExceptionHandler");
        exceptionHandlerThread.start();
    }

    @Override
    public void setTitle(String title) {
        this.stage.setTitle(title);
    }

    @Override
    public void setVisible(final boolean visible) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (visible) {
                    PSurfaceFX.this.stage.show();
                    PSurfaceFX.this.canvas.requestFocus();
                } else {
                    PSurfaceFX.this.stage.hide();
                }
            }
        });
    }

    @Override
    public void setResizable(boolean resizable) {
        this.stage.setResizable(resizable);
    }

    @Override
    public void setIcon(PImage icon) {
        int w = icon.pixelWidth;
        int h = icon.pixelHeight;
        WritableImage im = new WritableImage(w, h);
        im.getPixelWriter().setPixels(0, 0, w, h, (PixelFormat)PixelFormat.getIntArgbInstance(), icon.pixels, 0, w);
        Stage stage = (Stage)this.canvas.getScene().getWindow();
        stage.getIcons().clear();
        stage.getIcons().add((Object)im);
    }

    protected void setProcessingIcon(Stage stage) {
        try {
            if (this.iconImages == null) {
                int[] sizes;
                this.iconImages = new ArrayList<Image>();
                int[] nArray = sizes = new int[]{48, 64, 128, 256, 512};
                int n = sizes.length;
                int n2 = 0;
                while (n2 < n) {
                    int sz = nArray[n2];
                    URL url = PApplet.class.getResource("/icon/icon-" + sz + ".png");
                    Image image = new Image(url.toString());
                    this.iconImages.add(image);
                    ++n2;
                }
            }
            ObservableList icons = stage.getIcons();
            icons.clear();
            icons.addAll(this.iconImages);
        }
        catch (Exception exception) {}
    }

    @Override
    public void setAlwaysOnTop(boolean always) {
        this.stage.setAlwaysOnTop(always);
    }

    @Override
    public void placeWindow(int[] location, int[] editorLocation) {
        if (this.sketch.sketchFullScreen()) {
            PApplet.hideMenuBar();
        }
        int wide = this.sketch.width;
        int high = this.sketch.height;
        if (location != null) {
            this.stage.setX((double)location[0]);
            this.stage.setY((double)location[1]);
        } else if (editorLocation != null) {
            int locationX = editorLocation[0] - 20;
            int locationY = editorLocation[1];
            if (locationX - wide > 10) {
                this.stage.setX((double)(locationX - wide));
                this.stage.setY((double)locationY);
            } else {
                locationX = (this.sketch.displayWidth - wide) / 2;
                locationY = (this.sketch.displayHeight - high) / 2;
                this.stage.setX((double)locationX);
                this.stage.setY((double)locationY);
            }
        }
        if (this.stage.getY() < 0.0) {
            this.stage.setY(30.0);
        }
        if (this.sketch.getGraphics().displayable()) {
            this.setVisible(true);
        }
    }

    @Override
    public void placePresent(int stopColor) {
        PApplet.hideMenuBar();
    }

    @Override
    public void setupExternalMessages() {
        this.stage.xProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> value, Number oldX, Number newX) {
                PSurfaceFX.this.sketch.frameMoved(newX.intValue(), PSurfaceFX.this.stage.yProperty().intValue());
            }
        });
        this.stage.yProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> value, Number oldY, Number newY) {
                PSurfaceFX.this.sketch.frameMoved(PSurfaceFX.this.stage.xProperty().intValue(), newY.intValue());
            }
        });
        this.stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent we) {
                PSurfaceFX.this.sketch.exit();
            }
        });
    }

    @Override
    public void setLocation(int x, int y) {
        this.stage.setX((double)x);
        this.stage.setY((double)y);
    }

    @Override
    public void setSize(int width, int height) {
        Scene scene = this.stage.getScene();
        double decorH = this.stage.getWidth() - scene.getWidth();
        double decorV = this.stage.getHeight() - scene.getHeight();
        this.stage.setWidth((double)width + decorH);
        this.stage.setHeight((double)height + decorV);
        this.fx.setSize(width, height);
    }

    public void setSmooth(int level) {
    }

    @Override
    public void setFrameRate(float fps) {
        if (fps > 0.0f) {
            this.frameRate = fps;
            this.animation.setRate((double)(-this.frameRate));
        }
    }

    @Override
    public void setCursor(int kind) {
        Cursor c;
        switch (kind) {
            case 0: {
                c = Cursor.DEFAULT;
                break;
            }
            case 1: {
                c = Cursor.CROSSHAIR;
                break;
            }
            case 12: {
                c = Cursor.HAND;
                break;
            }
            case 13: {
                c = Cursor.MOVE;
                break;
            }
            case 2: {
                c = Cursor.TEXT;
                break;
            }
            case 3: {
                c = Cursor.WAIT;
                break;
            }
            default: {
                c = Cursor.DEFAULT;
            }
        }
        this.lastCursor = c;
        this.canvas.getScene().setCursor(c);
    }

    @Override
    public void setCursor(PImage image, int hotspotX, int hotspotY) {
        int w = image.pixelWidth;
        int h = image.pixelHeight;
        WritableImage im = new WritableImage(w, h);
        im.getPixelWriter().setPixels(0, 0, w, h, (PixelFormat)PixelFormat.getIntArgbInstance(), image.pixels, 0, w);
        ImageCursor c = new ImageCursor((Image)im, (double)hotspotX, (double)hotspotY);
        this.lastCursor = c;
        this.canvas.getScene().setCursor((Cursor)c);
    }

    @Override
    public void showCursor() {
        this.canvas.getScene().setCursor(this.lastCursor);
    }

    @Override
    public void hideCursor() {
        this.canvas.getScene().setCursor(Cursor.NONE);
    }

    @Override
    public void startThread() {
        this.animation.play();
    }

    @Override
    public void pauseThread() {
        this.animation.pause();
    }

    @Override
    public void resumeThread() {
        this.animation.play();
    }

    @Override
    public boolean stopThread() {
        this.animation.stop();
        return true;
    }

    @Override
    public boolean isStopped() {
        return this.animation.getStatus() == Animation.Status.STOPPED;
    }

    protected void fxMouseEvent(MouseEvent fxEvent) {
        int count = fxEvent.getClickCount();
        int action = mouseMap.get(fxEvent.getEventType());
        int modifiers = 0;
        if (fxEvent.isShiftDown()) {
            modifiers |= 1;
        }
        if (fxEvent.isControlDown()) {
            modifiers |= 2;
        }
        if (fxEvent.isMetaDown()) {
            modifiers |= 4;
        }
        if (fxEvent.isAltDown()) {
            modifiers |= 8;
        }
        int button = 0;
        switch (fxEvent.getButton()) {
            case PRIMARY: {
                button = 37;
                break;
            }
            case SECONDARY: {
                button = 39;
                break;
            }
            case MIDDLE: {
                button = 3;
                break;
            }
        }
        if (PApplet.platform == 2 && fxEvent.isControlDown() && button == 37) {
            button = 39;
        }
        long when = System.currentTimeMillis();
        int x = (int)fxEvent.getX();
        int y = (int)fxEvent.getY();
        this.sketch.postEvent(new processing.event.MouseEvent(fxEvent, when, action, modifiers, x, y, button, count));
    }

    protected void fxScrollEvent(ScrollEvent fxEvent) {
        int count = (int)(-(fxEvent.getDeltaY() / fxEvent.getMultiplierY()));
        int action = 8;
        int modifiers = 0;
        if (fxEvent.isShiftDown()) {
            modifiers |= 1;
        }
        if (fxEvent.isControlDown()) {
            modifiers |= 2;
        }
        if (fxEvent.isMetaDown()) {
            modifiers |= 4;
        }
        if (fxEvent.isAltDown()) {
            modifiers |= 8;
        }
        int button = 0;
        long when = System.currentTimeMillis();
        int x = (int)fxEvent.getX();
        int y = (int)fxEvent.getY();
        this.sketch.postEvent(new processing.event.MouseEvent(fxEvent, when, action, modifiers, x, y, button, count));
    }

    protected void fxKeyEvent(KeyEvent fxEvent) {
        int action = 0;
        EventType et = fxEvent.getEventType();
        if (et == KeyEvent.KEY_PRESSED) {
            action = 1;
        } else if (et == KeyEvent.KEY_RELEASED) {
            action = 2;
        } else if (et == KeyEvent.KEY_TYPED) {
            action = 3;
        }
        int modifiers = 0;
        if (fxEvent.isShiftDown()) {
            modifiers |= 1;
        }
        if (fxEvent.isControlDown()) {
            modifiers |= 2;
        }
        if (fxEvent.isMetaDown()) {
            modifiers |= 4;
        }
        if (fxEvent.isAltDown()) {
            modifiers |= 8;
        }
        long when = System.currentTimeMillis();
        char keyChar = this.getKeyChar(fxEvent);
        int keyCode = this.getKeyCode(fxEvent);
        this.sketch.postEvent(new processing.event.KeyEvent(fxEvent, when, action, modifiers, keyChar, keyCode));
    }

    private int getKeyCode(KeyEvent fxEvent) {
        if (fxEvent.getEventType() == KeyEvent.KEY_TYPED) {
            return 0;
        }
        KeyCode kc = fxEvent.getCode();
        switch (kc) {
            case ALT_GRAPH: {
                return 18;
            }
        }
        return kc.impl_getCode();
    }

    private char getKeyChar(KeyEvent fxEvent) {
        KeyCode kc = fxEvent.getCode();
        switch (kc) {
            case SHIFT: 
            case CONTROL: 
            case ALT: 
            case PAUSE: 
            case CAPS: 
            case PAGE_UP: 
            case PAGE_DOWN: 
            case END: 
            case HOME: 
            case LEFT: 
            case UP: 
            case RIGHT: 
            case DOWN: 
            case NUM_LOCK: 
            case SCROLL_LOCK: 
            case F1: 
            case F2: 
            case F3: 
            case F4: 
            case F5: 
            case F6: 
            case F7: 
            case F8: 
            case F9: 
            case F10: 
            case F11: 
            case F12: 
            case PRINTSCREEN: 
            case INSERT: 
            case META: 
            case KP_UP: 
            case KP_DOWN: 
            case KP_LEFT: 
            case KP_RIGHT: 
            case WINDOWS: 
            case CONTEXT_MENU: 
            case ALT_GRAPH: {
                return '\uffff';
            }
            case ENTER: {
                return '\n';
            }
            case DIVIDE: {
                return '/';
            }
            case MULTIPLY: {
                return '*';
            }
            case SUBTRACT: {
                return '-';
            }
            case ADD: {
                return '+';
            }
            case NUMPAD0: {
                return '0';
            }
            case NUMPAD1: {
                return '1';
            }
            case NUMPAD2: {
                return '2';
            }
            case NUMPAD3: {
                return '3';
            }
            case NUMPAD4: {
                return '4';
            }
            case NUMPAD5: {
                return '5';
            }
            case NUMPAD6: {
                return '6';
            }
            case NUMPAD7: {
                return '7';
            }
            case NUMPAD8: {
                return '8';
            }
            case NUMPAD9: {
                return '9';
            }
            case DECIMAL: {
                return '.';
            }
            case UNDEFINED: {
                break;
            }
        }
        String ch = fxEvent.getEventType() == KeyEvent.KEY_TYPED ? fxEvent.getCharacter() : kc.impl_getChar();
        if (ch.length() < 1) {
            return '\uffff';
        }
        if (ch.startsWith("\r")) {
            return '\n';
        }
        return ch.charAt(0);
    }

    public static class PApplicationFX
    extends Application {
        public static PSurfaceFX surface;

        public void start(Stage stage) {
            Rectangle primaryScreenRect;
            PApplet sketch = PApplicationFX.surface.sketch;
            GraphicsDevice displayDevice = null;
            GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            int displayNum = sketch.sketchDisplay();
            if (displayNum > 0) {
                GraphicsDevice[] devices = environment.getScreenDevices();
                if (displayNum <= devices.length) {
                    displayDevice = devices[displayNum - 1];
                } else {
                    System.err.format("Display %d does not exist, using the default display instead.%n", displayNum);
                    int i = 0;
                    while (i < devices.length) {
                        System.err.format("Display %d is %s%n", i + 1, devices[i]);
                        ++i;
                    }
                }
            }
            if (displayDevice == null) {
                displayDevice = environment.getDefaultScreenDevice();
            }
            boolean fullScreen = sketch.sketchFullScreen();
            boolean spanDisplays = sketch.sketchDisplay() == 0;
            Rectangle screenRect = primaryScreenRect = displayDevice.getDefaultConfiguration().getBounds();
            if (fullScreen || spanDisplays) {
                double minX = screenRect.getMinX();
                double maxX = screenRect.getMaxX();
                double minY = screenRect.getMinY();
                double maxY = screenRect.getMaxY();
                if (spanDisplays) {
                    GraphicsDevice[] graphicsDeviceArray = environment.getScreenDevices();
                    int n = graphicsDeviceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        GraphicsDevice s = graphicsDeviceArray[n2];
                        Rectangle bounds = s.getDefaultConfiguration().getBounds();
                        minX = Math.min(minX, bounds.getMinX());
                        maxX = Math.max(maxX, bounds.getMaxX());
                        minY = Math.min(minY, bounds.getMinY());
                        maxY = Math.max(maxY, bounds.getMaxY());
                        ++n2;
                    }
                }
                if (minY < 0.0) {
                    System.err.format("FX can't place window at negative Y coordinate [x=%d, y=%d]. Please make sure that your secondary display does not extend above the main display.", (int)minX, (int)minY);
                    screenRect = primaryScreenRect;
                } else {
                    screenRect = new Rectangle((int)minX, (int)minY, (int)(maxX - minX), (int)(maxY - minY));
                }
            }
            sketch.displayWidth = (int)screenRect.getWidth();
            sketch.displayHeight = (int)screenRect.getHeight();
            int sketchWidth = sketch.sketchWidth();
            int sketchHeight = sketch.sketchHeight();
            if (fullScreen || spanDisplays) {
                sketchWidth = (int)screenRect.getWidth();
                sketchHeight = (int)screenRect.getHeight();
                stage.initStyle(StageStyle.UNDECORATED);
                stage.setX(screenRect.getMinX());
                stage.setY(screenRect.getMinY());
                stage.setWidth(screenRect.getWidth());
                stage.setHeight(screenRect.getHeight());
            }
            Canvas canvas = PApplicationFX.surface.canvas;
            PApplicationFX.surface.fx.context = canvas.getGraphicsContext2D();
            StackPane stackPane = new StackPane();
            stackPane.getChildren().add((Object)canvas);
            canvas.widthProperty().bind((ObservableValue)stackPane.widthProperty());
            canvas.heightProperty().bind((ObservableValue)stackPane.heightProperty());
            int width = sketchWidth;
            int height = sketchHeight;
            int smooth = sketch.sketchSmooth();
            if ((PApplet.platform == 2 || PApplet.platform == 3) && PApplet.javaVersionName.compareTo("1.8.0_60") >= 0 && PApplet.javaVersionName.compareTo("1.8.0_72") < 0) {
                System.err.println("smooth() disabled for JavaFX with this Java version due to Oracle bug");
                System.err.println("https://github.com/processing/processing/issues/3795");
                smooth = 0;
            }
            SceneAntialiasing sceneAntialiasing = smooth == 0 ? SceneAntialiasing.DISABLED : SceneAntialiasing.BALANCED;
            stage.setScene(new Scene((Parent)stackPane, (double)width, (double)height, false, sceneAntialiasing));
            PApplicationFX.surface.stage = stage;
        }

        public void stop() throws Exception {
            PApplicationFX.surface.sketch.dispose();
        }
    }

    class ResizableCanvas
    extends Canvas {
        public ResizableCanvas() {
            this.widthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                public void changed(ObservableValue<? extends Number> value, Number oldWidth, Number newWidth) {
                    ((ResizableCanvas)ResizableCanvas.this).PSurfaceFX.this.sketch.setSize(newWidth.intValue(), ((ResizableCanvas)ResizableCanvas.this).PSurfaceFX.this.sketch.height);
                    ((ResizableCanvas)ResizableCanvas.this).PSurfaceFX.this.fx.setSize(((ResizableCanvas)ResizableCanvas.this).PSurfaceFX.this.sketch.width, ((ResizableCanvas)ResizableCanvas.this).PSurfaceFX.this.sketch.height);
                }
            });
            this.heightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                public void changed(ObservableValue<? extends Number> value, Number oldHeight, Number newHeight) {
                    ((ResizableCanvas)ResizableCanvas.this).PSurfaceFX.this.sketch.setSize(((ResizableCanvas)ResizableCanvas.this).PSurfaceFX.this.sketch.width, newHeight.intValue());
                    ((ResizableCanvas)ResizableCanvas.this).PSurfaceFX.this.fx.setSize(((ResizableCanvas)ResizableCanvas.this).PSurfaceFX.this.sketch.width, ((ResizableCanvas)ResizableCanvas.this).PSurfaceFX.this.sketch.height);
                }
            });
            EventHandler<MouseEvent> mouseHandler = new EventHandler<MouseEvent>(){

                public void handle(MouseEvent e) {
                    PSurfaceFX.this.fxMouseEvent(e);
                }
            };
            this.setOnMousePressed((EventHandler)mouseHandler);
            this.setOnMouseReleased((EventHandler)mouseHandler);
            this.setOnMouseClicked((EventHandler)mouseHandler);
            this.setOnMouseEntered((EventHandler)mouseHandler);
            this.setOnMouseExited((EventHandler)mouseHandler);
            this.setOnMouseDragged((EventHandler)mouseHandler);
            this.setOnMouseMoved((EventHandler)mouseHandler);
            this.setOnScroll((EventHandler)new EventHandler<ScrollEvent>(){

                public void handle(ScrollEvent e) {
                    PSurfaceFX.this.fxScrollEvent(e);
                }
            });
            EventHandler<KeyEvent> keyHandler = new EventHandler<KeyEvent>(){

                public void handle(KeyEvent e) {
                    PSurfaceFX.this.fxKeyEvent(e);
                }
            };
            this.setOnKeyPressed((EventHandler)keyHandler);
            this.setOnKeyReleased((EventHandler)keyHandler);
            this.setOnKeyTyped((EventHandler)keyHandler);
            this.setFocusTraversable(false);
            this.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> value, Boolean oldValue, Boolean newValue) {
                    if (newValue.booleanValue()) {
                        ((ResizableCanvas)ResizableCanvas.this).PSurfaceFX.this.sketch.focused = true;
                        ((ResizableCanvas)ResizableCanvas.this).PSurfaceFX.this.sketch.focusGained();
                    } else {
                        ((ResizableCanvas)ResizableCanvas.this).PSurfaceFX.this.sketch.focused = false;
                        ((ResizableCanvas)ResizableCanvas.this).PSurfaceFX.this.sketch.focusLost();
                    }
                }
            });
        }

        public Stage getStage() {
            return PSurfaceFX.this.stage;
        }

        public boolean isResizable() {
            return true;
        }

        public double prefWidth(double height) {
            return this.getWidth();
        }

        public double prefHeight(double width) {
            return this.getHeight();
        }
    }
}

