using System;
using System.Collections.Generic;
using Framefield.Core.Rendering;
using SharpDX;

namespace Framefield.Core.ID9295eb8f_37da_4d4a_935f_86a7f8cb315b
{

    public class Class_WireFrameShader : FXSourceCodeFunction
    {
        // >>> _inputids
        private enum InputId
        {
            Code = 0,
            Scene = 1,
            ColorR = 2,
            ColorG = 3,
            ColorB = 4,
            ColorA = 5
        }
        // <<< _inputids
    
    
        #region Renderer
        public class Renderer : BaseRenderer
        {
            public override void SetupEffect(OperatorPartContext context) {
                base.SetupEffect(context);

                try {
                    SetupMaterialConstBuffer(context);
                    SetupFogSettingsConstBuffer(context);
                    SetupPointLightsConstBuffer(context);
                }
                catch (Exception e) {
                    Logger.Error(ParentFunc, "Error building constant buffer: {0} - Source: {1}", e.Message, e.Source);
                }
            }
            public OperatorPart.Function ParentFunc {get;set;}
        }
        #endregion

        public Class_WireFrameShader() {
            _renderer = new Renderer(){ParentFunc = this};
        }

        public override void Dispose() {
            Utilities.DisposeObj(ref _renderer);
            base.Dispose();
        }

        bool _firstEval = true;
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
        
        
            if (_firstEval) {
                for (int i = 0; i < NumCodes(); ++i)
                    Compile(i);
                _firstEval = false;
                Changed = true;
            }

            //var Scene = inputs[1];
            
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Scene = inputs[(int)InputId.Scene];
            var ColorR = inputs[(int)InputId.ColorR].Eval(context).Value;
            var ColorG = inputs[(int)InputId.ColorG].Eval(context).Value;
            var ColorB = inputs[(int)InputId.ColorB].Eval(context).Value;
            var ColorA = inputs[(int)InputId.ColorA].Eval(context).Value;
            var Color = new Color4(ColorR, ColorG, ColorB, ColorA);
            //<<< _params

            using (new PropertyStasher<OperatorPartContext>(context, "Effect", "Renderer")) {
            
                //_effect.GetVariableByName("Base").AsScalar().Set(Base);
                SetColor("Color",Color);
                context.Effect = _effect;
                context.Renderer = _renderer;

                Scene.Eval(context);
            }

            return context;
        }

        Renderer _renderer;
    }
}


