-- Help.lua: functions for saving and accessing help for functions.
-- Always in the global environment, so just do `require 'Help';`.

-- Copyright (c) 2017 cxw/Incline.  CC-BY-SA 3.0.  In any derivative work, 
-- mention or link to https://bitbucket.org/inclinescene/public and 
-- http://devwrench.com.

require 'checks'
print_r = require 'print_r'

-- The table that will store the help info
_G.HELP = _G.HELP or setmetatable({}, {__mode = "kv"})
    -- A weak table - thanks to http://lua-users.org/wiki/DecoratorsAndDocstrings

function help(x)
    checks('?string|function')
    if not x then
        print([[help(x): show help for `x` from the global HELP table.
Available topics are:]])
        for k,_ in pairs(HELP) do
            if type(k) ~= 'function' then print(k) end
        end
        return
    end

    if HELP[x] then
        print(tostring(x))
        print(HELP[x])
    elseif type(x)=='string' and package.loaded[x] then
        -- It's a package name.  Report help for
        print('In package ' .. x .. ' (* = more help available):')
        for k, v in pairs(package.loaded[x]) do
            if HELP[v or k] then print('*',k) else print(' ',k) end
                --  ^^^^^^ v first since k is always truthy
        end
    else
        print('No help available for ' .. tostring(x))
    end
end

function sethelp(x,thehelp)
    checks('string|function','string')
    HELP[x] = thehelp
end

-- vi: set ts=4 sts=4 sw=4 et ai fo=crql: --
