#extension GL_EXT_gpu_shader4 : enable

attribute vec3 p0; 
attribute vec3 p1; 
attribute vec3 p2; 
attribute vec3 p3;
attribute vec2 tc; 

varying vec2 tc0; 
varying vec3 pos; 

uniform mat4 viewproj; 
uniform mat4 view;
uniform mat4 proj;
uniform vec3 eyePos; 
uniform mat4 tview;
uniform mat4 world; 

uniform float lineWidth; 
uniform vec4 lineColor; 
void main()
{
	// eyePos appoach
	float lineWidth = 1.0/sqrt(lineColor.r);

	vec3 vecEyep0 = normalize(eyePos-p0); 
	vec3 vecEyep1 = normalize(eyePos-p1);
	vec3 vecEyep2 = normalize(eyePos-p2);
	vec3 vecEyep3 = normalize(eyePos-p3);
	
	vec3 vecPosL1 = normalize(p0-p1); 
	vec3 vecPosL2 = normalize(p1-p2); 
	vec3 vecPosL3 = normalize(p2-p3); 

	vec3 dir0 = cross(vecPosL1, vecEyep0);
	vec3 dir1 = cross(vecPosL2, vecEyep1); 
	vec3 dir2 = cross(vecPosL2, vecEyep2); 
	vec3 dir3 = cross(vecPosL3, vecEyep3); 
	
	vec3 mixL = mix(dir0, dir1, tc.y);
	vec3 mixR = mix(dir2, dir3, tc.y);

	vec3 mid = mix(p1, p2, tc.y);
	vec3 dir = -mix(mixR, mixL, tc.x);
	dir = mixR;
	vec3 add = mix(dir, -dir, tc.x); 

	gl_Position = viewproj*world*vec4(mid+add*lineWidth, 1.0);
	tc0 = tc; 
	return;
}

//FRAGMENT
uniform vec4 lineColor; 
void main() {
	gl_FragColor = vec4(2.90);///lineColor;
	//gl_FragColor = *vec4(1.6,1.3,2.6,0);
	gl_FragColor.a = 1.0/sqrt(lineColor.r);
	return;
}


