#version 150
attribute vec3 pos;
attribute vec2 tc; 
attribute vec3 normal; 

varying vec3 n; 
varying vec2 tex;
varying vec3 vn;
varying vec3 opos; 
varying vec3 ipos; 
varying vec3 ln; 

uniform mat4 viewproj; 
uniform mat4 view;
uniform mat3 nview;
uniform mat3 nview2;
uniform mat4 tview;
uniform float time; 

uniform mat4 world; 

void main()
{	
	tex = tc*1.0;
	//vec3 adjPos = vec4(world*vec4(pos.xyz, 1.0);

	vec4 wpos = world*vec4(pos.xyz, 1.0);
	vec3 adjPos = wpos.xyz;
	
	
	gl_Position = viewproj*vec4(adjPos, 1.0); 
	//n = normalize((world*vec4(normal, 1.0).xyz);

	vec4 wn = world*vec4(normal.xyz, 1.0);
	n = normalize(normal);
	n = normalize(wn.xyz);
	
	vn = normalize(nview2*n);

	opos = (view*vec4(adjPos.xyz, 1.0)).xyz;
	ipos = adjPos.xyz;
}	

//FRAGMENT
//#version 150
uniform sampler2D Texture0; 
uniform sampler1D Texture2; 
uniform float time; 
uniform mat3 nview;
uniform mat4 tview;
uniform vec3 eyePos;
uniform vec3 lightPos;

uniform float gridAmplitude; 
uniform float bgColor;
uniform float shapeValue;
uniform float spectrumMultiplier; 
float rand(vec2 co)
{
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

vec4 baseColor = vec4(.05, .175, .3, 1.0);      // dark-ish blue
vec4 mainLight= vec4(.4, .75, .9, 1.0);         // very light blue
vec4 orangeLight= vec4(.93, .65, .5, 1.0);       // orange! 
vec4 sideLight= vec4(.75, .55, .65, 1.0);


void main()
{  
	//gl_FragColor = vec4(ln*.5+.5, 1.0);
	//return; 

	float diffuse = .25+.75*pow(max(0.0, dot(normalize(ipos-lightPos), n)), .425);
	gl_FragColor = vec4(diffuse);

  	vec4 ambient  = .5*mix(vec4(0), orangeLight, pow(n.x*.5+.5, 1.3));
    ambient  += .5*mix(vec4(0), baseColor, pow(n.z*.5+.5, 1.3));
    ambient  += .5*mix(vec4(0), sideLight, pow(n.y*.5+.5, 1.3));

    vec3 viewDir = normalize(opos);
    vec3 reflectDir = reflect(vn, -viewDir);///normalize(eyePos-ipos));
    float specular = max(0.0, dot(-reflectDir, normalize(lightPos-ipos)));

	vec4 color = 3.0*ambient+diffuse;//10.0*ambient*diffuse; //only diffuse first is good
	color += 2.5*vec4(specular);
 	color += 2.75*vec4(pow(specular, 18.0));
 	color += 5.75*vec4(pow(1.015*specular, 48.0));


 	vec4 strength = texture1D(Texture2, 2.0*abs(ipos.x)/2048.0);
 	vec3 sp = spectrumMultiplier*vec3(.80,1.4,1.8)*pow(strength.r, 1.85);

 	if ((abs(ipos.x)/2048.0)>.45)
 		sp = vec3(0.0f);

	

 	//color = diffuse;
 	//color = pow(color, 1.0)*1.17;
 	//color = specular;

 	// height shadows
 	float planar = .5+.5*clamp(pow(((ipos.y-00.0)/130.0), 3.40), .0, 1.0);
 	float tube = pow(clamp(1.6-length((ipos.xy/200.0)), 0.0, 1.0), 2.24);
 	color *= mix(planar, tube, shapeValue);

 	//Add after shadows
	color.rgb += clamp(sp, 0, 100);

    float fog = min(1.0, pow(length(ipos-eyePos)/2500.0, .25275));
    //gl_FragColor.rgb = mix(color.rgb, vec3(bgColor), fog);
   //vec3 bgTexture = 1.0-pow(texture2DProj(Texture0, gl_FragCoord.xyzw), 2.2);
    vec2 ssCoords = gl_FragCoord.xy/vec2(1920,1080);
    ssCoords.y = 1.0-ssCoords.y;
    vec3 bgTexture = texture2D(Texture0, ssCoords);
   
   // bgTexture = vec3(gl_FragCoord.xy/vec2(1920,1080)-vec2(0,0.0), 0); 
    gl_FragColor.rgb = mix(color.rgb, bgTexture, fog);
    gl_FragColor.a = gridAmplitude;

   // gl_FragColor.rgb = bgTexture;//pow(bgTexture, 2.2/1.0);
   // gl_FragColor.a = 1.0-fog;
 //   gl_FragColor.a = 1.0;

    //gl_FragColor.rgb = vec3(0.0);
   // gl_FragColor.rgb = vec3(abs(ipos.x)/2048.0, 0, 0);
    //gl_FragColor.rgb = 1.0*texture1D(Texture2, ipos.x/2048.0);

};

