var Sun = function(){
    PartBase.call(this);

    //POSTPROCESSING
    this.setHorizontalBlur(4);
    this.setVerticalBlur(8);
    this.setBloom(6);
    this.setDoF({
        focus : 1.0,
        maxblur: 2.0,
        aperture: 0.01
    });

    this.texture = TDEMO.TEXTURES.getTextures().katto
    this.skyTexture = TDEMO.TEXTURES.getTextures().valot

    this.scene.add(new THREE.AmbientLight(0xF07030));


    //this.scene.fog = new THREE.Fog(0x802000, this.near, 1000);
    //this.scene.fog = new THREE.Fog(0xFF88FF, this.near, 1500);
    var sky = this.createSky();
    this.scene.add(sky);
    this.pallo = this.createBall();
    this.scene.add(this.pallo);

    this.pointLight = new THREE.PointLight( 0xffffff, 2, 800 );
    this.pallo.add(this.pointLight);

    //GEOMETRY

};

Sun.prototype = PartBase.prototype.inheritance();

Sun.prototype.animate = function(elapsedTime, delta){
    PartBase.prototype.animate.call(this, elapsedTime, delta, true);

    var ballp = TDEMO.SYNC.getObjPosition();
    this.pallo.position.x = ballp.x;
    this.pallo.position.y = ballp.y;
    this.pallo.position.z = ballp.z;

    var ballr = TDEMO.SYNC.getObjRotation();
    this.pallo.rotation.x = ballr.x;
    this.pallo.rotation.y = ballr.y;
    this.pallo.rotation.z = ballr.z;

    this.texture.offset.x += delta*0.005;
    this.texture.needsUpdate = true;

};

Sun.prototype.createSky = function(){
    var geometry = new THREE.SphereGeometry(1600, 128, 128);
    /*var material = new THREE.MeshBasicMaterial({
        color : 0x882288,
        map : this.texture,
        side : THREE.BackSide
    });*/

    var material = new THREE.MeshStandardMaterial( {
		map: this.skyTexture,
		color: 0x882288,
		shading: THREE.SmoothShading,
        side : THREE.BackSide
	} );

    var sky = new THREE.Mesh(geometry, material);
    return sky;
};

Sun.prototype.createBall = function(){
    var geometry = new THREE.SphereGeometry(200, 128, 128);
    var material = new THREE.MeshBasicMaterial({
        color : 0xF07030,
        map : this.texture
    });

    var pallo = new THREE.Mesh(geometry, material);
    return pallo;
}
