/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import com.jogamp.common.util.IOUtil;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.MutableGraphicsConfiguration;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.nativewindow.util.Dimension;
import com.jogamp.nativewindow.util.DimensionImmutable;
import com.jogamp.nativewindow.util.PixelFormat;
import com.jogamp.nativewindow.util.PixelRectangle;
import com.jogamp.newt.Display;
import com.jogamp.newt.MonitorDevice;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.event.KeyAdapter;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseAdapter;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.WindowUpdateEvent;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.util.FPSAnimator;
import java.awt.Component;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PSurface;
import processing.opengl.PGL;
import processing.opengl.PGraphicsOpenGL;
import processing.opengl.PJOGL;

public class PSurfaceJOGL
implements PSurface {
    public static GLProfile profile;
    public PJOGL pgl;
    protected GLWindow window;
    protected FPSAnimator animator;
    protected Rectangle screenRect;
    protected PApplet sketch;
    protected PGraphics graphics;
    protected int sketchX;
    protected int sketchY;
    protected int sketchWidth0;
    protected int sketchHeight0;
    protected int sketchWidth;
    protected int sketchHeight;
    protected Display display;
    protected Screen screen;
    protected List<MonitorDevice> monitors;
    protected MonitorDevice displayDevice;
    protected Throwable drawException;
    protected Object waitObject = new Object();
    protected NewtCanvasAWT canvas;
    protected float[] currentPixelScale = new float[]{0.0f, 0.0f};
    protected boolean external = false;
    static Map<Integer, CursorInfo> cursors;
    static Map<Integer, String> cursorNames;

    static {
        cursors = new HashMap<Integer, CursorInfo>();
        cursorNames = new HashMap<Integer, String>();
        cursorNames.put(0, "arrow");
        cursorNames.put(1, "cross");
        cursorNames.put(3, "wait");
        cursorNames.put(13, "move");
        cursorNames.put(12, "hand");
        cursorNames.put(2, "text");
    }

    public PSurfaceJOGL(PGraphics graphics) {
        this.graphics = graphics;
        this.pgl = (PJOGL)((PGraphicsOpenGL)graphics).pgl;
    }

    @Override
    public void initOffscreen(PApplet sketch) {
        this.sketch = sketch;
        this.sketchWidth = sketch.sketchWidth();
        this.sketchHeight = sketch.sketchHeight();
        if (this.window != null) {
            this.canvas = new NewtCanvasAWT((Window)this.window);
            this.canvas.setBounds(0, 0, this.window.getWidth(), this.window.getHeight());
            this.canvas.setFocusable(true);
        }
    }

    @Override
    public void initFrame(PApplet sketch) {
        this.sketch = sketch;
        this.initIcons();
        File mesaLib = new File("/usr/lib/arm-linux-gnueabihf/libGLESv2.so.2");
        if (mesaLib.exists()) {
            System.out.println("\nIf you are receiving an error regarding the undefined symbol bcm_host_init, make sure you have the package libgles2-mesa deinstalled. This can be done by executing \"sudo aptitude remove libgles2-mesa\" in the terminal, and is a known issue with the Raspbian distribution.\n");
        }
        this.initDisplay();
        this.initGL();
        this.initWindow();
        this.initListeners();
        this.initAnimator();
    }

    @Override
    public Object getNative() {
        return this.window;
    }

    protected void initDisplay() {
        MonitorDevice monitor;
        String id1;
        String[] parts;
        String did;
        GraphicsDevice device;
        int n;
        int n2;
        GraphicsDevice[] graphicsDeviceArray;
        Display tmpDisplay = NewtFactory.createDisplay(null);
        tmpDisplay.addReference();
        Screen tmpScreen = NewtFactory.createScreen((Display)tmpDisplay, (int)0);
        tmpScreen.addReference();
        this.monitors = new ArrayList<MonitorDevice>();
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] awtDevices = environment.getScreenDevices();
        List newtDevices = tmpScreen.getMonitorDevices();
        if (PApplet.platform == 3) {
            graphicsDeviceArray = awtDevices;
            n2 = awtDevices.length;
            n = 0;
            while (n < n2) {
                device = graphicsDeviceArray[n];
                did = device.getIDstring();
                parts = did.split("\\.");
                id1 = "";
                if (1 < parts.length) {
                    id1 = parts[1].trim();
                }
                monitor = null;
                int id0 = newtDevices.size() > 0 ? ((MonitorDevice)newtDevices.get(0)).getId() : 0;
                int i = 0;
                while (i < newtDevices.size()) {
                    MonitorDevice mon = (MonitorDevice)newtDevices.get(i);
                    String mid = String.valueOf(mon.getId() - id0);
                    if (id1.equals(mid)) {
                        monitor = mon;
                        break;
                    }
                    ++i;
                }
                if (monitor != null) {
                    this.monitors.add(monitor);
                }
                ++n;
            }
        } else if (PApplet.platform == 1) {
            this.monitors.addAll(newtDevices);
        } else {
            graphicsDeviceArray = awtDevices;
            n2 = awtDevices.length;
            n = 0;
            while (n < n2) {
                String mid;
                MonitorDevice mon;
                device = graphicsDeviceArray[n];
                did = device.getIDstring();
                parts = did.split("Display");
                id1 = "";
                if (1 < parts.length) {
                    id1 = parts[1].trim();
                }
                monitor = null;
                int i = 0;
                while (i < newtDevices.size()) {
                    mon = (MonitorDevice)newtDevices.get(i);
                    mid = String.valueOf(mon.getId());
                    if (id1.equals(mid)) {
                        monitor = mon;
                        break;
                    }
                    ++i;
                }
                if (monitor == null) {
                    i = 0;
                    while (i < newtDevices.size()) {
                        mon = (MonitorDevice)newtDevices.get(i);
                        mid = String.valueOf(mon.getId());
                        if (-1 < did.indexOf(mid)) {
                            monitor = mon;
                            break;
                        }
                        ++i;
                    }
                }
                if (monitor != null) {
                    this.monitors.add(monitor);
                }
                ++n;
            }
        }
        this.displayDevice = null;
        int displayNum = this.sketch.sketchDisplay();
        if (displayNum > 0) {
            if (displayNum <= this.monitors.size()) {
                this.displayDevice = this.monitors.get(displayNum - 1);
            } else {
                System.err.format("Display %d does not exist, using the default display instead.%n", displayNum);
                int i = 0;
                while (i < this.monitors.size()) {
                    System.err.format("Display %d is %s%n", i + 1, this.monitors.get(i));
                    ++i;
                }
            }
        } else if (this.monitors.size() > 0) {
            this.displayDevice = this.monitors.get(0);
        }
        if (this.displayDevice != null) {
            this.screen = this.displayDevice.getScreen();
            this.display = this.screen.getDisplay();
        } else {
            this.screen = tmpScreen;
            this.display = tmpDisplay;
            this.displayDevice = this.screen.getPrimaryMonitor();
        }
    }

    protected void initGL() {
        if (profile == null) {
            if (PJOGL.profile == 1) {
                try {
                    profile = GLProfile.getGL2ES1();
                }
                catch (GLException gLException) {
                    profile = GLProfile.getMaxFixedFunc((boolean)true);
                }
            } else if (PJOGL.profile == 2) {
                try {
                    profile = GLProfile.getGL2ES2();
                }
                catch (GLException gLException) {
                    profile = GLProfile.getMaxProgrammable((boolean)true);
                }
            } else if (PJOGL.profile == 3) {
                try {
                    profile = GLProfile.getGL2GL3();
                }
                catch (GLException gLException) {
                    profile = GLProfile.getMaxProgrammable((boolean)true);
                }
                if (!profile.isGL3()) {
                    PGraphics.showWarning("Requested profile GL3 but is not available, got: " + profile);
                }
            } else if (PJOGL.profile == 4) {
                try {
                    profile = GLProfile.getGL4ES3();
                }
                catch (GLException gLException) {
                    profile = GLProfile.getMaxProgrammable((boolean)true);
                }
                if (!profile.isGL4()) {
                    PGraphics.showWarning("Requested profile GL4 but is not available, got: " + profile);
                }
            } else {
                throw new RuntimeException("Unsupported OpenGL profile.");
            }
        }
        GLCapabilities caps = new GLCapabilities(profile);
        caps.setAlphaBits(PGL.REQUESTED_ALPHA_BITS);
        caps.setDepthBits(PGL.REQUESTED_DEPTH_BITS);
        caps.setStencilBits(PGL.REQUESTED_STENCIL_BITS);
        caps.setSampleBuffers(true);
        caps.setNumSamples(PGL.smoothToSamples(this.graphics.smooth));
        caps.setBackgroundOpaque(true);
        caps.setOnscreen(true);
        this.pgl.setCaps(caps);
    }

    protected void initWindow() {
        this.window = GLWindow.create((Screen)this.screen, (GLCapabilitiesImmutable)this.pgl.getCaps());
        boolean spanDisplays = this.sketch.sketchDisplay() == 0;
        this.screenRect = spanDisplays ? new Rectangle(0, 0, this.screen.getWidth(), this.screen.getHeight()) : new Rectangle(0, 0, this.displayDevice.getViewportInWindowUnits().getWidth(), this.displayDevice.getViewportInWindowUnits().getHeight());
        this.sketch.displayWidth = this.screenRect.width;
        this.sketch.displayHeight = this.screenRect.height;
        this.sketchWidth0 = this.sketch.sketchWidth();
        this.sketchHeight0 = this.sketch.sketchHeight();
        this.sketchWidth = this.sketch.sketchWidth();
        this.sketchHeight = this.sketch.sketchHeight();
        boolean fullScreen = this.sketch.sketchFullScreen();
        if (fullScreen || spanDisplays) {
            this.sketchWidth = this.screenRect.width;
            this.sketchHeight = this.screenRect.height;
        }
        float[] reqSurfacePixelScale = this.graphics.is2X() ? new float[]{0.0f, 0.0f} : new float[]{1.0f, 1.0f};
        this.window.setSurfaceScale(reqSurfacePixelScale);
        this.window.setSize(this.sketchWidth, this.sketchHeight);
        this.window.setResizable(false);
        this.setSize(this.sketchWidth, this.sketchHeight);
        this.sketchX = this.displayDevice.getViewportInWindowUnits().getX();
        this.sketchY = this.displayDevice.getViewportInWindowUnits().getY();
        if (fullScreen) {
            PApplet.hideMenuBar();
            this.window.setTopLevelPosition(this.sketchX, this.sketchY);
            if (spanDisplays) {
                this.window.setFullscreen(this.monitors);
            } else {
                List<MonitorDevice> display = Collections.singletonList(this.displayDevice);
                this.window.setFullscreen(display);
            }
        }
    }

    protected void initListeners() {
        NEWTMouseListener mouseListener = new NEWTMouseListener();
        this.window.addMouseListener((MouseListener)mouseListener);
        NEWTKeyListener keyListener = new NEWTKeyListener();
        this.window.addKeyListener((KeyListener)keyListener);
        NEWTWindowListener winListener = new NEWTWindowListener();
        this.window.addWindowListener((WindowListener)winListener);
        DrawListener drawlistener = new DrawListener();
        this.window.addGLEventListener((GLEventListener)drawlistener);
    }

    protected void initAnimator() {
        this.animator = new FPSAnimator((GLAutoDrawable)this.window, 60);
        this.drawException = null;
        this.animator.setUncaughtExceptionHandler(new GLAnimatorControl.UncaughtExceptionHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void uncaughtException(GLAnimatorControl animator, GLAutoDrawable drawable, Throwable cause) {
                Object object = PSurfaceJOGL.this.waitObject;
                synchronized (object) {
                    PSurfaceJOGL.this.drawException = cause;
                    PSurfaceJOGL.this.waitObject.notify();
                }
            }
        });
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = PSurfaceJOGL.this.waitObject;
                synchronized (object) {
                    Throwable cause;
                    try {
                        if (PSurfaceJOGL.this.drawException == null) {
                            PSurfaceJOGL.this.waitObject.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (PSurfaceJOGL.this.drawException != null && !((cause = PSurfaceJOGL.this.drawException.getCause()) instanceof ThreadDeath)) {
                        if (cause instanceof RuntimeException) {
                            throw (RuntimeException)cause;
                        }
                        if (cause instanceof UnsatisfiedLinkError) {
                            throw new UnsatisfiedLinkError(cause.getMessage());
                        }
                        if (cause == null) {
                            throw new RuntimeException(PSurfaceJOGL.this.drawException.getMessage());
                        }
                        throw new RuntimeException(cause);
                    }
                }
            }
        }).start();
    }

    @Override
    public void setTitle(final String title) {
        this.display.getEDTUtil().invoke(false, new Runnable(){

            @Override
            public void run() {
                PSurfaceJOGL.this.window.setTitle(title);
            }
        });
    }

    @Override
    public void setVisible(final boolean visible) {
        this.display.getEDTUtil().invoke(false, new Runnable(){

            @Override
            public void run() {
                PSurfaceJOGL.this.window.setVisible(visible);
            }
        });
    }

    @Override
    public void setResizable(final boolean resizable) {
        this.display.getEDTUtil().invoke(false, new Runnable(){

            @Override
            public void run() {
                PSurfaceJOGL.this.window.setResizable(resizable);
            }
        });
    }

    @Override
    public void setIcon(PImage icon) {
        PGraphics.showWarning("Window icons for OpenGL sketches can only be set in settings()\nusing PJOGL.setIcon(filename).");
    }

    @Override
    public void setAlwaysOnTop(final boolean always) {
        this.display.getEDTUtil().invoke(false, new Runnable(){

            @Override
            public void run() {
                PSurfaceJOGL.this.window.setAlwaysOnTop(always);
            }
        });
    }

    protected void initIcons() {
        IOUtil.ClassResources res = null;
        if (PJOGL.icons == null || PJOGL.icons.length == 0) {
            int[] sizes = new int[]{16, 32, 48, 64, 128, 256, 512};
            String[] iconImages = new String[sizes.length];
            int i = 0;
            while (i < sizes.length) {
                iconImages[i] = "/icon/icon-" + sizes[i] + ".png";
                ++i;
            }
            res = new IOUtil.ClassResources(iconImages, PApplet.class.getClassLoader(), PApplet.class);
        } else {
            String[] iconImages = new String[PJOGL.icons.length];
            int i = 0;
            while (i < PJOGL.icons.length) {
                iconImages[i] = this.resourceFilename(PJOGL.icons[i]);
                ++i;
            }
            res = new IOUtil.ClassResources(iconImages, this.sketch.getClass().getClassLoader(), this.sketch.getClass());
        }
        NewtFactory.setWindowIcons((IOUtil.ClassResources)res);
    }

    private String resourceFilename(String filename) {
        InputStream stream = null;
        try {
            File file = new File(this.sketch.dataPath(filename));
            if (!file.exists()) {
                file = this.sketch.sketchFile(filename);
            }
            if (file.exists() && !file.isDirectory()) {
                try {
                    String filePath = file.getCanonicalPath();
                    String filenameActual = new File(filePath).getName();
                    String filenameShort = new File(filename).getName();
                    if (!filenameActual.equals(filenameShort)) {
                        throw new RuntimeException("This file is named " + filenameActual + " not " + filename + ". Rename the file " + "or change your code.");
                    }
                }
                catch (IOException iOException) {}
            }
            if ((stream = new FileInputStream(file)) != null) {
                stream.close();
                return file.getCanonicalPath();
            }
        }
        catch (IOException iOException) {
        }
        catch (SecurityException securityException) {}
        ClassLoader cl = this.sketch.getClass().getClassLoader();
        try {
            String cn;
            stream = cl.getResourceAsStream("data/" + filename);
            if (stream != null && !(cn = stream.getClass().getName()).equals("sun.plugin.cache.EmptyInputStream")) {
                stream.close();
                return "data/" + filename;
            }
            stream = cl.getResourceAsStream(filename);
            if (stream != null && !(cn = stream.getClass().getName()).equals("sun.plugin.cache.EmptyInputStream")) {
                stream.close();
                return filename;
            }
        }
        catch (IOException iOException) {}
        try {
            try {
                String path;
                try {
                    path = this.sketch.dataPath(filename);
                    stream = new FileInputStream(path);
                    if (stream != null) {
                        stream.close();
                        return path;
                    }
                }
                catch (IOException iOException) {}
                try {
                    path = this.sketch.sketchPath(filename);
                    stream = new FileInputStream(path);
                    if (stream != null) {
                        stream.close();
                        return path;
                    }
                }
                catch (Exception exception) {}
                try {
                    stream = new FileInputStream(filename);
                    if (stream != null) {
                        stream.close();
                        return filename;
                    }
                }
                catch (IOException iOException) {
                }
            }
            catch (SecurityException securityException) {}
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    @Override
    public void placeWindow(int[] location, int[] editorLocation) {
        int x = this.window.getX() - this.window.getInsets().getLeftWidth();
        int y = this.window.getY() - this.window.getInsets().getTopHeight();
        int w = this.window.getWidth() + this.window.getInsets().getTotalWidth();
        int h = this.window.getHeight() + this.window.getInsets().getTotalHeight();
        if (location != null) {
            this.window.setTopLevelPosition(location[0], location[1]);
        } else if (editorLocation != null) {
            int locationX = editorLocation[0] - 20;
            int locationY = editorLocation[1];
            if (locationX - w > 10) {
                this.window.setTopLevelPosition(locationX - w, locationY);
            } else {
                locationX = (this.sketch.displayWidth - w) / 2;
                locationY = (this.sketch.displayHeight - h) / 2;
                this.window.setTopLevelPosition(locationX, locationY);
            }
        } else {
            int sketchX = this.displayDevice.getViewportInWindowUnits().getX();
            int sketchY = this.displayDevice.getViewportInWindowUnits().getY();
            this.window.setTopLevelPosition(sketchX + this.screenRect.x + (this.screenRect.width - this.sketchWidth) / 2, sketchY + this.screenRect.y + (this.screenRect.height - this.sketchHeight) / 2);
        }
        Point frameLoc = new Point(x, y);
        if (frameLoc.y < 0) {
            this.window.setTopLevelPosition(frameLoc.x, 30);
        }
    }

    @Override
    public void placePresent(int stopColor) {
        this.pgl.initPresentMode(0.5f * (float)(this.screenRect.width - this.sketchWidth), 0.5f * (float)(this.screenRect.height - this.sketchHeight), stopColor);
        this.window.setSize(this.screenRect.width, this.screenRect.height);
        PApplet.hideMenuBar();
        this.window.setTopLevelPosition(this.sketchX + this.screenRect.x, this.sketchY + this.screenRect.y);
        this.window.setFullscreen(true);
    }

    @Override
    public void setupExternalMessages() {
        this.external = true;
    }

    @Override
    public void startThread() {
        if (this.animator != null) {
            this.animator.start();
        }
    }

    @Override
    public void pauseThread() {
        if (this.animator != null) {
            this.animator.pause();
        }
    }

    @Override
    public void resumeThread() {
        if (this.animator != null) {
            this.animator.resume();
        }
    }

    @Override
    public boolean stopThread() {
        if (this.animator != null) {
            return this.animator.stop();
        }
        return false;
    }

    @Override
    public boolean isStopped() {
        if (this.animator != null) {
            return !this.animator.isAnimating();
        }
        return true;
    }

    @Override
    public void setLocation(final int x, final int y) {
        this.display.getEDTUtil().invoke(false, new Runnable(){

            @Override
            public void run() {
                PSurfaceJOGL.this.window.setTopLevelPosition(x, y);
            }
        });
    }

    @Override
    public void setSize(int width, int height) {
        if (width == this.sketch.width && height == this.sketch.height) {
            return;
        }
        if (!this.pgl.presentMode()) {
            this.sketch.setSize(width, height);
            this.sketchWidth = width;
            this.sketchHeight = height;
            this.graphics.setSize(width, height);
            this.window.setSize(width, height);
        }
    }

    public float getPixelScale() {
        if (this.graphics.is2X()) {
            this.window.getCurrentSurfaceScale(this.currentPixelScale);
            return this.currentPixelScale[0];
        }
        return 1.0f;
    }

    public Component getComponent() {
        return this.canvas;
    }

    public void setSmooth(int level) {
        this.pgl.reqNumSamples = level;
        GLCapabilities caps = new GLCapabilities(profile);
        caps.setAlphaBits(PGL.REQUESTED_ALPHA_BITS);
        caps.setDepthBits(PGL.REQUESTED_DEPTH_BITS);
        caps.setStencilBits(PGL.REQUESTED_STENCIL_BITS);
        caps.setSampleBuffers(true);
        caps.setNumSamples(this.pgl.reqNumSamples);
        caps.setBackgroundOpaque(true);
        caps.setOnscreen(true);
        NativeSurface target = this.window.getNativeSurface();
        MutableGraphicsConfiguration config = (MutableGraphicsConfiguration)target.getGraphicsConfiguration();
        config.setChosenCapabilities((CapabilitiesImmutable)caps);
    }

    @Override
    public void setFrameRate(float fps) {
        if (this.animator != null) {
            this.animator.stop();
            this.animator.setFPS((int)fps);
            this.pgl.setFps(fps);
            this.animator.start();
        }
    }

    public void requestFocus() {
        this.display.getEDTUtil().invoke(false, new Runnable(){

            @Override
            public void run() {
                PSurfaceJOGL.this.window.requestFocus();
            }
        });
    }

    protected void nativeMouseEvent(MouseEvent nativeEvent, int peAction) {
        int modifiers = nativeEvent.getModifiers();
        int peModifiers = modifiers & 0xF;
        int peButton = 0;
        if ((modifiers & 0x20) != 0) {
            peButton = 37;
        } else if ((modifiers & 0x40) != 0) {
            peButton = 3;
        } else if ((modifiers & 0x80) != 0) {
            peButton = 39;
        }
        if (PApplet.platform == 2 && (modifiers & 2) != 0) {
            peButton = 39;
        }
        int peCount = 0;
        peCount = peAction == 8 ? -(nativeEvent.isShiftDown() ? (int)nativeEvent.getRotation()[0] : (int)nativeEvent.getRotation()[1]) : nativeEvent.getClickCount();
        this.window.getCurrentSurfaceScale(this.currentPixelScale);
        int sx = (int)((float)nativeEvent.getX() / this.currentPixelScale[0]);
        int sy = (int)((float)nativeEvent.getY() / this.currentPixelScale[1]);
        int mx = sx;
        int my = sy;
        if (this.pgl.presentMode()) {
            mx -= (int)this.pgl.presentX;
            my -= (int)this.pgl.presentY;
            if (peAction == 2 && this.pgl.insideStopButton(sx, sy - this.screenRect.height)) {
                this.sketch.exit();
            }
            if (mx < 0 || this.sketchWidth < mx || my < 0 || this.sketchHeight < my) {
                return;
            }
        }
        processing.event.MouseEvent me = new processing.event.MouseEvent(nativeEvent, nativeEvent.getWhen(), peAction, peModifiers, mx, my, peButton, peCount);
        this.sketch.postEvent(me);
    }

    protected void nativeKeyEvent(KeyEvent nativeEvent, int peAction) {
        char keyChar;
        int keyCode;
        int peModifiers = nativeEvent.getModifiers() & 0xF;
        short code = nativeEvent.getKeyCode();
        if (PSurfaceJOGL.isPCodedKey(code)) {
            keyCode = PSurfaceJOGL.mapToPConst(code);
            keyChar = '\uffff';
        } else if (PSurfaceJOGL.isHackyKey(code)) {
            keyCode = code == 13 ? 10 : (int)code;
            keyChar = PSurfaceJOGL.hackToChar(code, nativeEvent.getKeyChar());
        } else {
            keyCode = code;
            keyChar = nativeEvent.getKeyChar();
        }
        processing.event.KeyEvent ke = new processing.event.KeyEvent(nativeEvent, nativeEvent.getWhen(), peAction, peModifiers, keyChar, keyCode, nativeEvent.isAutoRepeat());
        this.sketch.postEvent(ke);
        if (!PSurfaceJOGL.isPCodedKey(code) && !PSurfaceJOGL.isHackyKey(code) && peAction == 1) {
            processing.event.KeyEvent tke = new processing.event.KeyEvent(nativeEvent, nativeEvent.getWhen(), 3, peModifiers, keyChar, 0, nativeEvent.isAutoRepeat());
            this.sketch.postEvent(tke);
        }
    }

    private static boolean isPCodedKey(short code) {
        return code == 150 || code == 152 || code == 149 || code == 151 || code == 18 || code == 17 || code == 15 || code == 154;
    }

    private static int mapToPConst(short code) {
        switch (code) {
            case 150: {
                return 38;
            }
            case 152: {
                return 40;
            }
            case 149: {
                return 37;
            }
            case 151: {
                return 39;
            }
            case 18: {
                return 18;
            }
            case 17: {
                return 17;
            }
            case 15: {
                return 16;
            }
            case 154: {
                return 157;
            }
        }
        return code;
    }

    private static boolean isHackyKey(short code) {
        switch (code) {
            case 8: 
            case 9: 
            case 13: 
            case 27: 
            case 147: {
                return true;
            }
        }
        return false;
    }

    private static char hackToChar(short code, char def) {
        switch (code) {
            case 8: {
                return '\b';
            }
            case 9: {
                return '\t';
            }
            case 13: {
                return '\n';
            }
            case 27: {
                return '\u001b';
            }
            case 147: {
                return '\u007f';
            }
        }
        return def;
    }

    @Override
    public void setCursor(int kind) {
        String name;
        if (!cursorNames.containsKey(kind)) {
            PGraphics.showWarning("Unknown cursor type: " + kind);
            return;
        }
        CursorInfo cursor = cursors.get(kind);
        if (cursor == null && (name = cursorNames.get(kind)) != null) {
            ImageIcon icon = new ImageIcon(this.getClass().getResource("cursors/" + name + ".png"));
            PImage img = new PImage(icon.getImage());
            int x = img.width / 2;
            int y = img.height / 2;
            if (kind == 0) {
                x = 10;
                y = 7;
            } else if (kind == 12) {
                x = 12;
                y = 8;
            } else if (kind == 2) {
                x = 16;
                y = 22;
            }
            cursor = new CursorInfo(img, x, y);
            cursors.put(kind, cursor);
        }
        if (cursor != null) {
            cursor.set();
        } else {
            PGraphics.showWarning("Cannot load cursor type: " + kind);
        }
    }

    @Override
    public void setCursor(PImage image, int hotspotX, int hotspotY) {
        Display disp = this.window.getScreen().getDisplay();
        BufferedImage bimg = (BufferedImage)image.getNative();
        DataBufferInt dbuf = (DataBufferInt)bimg.getData().getDataBuffer();
        int[] ipix = dbuf.getData();
        ByteBuffer pixels = ByteBuffer.allocate(ipix.length * 4);
        pixels.asIntBuffer().put(ipix);
        PixelFormat format = PixelFormat.ARGB8888;
        Dimension size = new Dimension(bimg.getWidth(), bimg.getHeight());
        PixelRectangle.GenericPixelRect pixelrect = new PixelRectangle.GenericPixelRect(format, (DimensionImmutable)size, 0, false, pixels);
        final Display.PointerIcon pi = disp.createPointerIcon((PixelRectangle)pixelrect, hotspotX, hotspotY);
        this.display.getEDTUtil().invoke(false, new Runnable(){

            @Override
            public void run() {
                PSurfaceJOGL.this.window.setPointerIcon(pi);
            }
        });
    }

    @Override
    public void showCursor() {
        this.display.getEDTUtil().invoke(false, new Runnable(){

            @Override
            public void run() {
                PSurfaceJOGL.this.window.setPointerVisible(true);
            }
        });
    }

    @Override
    public void hideCursor() {
        this.display.getEDTUtil().invoke(false, new Runnable(){

            @Override
            public void run() {
                PSurfaceJOGL.this.window.setPointerVisible(false);
            }
        });
    }

    class CursorInfo {
        PImage image;
        int x;
        int y;

        CursorInfo(PImage image, int x, int y) {
            this.image = image;
            this.x = x;
            this.y = y;
        }

        void set() {
            PSurfaceJOGL.this.setCursor(this.image, this.x, this.y);
        }
    }

    class DrawListener
    implements GLEventListener {
        DrawListener() {
        }

        public void display(GLAutoDrawable drawable) {
            if (PSurfaceJOGL.this.display.getEDTUtil().isCurrentThreadEDT()) {
                return;
            }
            if (PSurfaceJOGL.this.sketch.frameCount == 0) {
                if (PSurfaceJOGL.this.sketchWidth < PSurfaceJOGL.this.sketchWidth0 || PSurfaceJOGL.this.sketchHeight < PSurfaceJOGL.this.sketchHeight0) {
                    PGraphics.showWarning("The sketch has been automatically resized to fit the screen resolution");
                }
                PSurfaceJOGL.this.requestFocus();
            }
            PSurfaceJOGL.this.pgl.getGL(drawable);
            int pframeCount = PSurfaceJOGL.this.sketch.frameCount;
            PSurfaceJOGL.this.sketch.handleDraw();
            if (pframeCount == PSurfaceJOGL.this.sketch.frameCount) {
                PSurfaceJOGL.this.pgl.beginRender();
                PSurfaceJOGL.this.pgl.endRender(PSurfaceJOGL.this.sketch.sketchWindowColor());
            }
            PGraphicsOpenGL.completeFinishedPixelTransfers();
            if (PSurfaceJOGL.this.sketch.exitCalled()) {
                PGraphicsOpenGL.completeAllPixelTransfers();
                PSurfaceJOGL.this.sketch.dispose();
                PSurfaceJOGL.this.sketch.exitActual();
            }
        }

        public void dispose(GLAutoDrawable drawable) {
            PSurfaceJOGL.this.sketch.dispose();
        }

        public void init(GLAutoDrawable drawable) {
            PSurfaceJOGL.this.pgl.getGL(drawable);
            PSurfaceJOGL.this.pgl.init(drawable);
            PSurfaceJOGL.this.sketch.start();
            int c = PSurfaceJOGL.this.graphics.backgroundColor;
            PSurfaceJOGL.this.pgl.clearColor((float)(c >> 16 & 0xFF) / 255.0f, (float)(c >> 8 & 0xFF) / 255.0f, (float)(c >> 0 & 0xFF) / 255.0f, (float)(c >> 24 & 0xFF) / 255.0f);
            PSurfaceJOGL.this.pgl.clear(PGL.COLOR_BUFFER_BIT);
        }

        public void reshape(GLAutoDrawable drawable, int x, int y, int w, int h) {
            PSurfaceJOGL.this.pgl.resetFBOLayer();
            PSurfaceJOGL.this.window.getCurrentSurfaceScale(PSurfaceJOGL.this.currentPixelScale);
            PSurfaceJOGL.this.pgl.getGL(drawable);
            PSurfaceJOGL.this.setSize((int)((float)w / PSurfaceJOGL.this.currentPixelScale[0]), (int)((float)h / PSurfaceJOGL.this.currentPixelScale[1]));
        }
    }

    protected class NEWTKeyListener
    extends KeyAdapter {
        public void keyPressed(KeyEvent e) {
            PSurfaceJOGL.this.nativeKeyEvent(e, 1);
        }

        public void keyReleased(KeyEvent e) {
            PSurfaceJOGL.this.nativeKeyEvent(e, 2);
        }

        public void keyTyped(KeyEvent e) {
            PSurfaceJOGL.this.nativeKeyEvent(e, 3);
        }
    }

    protected class NEWTMouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            PSurfaceJOGL.this.nativeMouseEvent(e, 1);
        }

        public void mouseReleased(MouseEvent e) {
            PSurfaceJOGL.this.nativeMouseEvent(e, 2);
        }

        public void mouseClicked(MouseEvent e) {
            PSurfaceJOGL.this.nativeMouseEvent(e, 3);
        }

        public void mouseDragged(MouseEvent e) {
            PSurfaceJOGL.this.nativeMouseEvent(e, 4);
        }

        public void mouseMoved(MouseEvent e) {
            PSurfaceJOGL.this.nativeMouseEvent(e, 5);
        }

        public void mouseWheelMoved(MouseEvent e) {
            PSurfaceJOGL.this.nativeMouseEvent(e, 8);
        }

        public void mouseEntered(MouseEvent e) {
            PSurfaceJOGL.this.nativeMouseEvent(e, 6);
        }

        public void mouseExited(MouseEvent e) {
            PSurfaceJOGL.this.nativeMouseEvent(e, 7);
        }
    }

    protected class NEWTWindowListener
    implements WindowListener {
        public void windowGainedFocus(WindowEvent arg0) {
            PSurfaceJOGL.this.sketch.focused = true;
            PSurfaceJOGL.this.sketch.focusGained();
        }

        public void windowLostFocus(WindowEvent arg0) {
            PSurfaceJOGL.this.sketch.focused = false;
            PSurfaceJOGL.this.sketch.focusLost();
        }

        public void windowDestroyNotify(WindowEvent arg0) {
            PSurfaceJOGL.this.sketch.exit();
        }

        public void windowDestroyed(WindowEvent arg0) {
        }

        public void windowMoved(WindowEvent arg0) {
            if (PSurfaceJOGL.this.external) {
                PSurfaceJOGL.this.sketch.frameMoved(PSurfaceJOGL.this.window.getX(), PSurfaceJOGL.this.window.getY());
            }
        }

        public void windowRepaint(WindowUpdateEvent arg0) {
        }

        public void windowResized(WindowEvent arg0) {
        }
    }
}

