String[] lines;

Typewriter tw;
void setup() {
  size(1920, 1080);
  tw = new Typewriter("metamorphosis_generated_short.txt");
  frameRate(10);
}

String block = "";
void draw() {
  background(0);
  color(255);
  
  textAlign(CENTER);
  textSize(72);
  
  if (millis() < 5000) {
    text("M3TAM0RPH05I5", width/2, height/2);
  }  
  else if (millis() < 10000) {
    text("BY 7A75", width/2, height/2);    
  }
  else if (millis() < 15000) {
    text("IN C0LLAB0RATI0N WITH", width/2, height/2);    
  }
  else if (millis() < 20000) {
    text("FRANZ KAFKA", width/2, height/2);    
  }
  else if (millis() < 25000) {
    text("AND", width/2, height/2);    
  }
  else if (millis() < 30000) {
    text("AN LSTM NEURAL NET WITH 256 UNIT5", width/2, height/2);    
  }
  else if (millis() < 32500) {
  }
  else if (!tw.isFinished()) {
    if (tw.hasNext())
    {
      if (block.length() > 20)
        block = tw.next();
      else
        block += " " + tw.next();
      text(block, width/2, height/2);
    }
    else if (tw.hasNextEpoch())
    {
      tw.nextEpoch();
    }
  }
  else {
    text("THE END", width/2, height/2);        
  }
}

class Typewriter {
  ArrayList<ArrayList<String> > text;
  int epoch;
  int word;
  
  Typewriter(String filename) {
    text = new ArrayList<ArrayList<String> >();
    String[] lines = loadStrings(filename);
    ArrayList<String> current = null;
    for (String l : lines) {
      if (l.trim().isEmpty())
        continue;
      else if (l.startsWith("EPOCH "))
      {
        if (current != null)
          text.add(current);
        current = new ArrayList<String>();
      }
      else if (current != null)
      {
        String[] splitted = l.split(" ");
        for (String s : splitted)
          current.add(s);
      }
    }
    
    epoch = 0;
    word = 0;
  }
  
  boolean hasNext() {
    return hasNextEpoch() && word < text.get(epoch).size();
  }
  
  boolean hasNextEpoch() {
    return epoch < text.size();    
  }
  
  boolean isFinished() {
    return !hasNextEpoch() && !hasNext();
  }
  
  int epoch() { return epoch; }
  
  String next() {
    return text.get(epoch).get(word++);
  }
  
  void nextEpoch() {
    epoch++;
    word=0;
  }
  
}