#version 330 core
out vec4 FragColor;

in VS_OUT {
    vec3 Normal;
    vec3 FragPos;
} fsIn;

uniform float DepthScale;
uniform samplerCube skybox;

uniform vec3 lightPos;
uniform vec3 viewPos;

void main()
{
    vec3 ambient = vec3(0.3);

    vec3 lightDir = normalize(lightPos - fsIn.FragPos);
    vec3 normal = normalize(fsIn.Normal);
    float diff = max(dot(lightDir, normal), 0.0);
    vec3 diffuse = vec3(diff);

    vec3 viewDir = normalize(viewPos - fsIn.FragPos);
    
    float spec = 0.0;
    vec3 halfwayDir = normalize(lightDir + viewDir);  
    spec = pow(max(dot(normal, halfwayDir), 0.0), 32.0);
    
    vec3 specular = vec3(0.5) * spec;
    //FragColor = vec4(ambient + diffuse + specular, 1.0f);
	
	vec3 Reflect = normalize(2 * diff * (normal-lightDir));
	vec4 reflectionColor = texture(skybox, Reflect);
	vec3 Refract = refract(viewDir, normal, 0.33);
	vec4 refractionColor = texture(skybox, Refract);

	vec4 finalColor = vec4(specular, 1.0) + ((reflectionColor + refractionColor) / 4.0) + vec4(0.2, 0.2, 0.23, 1.0);
	//float depth = DepthScale * gl_FragCoord.z;
	//FragColor = finalColor * vec4(1.0, 1.0, 1.0, 1.0);
	FragColor = finalColor;// * vec4(0.9, 0.9, 1.0, 1.0);
}
