#version 330 core
layout (location = 0) in vec3 position;
layout (location = 1) in vec3 normal;
layout (location = 2) in vec2 texCoords;

out VS_OUT {
    vec3 FragPos;
    vec3 Normal;
    vec2 TexCoords;
} vsOut;

uniform mat4 projection;
uniform mat4 view;
uniform mat4 model;

uniform float particleScale = 1000.0;

void main()
{
	
	mat4 modelView = view * model;

	modelView[0][0] = particleScale; 
	modelView[0][1] = 0.0; 
	modelView[0][2] = 0.0; 

	modelView[1][0] = 0.0; 
	modelView[1][1] = particleScale/7.0; 
	modelView[1][2] = 0.0; 

	modelView[2][0] = 0.0; 
	modelView[2][1] = 0.0; 
	modelView[2][2] = 1.0; 

    gl_Position = projection * modelView * vec4(position, 1.0f);
    vsOut.FragPos = position;
    vsOut.Normal = (mat3(view * model)) * normal;
    vsOut.TexCoords = texCoords;
}