#version 330 core
out vec4 FragColor;

in VS_OUT {
    vec2 TexCoords;
} fsIn;

uniform sampler2D uiTexture;
uniform float cutThreshold = 0.5;
void main()
{
    vec4 color = texture(uiTexture, fsIn.TexCoords);
	if(color.a <= cutThreshold)
		discard;

	float depth = gl_FragCoord.z;
	FragColor = vec4(depth, 0, 0, 1.0f);
}