using System;
using System.Collections.Concurrent;
using System.Collections.Generic;

namespace GhostlyAi
{
    public class Map
    {
        public List<string> Content { get; set; }

        public Tile[,] TileMap { get; set; }
        public int Height { get; set; }
        public int Pelletsleft { get; set; }
        public int Width { get; set; }

        public ConcurrentBag<Tuple<Tile, Tile>> Teleports = new ConcurrentBag<Tuple<Tile, Tile>>();

        public Tile[,] GetTileMap()
        {
            var tileMap = new Tile[Width, Height];

            for (int y = 0; y < Content.Count; y++)
            {
                var contentLine = Content[y];
                for (int x = 0; x < contentLine.Length; x++)
                {
                    var tile = contentLine[x];
                    switch (tile)
                    {
                        case '_':
                            tileMap[x, y] = new Tile {X = x,Y=y, TileType = TileType.Floor};
                            break;

                        case '|':
                            tileMap[x, y] = new Tile { X = x, Y = y, TileType = TileType.Wall };
                            break;

                        case '-':
                            tileMap[x, y] = new Tile { X = x, Y = y, TileType = TileType.Door };
                            break;

                        case '.':
                            tileMap[x, y] = new Tile { X = x, Y = y, TileType = TileType.Pellet };
                            break;

                        case 'o':
                            tileMap[x, y] = new Tile { X = x, Y = y, TileType = TileType.SuperPellet };
                            break;

                    }
                }
            }


            return tileMap;
        }
        
    }
}