/*
 * Decompiled with CFR 0.152.
 */
package bot;

import ai.MiniMax;
import game.Ghost;
import game.Map;
import net.NetworkManager;
import org.json.simple.JSONObject;
import util.Position;

public class Bot {
    public Ghost ghost;
    public Map map = new Map();
    public MiniMax miniMax = new MiniMax(this.map, 7);

    public void update(JSONObject me) {
        if (this.ghost == null) {
            this.ghost = new Ghost(((Long)me.get("id")).intValue());
        }
        this.ghost.score = ((Long)me.get("score")).intValue();
        this.ghost.position = new Position<Integer, Integer>(((Long)me.get("x")).intValue(), ((Long)me.get("y")).intValue());
        this.ghost.id = ((Long)me.get("id")).intValue();
        this.ghost.isDangerous = (Boolean)me.get("isdangerous");
        this.miniMax.calculateTree(this);
        Direction direction = this.miniMax.getBestDirection();
        this.move(direction);
        this.map.canMove = false;
    }

    private void move(Direction direction) {
        if (direction == null) {
            return;
        }
        NetworkManager.getInstance().send(direction.toString());
    }

    public static enum Direction {
        LEFT,
        UP,
        RIGHT,
        DOWN;

    }
}

