#!/usr/bin/python           # This is server.py file

import socket               # Import socket module
from random import random
import time
import json
import sys
import math
from copy import deepcopy

s = socket.socket()         # Create a socket object
host = socket.gethostname() # Get local machine name
port = 54321                # Reserve a port for your service.

s.connect((host, port))
s.send(b"NAME shad\n")

actioncount=0
targetx=0
targety=0
myposx=0
myposy=0
found=False
starttime=0
ticktime=0
ticks=0
totalticktime=0

lastresortconstant=5

def fixcords(y,x):
	if x<0:
		x=width-1
	if y<0:
		y=height-1
	if x==width:
		x=0
	if y==height:
		y=0

	return y,x

def checkmove(x,y,fromx,fromy,direction,lastresort):

	y,x = fixcords(y,x)

	#print "last resort check" + " " +str(lastresort) + " " + str(enemylimit)

	if lastresort:
		lastresortcheck = True	
		for enemyidx in range(0,nrofenemy):
			#print str(enemyidx) + " " + str(x) + "/" + str(y) + " " + str(playersmap[enemyidx][y][x])
			if playersmap[enemyidx][y][x]<enemylimit and playersmap[enemyidx][y][x]>=0:
				#print "last resort check failed"
				lastresortcheck = False
				#if enemylimit == 1:
					#print enemyidx
					#exit()						
	else:
		lastresortcheck = False	


	if map[y][x]==-1 or (map[y][x]==-5 and lastresortcheck):
						 
		map[y][x]=map[fromy][fromx]+1
		mapfromx[y][x]=fromx
		mapfromy[y][x]=fromy
		mapfromdirection[y][x]=direction

		if points[y][x]>0:
			percentage=1.0
			lowerthenall=True
			for enemyidx in range(0,nrofenemy):
				if map[fromy][fromx] > playersmap[enemyidx]:
					lowerthenall = False

			if lowerthenall:
				pointsrated[y][x]=pointsrated[fromy][fromx]+points[y][x]*10/pow(map[y][x],2)
			else:			
				for enemyidx in range(0,nrofenemy):
					percentage=percentage*(playersmap[enemyidx][y][x]-1)/playersmap[enemyidx][y][x]
				
				if percentage > 0:
					pointsrated[y][x]=pointsrated[fromy][fromx]+(points[y][x]*percentage)/pow(map[y][x],2)
				else:
					pointsrated[y][x]=0

		else:
			pointsrated[y][x]=pointsrated[fromy][fromx]				



		return True
	else:
		return False

def checkenemymove(x,y,playeridx):

	didsomething=False

	y,x = fixcords(y,x)

	if map[y][x]==-1 and playersmap[playeridx][y][x]<0:
		playersmap[playeridx][y][x]=enemyactioncount+1
		didsomething=True

		if avoid[playeridx] and enemyactioncount<=lastresortconstant and not havepill:
			map[y][x]=-5
		
		
	return didsomething
		
def printmap(map):
	for y in range(0,height):
		print str(y) + " " + str(map[y])
				
while True:
	line = ""
	characters_to_read=-1
	while (characters_to_read < 0):
     		try:
			data = s.recv(4096)
			characters_to_read = data.index("\n")
			line = line + data[0:characters_to_read]  # removing the newline
		except:
			if data == "":
				print "closed?"
				sys.exit()
			line = line + data
			characters_to_read=-1

	#print line
	try:
	#if True:
		jdata=json.loads(line)

		y=0
		map=[]
		points=[]
		playersmap=[]
		pointsrated=[]
		mapfromx=[]
		mapfromy=[]
		mapfromdirection=[]
		avoid=[]

		if jdata['messagetype']=="welcome":
			starttime = 0
			laststarttime = 0
			totalticktime = 0
			ticks=0
			ticktime=0

		if 'gamestate' in jdata:
			if starttime <> 0 :
				laststarttime = starttime
				starttime = time.time()
				totalticktime = totalticktime + starttime - laststarttime
				ticks=ticks+1
				ticktime=totalticktime/ticks
			else:
				starttime = time.time()
				
			height=jdata['gamestate']['map']['height']
			width=jdata['gamestate']['map']['width']
			myposx=jdata['gamestate']['you']['x']
			myposy=jdata['gamestate']['you']['y']
			havepill=jdata['gamestate']['you']['isdangerous']

			for item in jdata['gamestate']['map']['content']:
				map.append(list(item))
				points.append(list(item))
				pointsrated.append(list(item))
				mapfromx.append(list(item))
				mapfromy.append(list(item))
				mapfromdirection.append(list(item))

	
				x=0
				for sign in map[y]:
				
					pointsrated[y][x]=0.00
					mapfromx[y][x]=0
					mapfromy[y][x]=0
					mapfromdirection[y][x]=0
					if sign == '_' or sign == '-': 
						map[y][x]=-1	#moveable
						points[y][x]=0	#points
					elif sign == '.':
						map[y][x]=-1		#moveable
						points[y][x]=1.0	#points
					elif sign == 'o':
						map[y][x]=-1		#moveable
						if havepill:
							points[y][x]=25.0	#points
						else:	
							points[y][x]=50.0	#points
					elif sign == '|':
						map[y][x]=-2	#moveable
						points[y][x]=0	#points
					elif sign == '@':
						map[y][x]=-1	#moveable
						points[y][x]=0	#points
					
					x=x+1

				y=y+1
		
			enemyidx=0
			for enemy in jdata['gamestate']['others']:
				
				playersmap.append(deepcopy(map))
				playersmap[enemyidx][enemy['y']][enemy['x']]=0
				enemyidx=enemyidx+1
				avoid.append(enemy['isdangerous'])

				if enemy['isdangerous']:				
					map[enemy['y']][enemy['x']]=-2

				elif havepill: #not dangerous and havepill
					points[enemy['y']][enemy['x']]=1
				else: # not havepill not dangerous
					map[enemy['y']][enemy['x']]=-2
				

			nrofenemy=enemyidx
		
			found=False
			map[myposy][myposx]=0.0
			targetx=myposx
			targety=myposy
			actioncount=0
			enemyactioncount=0		

			currenttime = time.time() - starttime			
 			#print "loading data finished current time: " + str(currenttime) + "Tick: " +str(ticktime)
		
			didsomething=True

			while didsomething:
				didsomething=False
				for enemyidx in range(0,nrofenemy):
					for y in range(0,height):
						for x in range(0,width):
							if playersmap[enemyidx][y][x]==enemyactioncount:
								didsomething=checkenemymove(x,y-1,enemyidx) or didsomething 
								didsomething=checkenemymove(x+1,y,enemyidx) or didsomething
								didsomething=checkenemymove(x-1,y,enemyidx) or didsomething 
								didsomething=checkenemymove(x,y+1,enemyidx) or didsomething

				if didsomething:
					enemyactioncount=enemyactioncount+1

				currenttime = time.time() - starttime
				
				if currenttime > ticktime*nrofenemy/(nrofenemy+1) and ticktime <>0:	#20%
					print "tick break" 
					print currenttime
					print ticktime*nrofenemy/(nrofenemy+1)
					didsomething = False
				
 			#print "Enemymovement calculation current time: " + str(currenttime) + "Tick: " +str(ticktime)

			highscore = 0

			lastresort = False
			enemylimit = lastresortconstant
			highestactioncount=0

			while not found and highscore == 0:

				
				#print "enemylimit: " + str(enemylimit)
				highscore = 0
				targethighscorex = -1			
				targethighscorey = -1			

				didsomething = True

				while didsomething or (lastresort and actioncount <= highestactioncount):

					didsomething=False				
			
					for y in range(0,height):
						for x in range(0,width):

							if map[y][x]==actioncount:
							
								didsomething = checkmove(x,y-1,x,y,0,lastresort) or didsomething
								didsomething = checkmove(x+1,y,x,y,2,lastresort) or didsomething
								didsomething = checkmove(x-1,y,x,y,3,lastresort) or didsomething
								didsomething = checkmove(x,y+1,x,y,1,lastresort) or didsomething

								if pointsrated[y][x]>highscore:
									highscore=pointsrated[y][x]
									targethighscorex=x
									targethighscorey=y


					currenttime = time.time() - starttime
				
					if currenttime > ticktime and ticktime <>0:
						print "tick break"
						print currenttime
						print ticktime
						didsomething = False

					actioncount=actioncount+1
	
				if not found and highscore==0 and enemylimit>0:
					highestactioncount=actioncount					
					actioncount=0
					enemylimit = enemylimit - 1
					lastresort = True
					#print "LAST RESORT"
				elif lastresort:
					break
				
				#for enemyidx in range(0,nrofenemy):
				#	print str(enemyidx) + " avoid " + str(avoid[enemyidx])
				#	printmap(playersmap[enemyidx])
				#printmap(map)
				#printmap(points)
				#printmap(pointsrated)

			#print "Point rating current time: " + str(currenttime) + "Tick: " +str(ticktime)			

			if not found:			

				if highscore <> 0:
					found = True
					targetx = targethighscorex
					targety = targethighscorey
					#print "highest points desicion"
					#printmap(pointsrated)
					#printmap(map)

			actioncount=map[targety][targetx]
			#printmap(map)
			#printmap(pointsrated)
			highscore=0

			#search for longest move		
			if not found:
				targetx = -1
				targety = -1
				highscore = 0
			
				for y in range(0,height):
					for x in range(0,width):
						if map[y][x]>highscore:
							highscore=map[y][x]
							targetx=x
							targety=y
				
				if targetx <> -1 and targety <> -1:
					found = True
					actioncount=map[targety][targetx]
					#print "longest move desicion"

			if found:
				found=False
				x=targetx
				y=targety

				while not found:
					oldy=y
					oldx=x
					y = mapfromy[oldy][oldx]
					x = mapfromx[oldy][oldx]
				
					actioncount=map[y][x]
					if actioncount==0:
						r=mapfromdirection[oldy][oldx]	
						found=True

			else:
				print "random move"
				r = int(random() * 4)

		elif jdata['messagetype']=="dead":
			print "dead"
			#exit()		
		else:
			r = int(random() * 4)
		
		currenttime = time.time() - starttime
				
		#print "move now current time: " + str(currenttime) + "Tick: " +str(ticktime)			
		
		if (r == 0):
			s.send(b"up\n")
			print "up"
		elif (r == 1):
			s.send(b"down\n")
			print "down"
		elif (r == 2):
			s.send(b"right\n")
			print "right"
		elif (r == 3):
			s.send(b"left\n")
			print "left"
	except:
		print "to slow :("
	#
	#	if (r == 0):
	#		s.send(b"up\n")
	#		print "up"
	#	elif (r == 1):
	#		s.send(b"down\n")
	#		print "down"
	#	elif (r == 2):
	#		s.send(b"right\n")
	#		print "right"
	#	elif (r == 3):
	#		s.send(b"left\n")
	#		print "left"

		if starttime <> 0 :
			laststarttime = starttime
			starttime = time.time()
			totalticktime = totalticktime + starttime - laststarttime
			ticks=ticks+1
			ticktime=totalticktime/ticks/2
		else:
			starttime = time.time()

s.close                     # Close the socket when done