/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.SparseArray;
import com.google.android.gms.vision.Frame;

public abstract class Detector<T> {
    private Object zzbxg = new Object();
    private Processor<T> zzbxh;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.zzbxg;
        synchronized (object) {
            if (this.zzbxh != null) {
                this.zzbxh.release();
                this.zzbxh = null;
            }
        }
    }

    public abstract SparseArray<T> detect(Frame var1);

    public boolean setFocus(int n) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveFrame(Frame frame) {
        Object object = this.zzbxg;
        synchronized (object) {
            if (this.zzbxh == null) {
                throw new IllegalStateException("Detector processor must first be set with setProcessor in order to receive detection results.");
            }
            Frame.Metadata metadata = new Frame.Metadata(frame.getMetadata());
            metadata.zzMV();
            SparseArray<T> sparseArray = this.detect(frame);
            boolean bl = this.isOperational();
            Detections<T> detections = new Detections<T>(sparseArray, metadata, bl);
            this.zzbxh.receiveDetections(detections);
        }
    }

    public void setProcessor(Processor<T> processor) {
        this.zzbxh = processor;
    }

    public boolean isOperational() {
        return true;
    }

    public static interface Processor<T> {
        public void release();

        public void receiveDetections(Detections<T> var1);
    }

    public static class Detections<T> {
        private SparseArray<T> zzbxi;
        private Frame.Metadata zzbxj;
        private boolean zzbxk;

        public Detections(SparseArray<T> sparseArray, Frame.Metadata metadata, boolean bl) {
            this.zzbxi = sparseArray;
            this.zzbxj = metadata;
            this.zzbxk = bl;
        }

        public SparseArray<T> getDetectedItems() {
            return this.zzbxi;
        }

        public Frame.Metadata getFrameMetadata() {
            return this.zzbxj;
        }

        public boolean detectorIsOperational() {
            return this.zzbxk;
        }
    }
}

