/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.server.response;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.server.converter.ConverterWrapper;
import com.google.android.gms.common.server.response.FieldMappingDictionary;
import com.google.android.gms.common.server.response.SafeParcelResponse;
import com.google.android.gms.common.util.zzc;
import com.google.android.gms.common.util.zzp;
import com.google.android.gms.common.util.zzq;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class FastJsonResponse {
    public abstract Map<String, Field<?, ?>> zzuf();

    protected abstract Object zzdm(String var1);

    protected boolean zza(Field field) {
        if (field.zzue() == 11) {
            if (field.zzuj()) {
                return this.zzdp(field.zzuk());
            }
            return this.zzdo(field.zzuk());
        }
        return this.zzdn(field.zzuk());
    }

    protected abstract boolean zzdn(String var1);

    protected boolean zzdo(String string2) {
        throw new UnsupportedOperationException("Concrete types not supported");
    }

    protected boolean zzdp(String string2) {
        throw new UnsupportedOperationException("Concrete type arrays not supported");
    }

    protected <O, I> I zza(Field<I, O> field, Object object) {
        if (((Field)field).zzasS != null) {
            return field.convertBack(object);
        }
        return (I)object;
    }

    public HashMap<String, Object> zzug() {
        return null;
    }

    public HashMap<String, Object> zzuh() {
        return null;
    }

    public String toString() {
        Map<String, Field<?, ?>> map = this.zzuf();
        StringBuilder stringBuilder = new StringBuilder(100);
        block5: for (String string2 : map.keySet()) {
            Field<?, ?> field = map.get(string2);
            if (!this.zza(field)) continue;
            Object object = this.zzb(field);
            Object obj = this.zza(field, object);
            if (stringBuilder.length() == 0) {
                stringBuilder.append("{");
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append("\"").append(string2).append("\":");
            if (obj == null) {
                stringBuilder.append("null");
                continue;
            }
            switch (field.zzue()) {
                case 8: {
                    stringBuilder.append("\"").append(zzc.zzk((byte[])obj)).append("\"");
                    continue block5;
                }
                case 9: {
                    stringBuilder.append("\"").append(zzc.zzl((byte[])obj)).append("\"");
                    continue block5;
                }
                case 10: {
                    HashMap hashMap = (HashMap)obj;
                    zzq.zza(stringBuilder, hashMap);
                    continue block5;
                }
            }
            if (field.zzui()) {
                this.zza(stringBuilder, field, (ArrayList)obj);
                continue;
            }
            this.zza(stringBuilder, field, obj);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append("}");
        } else {
            stringBuilder.append("{}");
        }
        return stringBuilder.toString();
    }

    protected Object zzb(Field field) {
        String string2 = field.zzuk();
        if (field.zzum() != null) {
            HashMap<String, Object> hashMap;
            zzaa.zza(this.zzdm(field.zzuk()) == null, "Concrete field shouldn't be value object: %s", field.zzuk());
            HashMap<String, Object> hashMap2 = hashMap = field.zzuj() ? this.zzuh() : this.zzug();
            if (hashMap != null) {
                return hashMap.get(string2);
            }
            try {
                char c = Character.toUpperCase(string2.charAt(0));
                String string3 = String.valueOf(string2.substring(1));
                String string4 = new StringBuilder(4 + String.valueOf(string3).length()).append("get").append(c).append(string3).toString();
                return this.getClass().getMethod(string4, new Class[0]).invoke((Object)this, new Object[0]);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return this.zzdm(field.zzuk());
    }

    private void zza(StringBuilder stringBuilder, Field field, Object object) {
        if (field.zzud() == 11) {
            Class<FastJsonResponse> clazz = field.zzum();
            stringBuilder.append(clazz.cast(object).toString());
        } else if (field.zzud() == 7) {
            stringBuilder.append("\"");
            stringBuilder.append(zzp.zzdu((String)object));
            stringBuilder.append("\"");
        } else {
            stringBuilder.append(object);
        }
    }

    private void zza(StringBuilder stringBuilder, Field field, ArrayList<Object> arrayList) {
        stringBuilder.append("[");
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            if (i > 0) {
                stringBuilder.append(",");
            }
            if ((object = arrayList.get(i)) == null) continue;
            this.zza(stringBuilder, field, object);
        }
        stringBuilder.append("]");
    }

    public static interface zza<I, O> {
        public int zzud();

        public int zzue();

        public I convertBack(O var1);
    }

    public static class Field<I, O>
    extends AbstractSafeParcelable {
        private final int mVersionCode;
        protected final int zzasJ;
        protected final boolean zzasK;
        protected final int zzasL;
        protected final boolean zzasM;
        protected final String zzasN;
        protected final int zzasO;
        protected final Class<? extends FastJsonResponse> zzasP;
        protected final String zzasQ;
        private FieldMappingDictionary zzasR;
        private zza<I, O> zzasS;
        public static final com.google.android.gms.common.server.response.zza CREATOR = new com.google.android.gms.common.server.response.zza();

        Field(int n, int n2, boolean bl, int n3, boolean bl2, String string2, int n4, String string3, ConverterWrapper converterWrapper) {
            this.mVersionCode = n;
            this.zzasJ = n2;
            this.zzasK = bl;
            this.zzasL = n3;
            this.zzasM = bl2;
            this.zzasN = string2;
            this.zzasO = n4;
            if (string3 == null) {
                this.zzasP = null;
                this.zzasQ = null;
            } else {
                this.zzasP = SafeParcelResponse.class;
                this.zzasQ = string3;
            }
            this.zzasS = converterWrapper == null ? null : converterWrapper.zzub();
        }

        protected Field(int n, boolean bl, int n2, boolean bl2, String string2, int n3, Class<? extends FastJsonResponse> clazz, zza<I, O> zza2) {
            this.mVersionCode = 1;
            this.zzasJ = n;
            this.zzasK = bl;
            this.zzasL = n2;
            this.zzasM = bl2;
            this.zzasN = string2;
            this.zzasO = n3;
            this.zzasP = clazz;
            this.zzasQ = clazz == null ? null : clazz.getCanonicalName();
            this.zzasS = zza2;
        }

        public int getVersionCode() {
            return this.mVersionCode;
        }

        public int zzud() {
            return this.zzasJ;
        }

        public boolean zzui() {
            return this.zzasK;
        }

        public int zzue() {
            return this.zzasL;
        }

        public boolean zzuj() {
            return this.zzasM;
        }

        public String zzuk() {
            return this.zzasN;
        }

        public int zzul() {
            return this.zzasO;
        }

        public Class<? extends FastJsonResponse> zzum() {
            return this.zzasP;
        }

        String zzun() {
            if (this.zzasQ == null) {
                return null;
            }
            return this.zzasQ;
        }

        public boolean zzuo() {
            return this.zzasS != null;
        }

        public void zza(FieldMappingDictionary fieldMappingDictionary) {
            this.zzasR = fieldMappingDictionary;
        }

        ConverterWrapper zzup() {
            if (this.zzasS == null) {
                return null;
            }
            return ConverterWrapper.zza(this.zzasS);
        }

        public Map<String, Field<?, ?>> zzuq() {
            zzaa.zzz(this.zzasQ);
            zzaa.zzz(this.zzasR);
            return this.zzasR.zzdq(this.zzasQ);
        }

        public I convertBack(O o) {
            return this.zzasS.convertBack(o);
        }

        public static Field<Integer, Integer> zzi(String string2, int n) {
            return new Field<Integer, Integer>(0, false, 0, false, string2, n, null, null);
        }

        public static Field<Boolean, Boolean> zzj(String string2, int n) {
            return new Field<Boolean, Boolean>(6, false, 6, false, string2, n, null, null);
        }

        public static Field<String, String> zzk(String string2, int n) {
            return new Field<String, String>(7, false, 7, false, string2, n, null, null);
        }

        public static <T extends FastJsonResponse> Field<T, T> zza(String string2, int n, Class<T> clazz) {
            return new Field(11, false, 11, false, string2, n, clazz, null);
        }

        public static <T extends FastJsonResponse> Field<ArrayList<T>, ArrayList<T>> zzb(String string2, int n, Class<T> clazz) {
            return new Field<ArrayList<T>, ArrayList<T>>(11, true, 11, true, string2, n, clazz, null);
        }

        public static Field zza(String string2, int n, zza<?, ?> zza2, boolean bl) {
            return new Field(zza2.zzud(), bl, zza2.zzue(), false, string2, n, null, zza2);
        }

        public void writeToParcel(Parcel parcel, int n) {
            com.google.android.gms.common.server.response.zza.zza(this, parcel, n);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Field\n");
            stringBuilder.append("            versionCode=").append(this.mVersionCode).append('\n');
            stringBuilder.append("                 typeIn=").append(this.zzasJ).append('\n');
            stringBuilder.append("            typeInArray=").append(this.zzasK).append('\n');
            stringBuilder.append("                typeOut=").append(this.zzasL).append('\n');
            stringBuilder.append("           typeOutArray=").append(this.zzasM).append('\n');
            stringBuilder.append("        outputFieldName=").append(this.zzasN).append('\n');
            stringBuilder.append("      safeParcelFieldId=").append(this.zzasO).append('\n');
            stringBuilder.append("       concreteTypeName=").append(this.zzun()).append('\n');
            if (this.zzum() != null) {
                stringBuilder.append("     concreteType.class=").append(this.zzum().getCanonicalName()).append('\n');
            }
            stringBuilder.append("          converterName=").append(this.zzasS == null ? "null" : this.zzasS.getClass().getCanonicalName()).append('\n');
            return stringBuilder.toString();
        }
    }
}

