/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.security;

import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.zzc;
import com.google.android.gms.common.zze;
import java.lang.reflect.Method;

public class ProviderInstaller {
    private static final zzc zzbnb = zzc.zzqV();
    private static final Object zzrs = new Object();
    private static Method zzbnc = null;
    public static final String PROVIDER_NAME = "GmsCore_OpenSSL";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void installIfNeeded(Context context) throws GooglePlayServicesRepairableException, GooglePlayServicesNotAvailableException {
        zzaa.zzb(context, (Object)"Context must not be null");
        zzbnb.zzaf(context);
        Context context2 = zze.getRemoteContext(context);
        if (context2 == null) {
            Log.e((String)"ProviderInstaller", (String)"Failed to get remote context");
            throw new GooglePlayServicesNotAvailableException(8);
        }
        Object object = zzrs;
        synchronized (object) {
            try {
                if (zzbnc == null) {
                    ProviderInstaller.zzbf(context2);
                }
                zzbnc.invoke(null, context2);
            }
            catch (Exception exception) {
                String string2 = String.valueOf(exception.getMessage());
                Log.e((String)"ProviderInstaller", (String)(string2.length() != 0 ? "Failed to install provider: ".concat(string2) : new String("Failed to install provider: ")));
                throw new GooglePlayServicesNotAvailableException(8);
            }
        }
    }

    public static void installIfNeededAsync(final Context context, final ProviderInstallListener providerInstallListener) {
        zzaa.zzb(context, (Object)"Context must not be null");
        zzaa.zzb(providerInstallListener, (Object)"Listener must not be null");
        zzaa.zzdc("Must be called on the UI thread");
        AsyncTask<Void, Void, Integer> asyncTask = new AsyncTask<Void, Void, Integer>(){

            protected Integer zzc(Void ... voidArray) {
                try {
                    ProviderInstaller.installIfNeeded(context);
                }
                catch (GooglePlayServicesRepairableException googlePlayServicesRepairableException) {
                    return googlePlayServicesRepairableException.getConnectionStatusCode();
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return googlePlayServicesNotAvailableException.errorCode;
                }
                return 0;
            }

            protected void zzg(Integer n) {
                if (n == 0) {
                    providerInstallListener.onProviderInstalled();
                } else {
                    Intent intent = zzbnb.zza(context, n, "pi");
                    providerInstallListener.onProviderInstallFailed(n, intent);
                }
            }

            protected /* synthetic */ void onPostExecute(Object object) {
                this.zzg((Integer)object);
            }

            protected /* synthetic */ Object doInBackground(Object[] objectArray) {
                return this.zzc((Void[])objectArray);
            }
        };
        asyncTask.execute((Object[])new Void[0]);
    }

    private static void zzbf(Context context) throws ClassNotFoundException, NoSuchMethodException {
        ClassLoader classLoader = context.getClassLoader();
        Class<?> clazz = classLoader.loadClass("com.google.android.gms.common.security.ProviderInstallerImpl");
        Class[] classArray = new Class[]{Context.class};
        zzbnc = clazz.getMethod("insertProvider", classArray);
    }

    public static interface ProviderInstallListener {
        public void onProviderInstalled();

        public void onProviderInstallFailed(int var1, Intent var2);
    }
}

