/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.support.design.R;
import android.support.design.widget.CoordinatorLayoutInsetsHelper;
import android.support.design.widget.CoordinatorLayoutInsetsHelperLollipop;
import android.support.design.widget.ViewGroupUtils;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.GravityCompat;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.NestedScrollingParent;
import android.support.v4.view.NestedScrollingParentHelper;
import android.support.v4.view.OnApplyWindowInsetsListener;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.WindowInsetsCompat;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CoordinatorLayout
extends ViewGroup
implements NestedScrollingParent {
    static final String TAG = "CoordinatorLayout";
    static final String WIDGET_PACKAGE_NAME = CoordinatorLayout.class.getPackage().getName();
    private static final int TYPE_ON_INTERCEPT = 0;
    private static final int TYPE_ON_TOUCH = 1;
    static final Class<?>[] CONSTRUCTOR_PARAMS;
    static final ThreadLocal<Map<String, Constructor<Behavior>>> sConstructors;
    final Comparator<View> mLayoutDependencyComparator = new Comparator<View>(){

        @Override
        public int compare(View lhs, View rhs) {
            if (lhs == rhs) {
                return 0;
            }
            if (((LayoutParams)lhs.getLayoutParams()).dependsOn(CoordinatorLayout.this, lhs, rhs)) {
                return 1;
            }
            if (((LayoutParams)rhs.getLayoutParams()).dependsOn(CoordinatorLayout.this, rhs, lhs)) {
                return -1;
            }
            return 0;
        }
    };
    static final Comparator<View> TOP_SORTED_CHILDREN_COMPARATOR;
    static final CoordinatorLayoutInsetsHelper INSETS_HELPER;
    private final List<View> mDependencySortedChildren = new ArrayList<View>();
    private final List<View> mTempList1 = new ArrayList<View>();
    private final List<View> mTempDependenciesList = new ArrayList<View>();
    private final Rect mTempRect1 = new Rect();
    private final Rect mTempRect2 = new Rect();
    private final Rect mTempRect3 = new Rect();
    private final int[] mTempIntPair = new int[2];
    private Paint mScrimPaint;
    private boolean mIsAttachedToWindow;
    private int[] mKeylines;
    private View mBehaviorTouchView;
    private View mNestedScrollingDirectChild;
    private View mNestedScrollingTarget;
    private OnPreDrawListener mOnPreDrawListener;
    private boolean mNeedsPreDrawListener;
    private WindowInsetsCompat mLastInsets;
    private boolean mDrawStatusBarBackground;
    private Drawable mStatusBarBackground;
    private ViewGroup.OnHierarchyChangeListener mOnHierarchyChangeListener;
    private final NestedScrollingParentHelper mNestedScrollingParentHelper = new NestedScrollingParentHelper((ViewGroup)this);

    public CoordinatorLayout(Context context) {
        this(context, null);
    }

    public CoordinatorLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CoordinatorLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CoordinatorLayout, defStyleAttr, R.style.Widget_Design_CoordinatorLayout);
        int keylineArrayRes = a.getResourceId(R.styleable.CoordinatorLayout_keylines, 0);
        if (keylineArrayRes != 0) {
            Resources res = context.getResources();
            this.mKeylines = res.getIntArray(keylineArrayRes);
            float density = res.getDisplayMetrics().density;
            int count = this.mKeylines.length;
            int i = 0;
            while (i < count) {
                int n = i++;
                this.mKeylines[n] = (int)((float)this.mKeylines[n] * density);
            }
        }
        this.mStatusBarBackground = a.getDrawable(R.styleable.CoordinatorLayout_statusBarBackground);
        a.recycle();
        if (INSETS_HELPER != null) {
            INSETS_HELPER.setupForWindowInsets((View)this, new ApplyInsetsListener());
        }
        super.setOnHierarchyChangeListener((ViewGroup.OnHierarchyChangeListener)new HierarchyChangeListener());
    }

    public void setOnHierarchyChangeListener(ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener) {
        this.mOnHierarchyChangeListener = onHierarchyChangeListener;
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.resetTouchBehaviors();
        if (this.mNeedsPreDrawListener) {
            if (this.mOnPreDrawListener == null) {
                this.mOnPreDrawListener = new OnPreDrawListener();
            }
            ViewTreeObserver vto = this.getViewTreeObserver();
            vto.addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this.mOnPreDrawListener);
        }
        if (this.mLastInsets == null && ViewCompat.getFitsSystemWindows((View)this)) {
            ViewCompat.requestApplyInsets((View)this);
        }
        this.mIsAttachedToWindow = true;
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.resetTouchBehaviors();
        if (this.mNeedsPreDrawListener && this.mOnPreDrawListener != null) {
            ViewTreeObserver vto = this.getViewTreeObserver();
            vto.removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this.mOnPreDrawListener);
        }
        if (this.mNestedScrollingTarget != null) {
            this.onStopNestedScroll(this.mNestedScrollingTarget);
        }
        this.mIsAttachedToWindow = false;
    }

    public void setStatusBarBackground(Drawable bg) {
        this.mStatusBarBackground = bg;
        this.invalidate();
    }

    public Drawable getStatusBarBackground() {
        return this.mStatusBarBackground;
    }

    public void setStatusBarBackgroundResource(int resId) {
        this.setStatusBarBackground(resId != 0 ? ContextCompat.getDrawable((Context)this.getContext(), (int)resId) : null);
    }

    public void setStatusBarBackgroundColor(int color2) {
        this.setStatusBarBackground((Drawable)new ColorDrawable(color2));
    }

    private void setWindowInsets(WindowInsetsCompat insets) {
        if (this.mLastInsets != insets) {
            this.mLastInsets = insets;
            this.mDrawStatusBarBackground = insets != null && insets.getSystemWindowInsetTop() > 0;
            this.setWillNotDraw(!this.mDrawStatusBarBackground && this.getBackground() == null);
            this.dispatchChildApplyWindowInsets(insets);
            this.requestLayout();
        }
    }

    private void resetTouchBehaviors() {
        if (this.mBehaviorTouchView != null) {
            Behavior b = ((LayoutParams)this.mBehaviorTouchView.getLayoutParams()).getBehavior();
            if (b != null) {
                long now = SystemClock.uptimeMillis();
                MotionEvent cancelEvent = MotionEvent.obtain((long)now, (long)now, (int)3, (float)0.0f, (float)0.0f, (int)0);
                b.onTouchEvent(this, this.mBehaviorTouchView, cancelEvent);
                cancelEvent.recycle();
            }
            this.mBehaviorTouchView = null;
        }
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            lp.resetTouchBehaviorTracking();
        }
    }

    private void getTopSortedChildren(List<View> out) {
        out.clear();
        boolean useCustomOrder = this.isChildrenDrawingOrderEnabled();
        int childCount = this.getChildCount();
        for (int i = childCount - 1; i >= 0; --i) {
            int childIndex = useCustomOrder ? this.getChildDrawingOrder(childCount, i) : i;
            View child = this.getChildAt(childIndex);
            out.add(child);
        }
        if (TOP_SORTED_CHILDREN_COMPARATOR != null) {
            Collections.sort(out, TOP_SORTED_CHILDREN_COMPARATOR);
        }
    }

    private boolean performIntercept(MotionEvent ev, int type) {
        boolean intercepted = false;
        boolean newBlock = false;
        MotionEvent cancelEvent = null;
        int action = MotionEventCompat.getActionMasked((MotionEvent)ev);
        List<View> topmostChildList = this.mTempList1;
        this.getTopSortedChildren(topmostChildList);
        int childCount = topmostChildList.size();
        for (int i = 0; i < childCount; ++i) {
            View child = topmostChildList.get(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            Behavior b = lp.getBehavior();
            if ((intercepted || newBlock) && action != 0) {
                if (b == null) continue;
                if (cancelEvent == null) {
                    long now = SystemClock.uptimeMillis();
                    cancelEvent = MotionEvent.obtain((long)now, (long)now, (int)3, (float)0.0f, (float)0.0f, (int)0);
                }
                switch (type) {
                    case 0: {
                        b.onInterceptTouchEvent(this, child, cancelEvent);
                        break;
                    }
                    case 1: {
                        b.onTouchEvent(this, child, cancelEvent);
                    }
                }
                continue;
            }
            if (!intercepted && b != null) {
                switch (type) {
                    case 0: {
                        intercepted = b.onInterceptTouchEvent(this, child, ev);
                        break;
                    }
                    case 1: {
                        intercepted = b.onTouchEvent(this, child, ev);
                    }
                }
                if (intercepted) {
                    this.mBehaviorTouchView = child;
                }
            }
            boolean wasBlocking = lp.didBlockInteraction();
            boolean isBlocking = lp.isBlockingInteractionBelow(this, child);
            boolean bl = newBlock = isBlocking && !wasBlocking;
            if (isBlocking && !newBlock) break;
        }
        topmostChildList.clear();
        return intercepted;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        Object cancelEvent = null;
        int action = MotionEventCompat.getActionMasked((MotionEvent)ev);
        if (action == 0) {
            this.resetTouchBehaviors();
        }
        boolean intercepted = this.performIntercept(ev, 0);
        if (cancelEvent != null) {
            cancelEvent.recycle();
        }
        if (action == 1 || action == 3) {
            this.resetTouchBehaviors();
        }
        return intercepted;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        LayoutParams lp;
        Behavior b;
        boolean handled = false;
        boolean cancelSuper = false;
        MotionEvent cancelEvent = null;
        int action = MotionEventCompat.getActionMasked((MotionEvent)ev);
        if ((this.mBehaviorTouchView != null || (cancelSuper = this.performIntercept(ev, 1))) && (b = (lp = (LayoutParams)this.mBehaviorTouchView.getLayoutParams()).getBehavior()) != null) {
            handled = b.onTouchEvent(this, this.mBehaviorTouchView, ev);
        }
        if (this.mBehaviorTouchView == null) {
            handled |= super.onTouchEvent(ev);
        } else if (cancelSuper) {
            if (cancelEvent == null) {
                long now = SystemClock.uptimeMillis();
                cancelEvent = MotionEvent.obtain((long)now, (long)now, (int)3, (float)0.0f, (float)0.0f, (int)0);
            }
            super.onTouchEvent(cancelEvent);
        }
        if (handled || action == 0) {
            // empty if block
        }
        if (cancelEvent != null) {
            cancelEvent.recycle();
        }
        if (action == 1 || action == 3) {
            this.resetTouchBehaviors();
        }
        return handled;
    }

    public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        super.requestDisallowInterceptTouchEvent(disallowIntercept);
        if (disallowIntercept) {
            this.resetTouchBehaviors();
        }
    }

    private int getKeyline(int index) {
        if (this.mKeylines == null) {
            Log.e((String)TAG, (String)("No keylines defined for " + (Object)((Object)this) + " - attempted index lookup " + index));
            return 0;
        }
        if (index < 0 || index >= this.mKeylines.length) {
            Log.e((String)TAG, (String)("Keyline index " + index + " out of range for " + (Object)((Object)this)));
            return 0;
        }
        return this.mKeylines[index];
    }

    static Behavior parseBehavior(Context context, AttributeSet attrs, String name) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        String fullName = name.startsWith(".") ? context.getPackageName() + name : (name.indexOf(46) >= 0 ? name : WIDGET_PACKAGE_NAME + '.' + name);
        try {
            Constructor<Behavior<Object>> c;
            Map<String, Constructor<Behavior>> constructors = sConstructors.get();
            if (constructors == null) {
                constructors = new HashMap<String, Constructor<Behavior>>();
                sConstructors.set(constructors);
            }
            if ((c = constructors.get(fullName)) == null) {
                Class<?> clazz = Class.forName(fullName, true, context.getClassLoader());
                c = clazz.getConstructor(CONSTRUCTOR_PARAMS);
                c.setAccessible(true);
                constructors.put(fullName, c);
            }
            return c.newInstance(context, attrs);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not inflate Behavior subclass " + fullName, e);
        }
    }

    LayoutParams getResolvedLayoutParams(View child) {
        LayoutParams result = (LayoutParams)child.getLayoutParams();
        if (!result.mBehaviorResolved) {
            DefaultBehavior defaultBehavior = null;
            for (Class<?> childClass = child.getClass(); childClass != null && (defaultBehavior = childClass.getAnnotation(DefaultBehavior.class)) == null; childClass = childClass.getSuperclass()) {
            }
            if (defaultBehavior != null) {
                try {
                    result.setBehavior(defaultBehavior.value().newInstance());
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("Default behavior class " + defaultBehavior.value().getName() + " could not be instantiated. Did you forget a default constructor?"), (Throwable)e);
                }
            }
            result.mBehaviorResolved = true;
        }
        return result;
    }

    private void prepareChildren() {
        int i;
        int childCount = this.getChildCount();
        boolean resortRequired = this.mDependencySortedChildren.size() != childCount;
        for (i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = this.getResolvedLayoutParams(child);
            if (!resortRequired && lp.isDirty(this, child)) {
                resortRequired = true;
            }
            lp.findAnchorView(this, child);
        }
        if (resortRequired) {
            this.mDependencySortedChildren.clear();
            for (i = 0; i < childCount; ++i) {
                this.mDependencySortedChildren.add(this.getChildAt(i));
            }
            Collections.sort(this.mDependencySortedChildren, this.mLayoutDependencyComparator);
        }
    }

    void getDescendantRect(View descendant, Rect out) {
        ViewGroupUtils.getDescendantRect(this, descendant, out);
    }

    protected int getSuggestedMinimumWidth() {
        return Math.max(super.getSuggestedMinimumWidth(), this.getPaddingLeft() + this.getPaddingRight());
    }

    protected int getSuggestedMinimumHeight() {
        return Math.max(super.getSuggestedMinimumHeight(), this.getPaddingTop() + this.getPaddingBottom());
    }

    public void onMeasureChild(View child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
        this.measureChildWithMargins(child, parentWidthMeasureSpec, widthUsed, parentHeightMeasureSpec, heightUsed);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.prepareChildren();
        this.ensurePreDrawListener();
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        int paddingRight = this.getPaddingRight();
        int paddingBottom = this.getPaddingBottom();
        int layoutDirection = ViewCompat.getLayoutDirection((View)this);
        boolean isRtl = layoutDirection == 1;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int widthPadding = paddingLeft + paddingRight;
        int heightPadding = paddingTop + paddingBottom;
        int widthUsed = this.getSuggestedMinimumWidth();
        int heightUsed = this.getSuggestedMinimumHeight();
        int childState = 0;
        boolean applyInsets = this.mLastInsets != null && ViewCompat.getFitsSystemWindows((View)this);
        int childCount = this.mDependencySortedChildren.size();
        for (int i = 0; i < childCount; ++i) {
            Behavior b;
            View child = this.mDependencySortedChildren.get(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int keylineWidthUsed = 0;
            if (lp.keyline >= 0 && widthMode != 0) {
                int keylinePos = this.getKeyline(lp.keyline);
                int keylineGravity = GravityCompat.getAbsoluteGravity((int)CoordinatorLayout.resolveKeylineGravity(lp.gravity), (int)layoutDirection) & 7;
                if (keylineGravity == 3 && !isRtl || keylineGravity == 5 && isRtl) {
                    keylineWidthUsed = Math.max(0, widthSize - paddingRight - keylinePos);
                } else if (keylineGravity == 5 && !isRtl || keylineGravity == 3 && isRtl) {
                    keylineWidthUsed = Math.max(0, keylinePos - paddingLeft);
                }
            }
            int childWidthMeasureSpec = widthMeasureSpec;
            int childHeightMeasureSpec = heightMeasureSpec;
            if (applyInsets && !ViewCompat.getFitsSystemWindows((View)child)) {
                int horizInsets = this.mLastInsets.getSystemWindowInsetLeft() + this.mLastInsets.getSystemWindowInsetRight();
                int vertInsets = this.mLastInsets.getSystemWindowInsetTop() + this.mLastInsets.getSystemWindowInsetBottom();
                childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(widthSize - horizInsets), (int)widthMode);
                childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(heightSize - vertInsets), (int)heightMode);
            }
            if ((b = lp.getBehavior()) == null || !b.onMeasureChild(this, child, childWidthMeasureSpec, keylineWidthUsed, childHeightMeasureSpec, 0)) {
                this.onMeasureChild(child, childWidthMeasureSpec, keylineWidthUsed, childHeightMeasureSpec, 0);
            }
            widthUsed = Math.max(widthUsed, widthPadding + child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin);
            heightUsed = Math.max(heightUsed, heightPadding + child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin);
            childState = ViewCompat.combineMeasuredStates((int)childState, (int)ViewCompat.getMeasuredState((View)child));
        }
        int width = ViewCompat.resolveSizeAndState((int)widthUsed, (int)widthMeasureSpec, (int)(childState & 0xFF000000));
        int height = ViewCompat.resolveSizeAndState((int)heightUsed, (int)heightMeasureSpec, (int)(childState << 16));
        this.setMeasuredDimension(width, height);
    }

    private void dispatchChildApplyWindowInsets(WindowInsetsCompat insets) {
        LayoutParams lp;
        Behavior b;
        View child;
        if (insets.isConsumed()) {
            return;
        }
        int z = this.getChildCount();
        for (int i = 0; !(i >= z || ViewCompat.getFitsSystemWindows((View)(child = this.getChildAt(i))) && ((b = (lp = (LayoutParams)child.getLayoutParams()).getBehavior()) != null && (insets = b.onApplyWindowInsets(this, child, insets)).isConsumed() || (insets = ViewCompat.dispatchApplyWindowInsets((View)child, (WindowInsetsCompat)insets)).isConsumed())); ++i) {
        }
    }

    public void onLayoutChild(View child, int layoutDirection) {
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        if (lp.checkAnchorChanged()) {
            throw new IllegalStateException("An anchor may not be changed after CoordinatorLayout measurement begins before layout is complete.");
        }
        if (lp.mAnchorView != null) {
            this.layoutChildWithAnchor(child, lp.mAnchorView, layoutDirection);
        } else if (lp.keyline >= 0) {
            this.layoutChildWithKeyline(child, lp.keyline, layoutDirection);
        } else {
            this.layoutChild(child, layoutDirection);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int layoutDirection = ViewCompat.getLayoutDirection((View)this);
        int childCount = this.mDependencySortedChildren.size();
        for (int i = 0; i < childCount; ++i) {
            View child = this.mDependencySortedChildren.get(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            Behavior behavior = lp.getBehavior();
            if (behavior != null && behavior.onLayoutChild(this, child, layoutDirection)) continue;
            this.onLayoutChild(child, layoutDirection);
        }
    }

    public void onDraw(Canvas c) {
        super.onDraw(c);
        if (this.mDrawStatusBarBackground && this.mStatusBarBackground != null) {
            int inset;
            int n = inset = this.mLastInsets != null ? this.mLastInsets.getSystemWindowInsetTop() : 0;
            if (inset > 0) {
                this.mStatusBarBackground.setBounds(0, 0, this.getWidth(), inset);
                this.mStatusBarBackground.draw(c);
            }
        }
    }

    void recordLastChildRect(View child, Rect r) {
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        lp.setLastChildRect(r);
    }

    void getLastChildRect(View child, Rect out) {
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        out.set(lp.getLastChildRect());
    }

    void getChildRect(View child, boolean transform, Rect out) {
        if (child.isLayoutRequested() || child.getVisibility() == 8) {
            out.set(0, 0, 0, 0);
            return;
        }
        if (transform) {
            this.getDescendantRect(child, out);
        } else {
            out.set(child.getLeft(), child.getTop(), child.getRight(), child.getBottom());
        }
    }

    void getDesiredAnchoredChildRect(View child, int layoutDirection, Rect anchorRect, Rect out) {
        int top;
        int left;
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        int absGravity = GravityCompat.getAbsoluteGravity((int)CoordinatorLayout.resolveAnchoredChildGravity(lp.gravity), (int)layoutDirection);
        int absAnchorGravity = GravityCompat.getAbsoluteGravity((int)CoordinatorLayout.resolveGravity(lp.anchorGravity), (int)layoutDirection);
        int hgrav = absGravity & 7;
        int vgrav = absGravity & 0x70;
        int anchorHgrav = absAnchorGravity & 7;
        int anchorVgrav = absAnchorGravity & 0x70;
        int childWidth = child.getMeasuredWidth();
        int childHeight = child.getMeasuredHeight();
        switch (anchorHgrav) {
            default: {
                left = anchorRect.left;
                break;
            }
            case 5: {
                left = anchorRect.right;
                break;
            }
            case 1: {
                left = anchorRect.left + anchorRect.width() / 2;
            }
        }
        switch (anchorVgrav) {
            default: {
                top = anchorRect.top;
                break;
            }
            case 80: {
                top = anchorRect.bottom;
                break;
            }
            case 16: {
                top = anchorRect.top + anchorRect.height() / 2;
            }
        }
        switch (hgrav) {
            default: {
                left -= childWidth;
                break;
            }
            case 5: {
                break;
            }
            case 1: {
                left -= childWidth / 2;
            }
        }
        switch (vgrav) {
            default: {
                top -= childHeight;
                break;
            }
            case 80: {
                break;
            }
            case 16: {
                top -= childHeight / 2;
            }
        }
        int width = this.getWidth();
        int height = this.getHeight();
        left = Math.max(this.getPaddingLeft() + lp.leftMargin, Math.min(left, width - this.getPaddingRight() - childWidth - lp.rightMargin));
        top = Math.max(this.getPaddingTop() + lp.topMargin, Math.min(top, height - this.getPaddingBottom() - childHeight - lp.bottomMargin));
        out.set(left, top, left + childWidth, top + childHeight);
    }

    private void layoutChildWithAnchor(View child, View anchor, int layoutDirection) {
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        Rect anchorRect = this.mTempRect1;
        Rect childRect = this.mTempRect2;
        this.getDescendantRect(anchor, anchorRect);
        this.getDesiredAnchoredChildRect(child, layoutDirection, anchorRect, childRect);
        child.layout(childRect.left, childRect.top, childRect.right, childRect.bottom);
    }

    private void layoutChildWithKeyline(View child, int keyline, int layoutDirection) {
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        int absGravity = GravityCompat.getAbsoluteGravity((int)CoordinatorLayout.resolveKeylineGravity(lp.gravity), (int)layoutDirection);
        int hgrav = absGravity & 7;
        int vgrav = absGravity & 0x70;
        int width = this.getWidth();
        int height = this.getHeight();
        int childWidth = child.getMeasuredWidth();
        int childHeight = child.getMeasuredHeight();
        if (layoutDirection == 1) {
            keyline = width - keyline;
        }
        int left = this.getKeyline(keyline) - childWidth;
        int top = 0;
        switch (hgrav) {
            default: {
                break;
            }
            case 5: {
                left += childWidth;
                break;
            }
            case 1: {
                left += childWidth / 2;
            }
        }
        switch (vgrav) {
            default: {
                break;
            }
            case 80: {
                top += childHeight;
                break;
            }
            case 16: {
                top += childHeight / 2;
            }
        }
        left = Math.max(this.getPaddingLeft() + lp.leftMargin, Math.min(left, width - this.getPaddingRight() - childWidth - lp.rightMargin));
        top = Math.max(this.getPaddingTop() + lp.topMargin, Math.min(top, height - this.getPaddingBottom() - childHeight - lp.bottomMargin));
        child.layout(left, top, left + childWidth, top + childHeight);
    }

    private void layoutChild(View child, int layoutDirection) {
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        Rect parent = this.mTempRect1;
        parent.set(this.getPaddingLeft() + lp.leftMargin, this.getPaddingTop() + lp.topMargin, this.getWidth() - this.getPaddingRight() - lp.rightMargin, this.getHeight() - this.getPaddingBottom() - lp.bottomMargin);
        if (this.mLastInsets != null && ViewCompat.getFitsSystemWindows((View)this) && !ViewCompat.getFitsSystemWindows((View)child)) {
            parent.left += this.mLastInsets.getSystemWindowInsetLeft();
            parent.top += this.mLastInsets.getSystemWindowInsetTop();
            parent.right -= this.mLastInsets.getSystemWindowInsetRight();
            parent.bottom -= this.mLastInsets.getSystemWindowInsetBottom();
        }
        Rect out = this.mTempRect2;
        GravityCompat.apply((int)CoordinatorLayout.resolveGravity(lp.gravity), (int)child.getMeasuredWidth(), (int)child.getMeasuredHeight(), (Rect)parent, (Rect)out, (int)layoutDirection);
        child.layout(out.left, out.top, out.right, out.bottom);
    }

    private static int resolveGravity(int gravity) {
        return gravity == 0 ? 0x800033 : gravity;
    }

    private static int resolveKeylineGravity(int gravity) {
        return gravity == 0 ? 8388661 : gravity;
    }

    private static int resolveAnchoredChildGravity(int gravity) {
        return gravity == 0 ? 17 : gravity;
    }

    protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        if (lp.mBehavior != null && lp.mBehavior.getScrimOpacity(this, child) > 0.0f) {
            if (this.mScrimPaint == null) {
                this.mScrimPaint = new Paint();
            }
            this.mScrimPaint.setColor(lp.mBehavior.getScrimColor(this, child));
            canvas.drawRect((float)this.getPaddingLeft(), (float)this.getPaddingTop(), (float)(this.getWidth() - this.getPaddingRight()), (float)(this.getHeight() - this.getPaddingBottom()), this.mScrimPaint);
        }
        return super.drawChild(canvas, child, drawingTime);
    }

    void dispatchOnDependentViewChanged(boolean fromNestedScroll) {
        int layoutDirection = ViewCompat.getLayoutDirection((View)this);
        int childCount = this.mDependencySortedChildren.size();
        for (int i = 0; i < childCount; ++i) {
            View child = this.mDependencySortedChildren.get(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            for (int j = 0; j < i; ++j) {
                View checkChild = this.mDependencySortedChildren.get(j);
                if (lp.mAnchorDirectChild != checkChild) continue;
                this.offsetChildToAnchor(child, layoutDirection);
            }
            Rect oldRect = this.mTempRect1;
            Rect newRect = this.mTempRect2;
            this.getLastChildRect(child, oldRect);
            this.getChildRect(child, true, newRect);
            if (oldRect.equals((Object)newRect)) continue;
            this.recordLastChildRect(child, newRect);
            for (int j = i + 1; j < childCount; ++j) {
                View checkChild = this.mDependencySortedChildren.get(j);
                LayoutParams checkLp = (LayoutParams)checkChild.getLayoutParams();
                Behavior b = checkLp.getBehavior();
                if (b == null || !b.layoutDependsOn(this, checkChild, child)) continue;
                if (!fromNestedScroll && checkLp.getChangedAfterNestedScroll()) {
                    checkLp.resetChangedAfterNestedScroll();
                    continue;
                }
                boolean handled = b.onDependentViewChanged(this, checkChild, child);
                if (!fromNestedScroll) continue;
                checkLp.setChangedAfterNestedScroll(handled);
            }
        }
    }

    void dispatchDependentViewRemoved(View removedChild) {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            Behavior b = lp.getBehavior();
            if (b == null || !b.layoutDependsOn(this, child, removedChild)) continue;
            b.onDependentViewRemoved(this, child, removedChild);
        }
    }

    public void dispatchDependentViewsChanged(View view) {
        int childCount = this.mDependencySortedChildren.size();
        boolean viewSeen = false;
        for (int i = 0; i < childCount; ++i) {
            LayoutParams lp;
            Behavior b;
            View child = this.mDependencySortedChildren.get(i);
            if (child == view) {
                viewSeen = true;
                continue;
            }
            if (!viewSeen || (b = (lp = (LayoutParams)child.getLayoutParams()).getBehavior()) == null || !lp.dependsOn(this, child, view)) continue;
            b.onDependentViewChanged(this, child, view);
        }
    }

    public List<View> getDependencies(View child) {
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        List<View> list = this.mTempDependenciesList;
        list.clear();
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View other = this.getChildAt(i);
            if (other == child || !lp.dependsOn(this, child, other)) continue;
            list.add(other);
        }
        return list;
    }

    void ensurePreDrawListener() {
        boolean hasDependencies = false;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (!this.hasDependencies(child)) continue;
            hasDependencies = true;
            break;
        }
        if (hasDependencies != this.mNeedsPreDrawListener) {
            if (hasDependencies) {
                this.addPreDrawListener();
            } else {
                this.removePreDrawListener();
            }
        }
    }

    boolean hasDependencies(View child) {
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        if (lp.mAnchorView != null) {
            return true;
        }
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View other = this.getChildAt(i);
            if (other == child || !lp.dependsOn(this, child, other)) continue;
            return true;
        }
        return false;
    }

    void addPreDrawListener() {
        if (this.mIsAttachedToWindow) {
            if (this.mOnPreDrawListener == null) {
                this.mOnPreDrawListener = new OnPreDrawListener();
            }
            ViewTreeObserver vto = this.getViewTreeObserver();
            vto.addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this.mOnPreDrawListener);
        }
        this.mNeedsPreDrawListener = true;
    }

    void removePreDrawListener() {
        if (this.mIsAttachedToWindow && this.mOnPreDrawListener != null) {
            ViewTreeObserver vto = this.getViewTreeObserver();
            vto.removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this.mOnPreDrawListener);
        }
        this.mNeedsPreDrawListener = false;
    }

    void offsetChildToAnchor(View child, int layoutDirection) {
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        if (lp.mAnchorView != null) {
            Behavior b;
            Rect anchorRect = this.mTempRect1;
            Rect childRect = this.mTempRect2;
            Rect desiredChildRect = this.mTempRect3;
            this.getDescendantRect(lp.mAnchorView, anchorRect);
            this.getChildRect(child, false, childRect);
            this.getDesiredAnchoredChildRect(child, layoutDirection, anchorRect, desiredChildRect);
            int dx = desiredChildRect.left - childRect.left;
            int dy = desiredChildRect.top - childRect.top;
            if (dx != 0) {
                child.offsetLeftAndRight(dx);
            }
            if (dy != 0) {
                child.offsetTopAndBottom(dy);
            }
            if ((dx != 0 || dy != 0) && (b = lp.getBehavior()) != null) {
                b.onDependentViewChanged(this, child, lp.mAnchorView);
            }
        }
    }

    public boolean isPointInChildBounds(View child, int x, int y) {
        Rect r = this.mTempRect1;
        this.getDescendantRect(child, r);
        return r.contains(x, y);
    }

    public boolean doViewsOverlap(View first, View second) {
        if (first.getVisibility() == 0 && second.getVisibility() == 0) {
            Rect firstRect = this.mTempRect1;
            this.getChildRect(first, first.getParent() != this, firstRect);
            Rect secondRect = this.mTempRect2;
            this.getChildRect(second, second.getParent() != this, secondRect);
            return firstRect.left <= secondRect.right && firstRect.top <= secondRect.bottom && firstRect.right >= secondRect.left && firstRect.bottom >= secondRect.top;
        }
        return false;
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        if (p instanceof LayoutParams) {
            return new LayoutParams((LayoutParams)p);
        }
        if (p instanceof ViewGroup.MarginLayoutParams) {
            return new LayoutParams((ViewGroup.MarginLayoutParams)p);
        }
        return new LayoutParams(p);
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams && super.checkLayoutParams(p);
    }

    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        boolean handled = false;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View view = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)view.getLayoutParams();
            Behavior viewBehavior = lp.getBehavior();
            if (viewBehavior != null) {
                boolean accepted = viewBehavior.onStartNestedScroll(this, view, child, target, nestedScrollAxes);
                handled |= accepted;
                lp.acceptNestedScroll(accepted);
                continue;
            }
            lp.acceptNestedScroll(false);
        }
        return handled;
    }

    public void onNestedScrollAccepted(View child, View target, int nestedScrollAxes) {
        this.mNestedScrollingParentHelper.onNestedScrollAccepted(child, target, nestedScrollAxes);
        this.mNestedScrollingDirectChild = child;
        this.mNestedScrollingTarget = target;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            Behavior viewBehavior;
            View view = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)view.getLayoutParams();
            if (!lp.isNestedScrollAccepted() || (viewBehavior = lp.getBehavior()) == null) continue;
            viewBehavior.onNestedScrollAccepted(this, view, child, target, nestedScrollAxes);
        }
    }

    public void onStopNestedScroll(View target) {
        this.mNestedScrollingParentHelper.onStopNestedScroll(target);
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View view = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)view.getLayoutParams();
            if (!lp.isNestedScrollAccepted()) continue;
            Behavior viewBehavior = lp.getBehavior();
            if (viewBehavior != null) {
                viewBehavior.onStopNestedScroll(this, view, target);
            }
            lp.resetNestedScroll();
            lp.resetChangedAfterNestedScroll();
        }
        this.mNestedScrollingDirectChild = null;
        this.mNestedScrollingTarget = null;
    }

    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        int childCount = this.getChildCount();
        boolean accepted = false;
        for (int i = 0; i < childCount; ++i) {
            Behavior viewBehavior;
            View view = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)view.getLayoutParams();
            if (!lp.isNestedScrollAccepted() || (viewBehavior = lp.getBehavior()) == null) continue;
            viewBehavior.onNestedScroll(this, view, target, dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed);
            accepted = true;
        }
        if (accepted) {
            this.dispatchOnDependentViewChanged(true);
        }
    }

    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        int xConsumed = 0;
        int yConsumed = 0;
        boolean accepted = false;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            Behavior viewBehavior;
            View view = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)view.getLayoutParams();
            if (!lp.isNestedScrollAccepted() || (viewBehavior = lp.getBehavior()) == null) continue;
            this.mTempIntPair[1] = 0;
            this.mTempIntPair[0] = 0;
            viewBehavior.onNestedPreScroll(this, view, target, dx, dy, this.mTempIntPair);
            xConsumed = dx > 0 ? Math.max(xConsumed, this.mTempIntPair[0]) : Math.min(xConsumed, this.mTempIntPair[0]);
            yConsumed = dy > 0 ? Math.max(yConsumed, this.mTempIntPair[1]) : Math.min(yConsumed, this.mTempIntPair[1]);
            accepted = true;
        }
        consumed[0] = xConsumed;
        consumed[1] = yConsumed;
        if (accepted) {
            this.dispatchOnDependentViewChanged(true);
        }
    }

    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        boolean handled = false;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            Behavior viewBehavior;
            View view = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)view.getLayoutParams();
            if (!lp.isNestedScrollAccepted() || (viewBehavior = lp.getBehavior()) == null) continue;
            handled |= viewBehavior.onNestedFling(this, view, target, velocityX, velocityY, consumed);
        }
        if (handled) {
            this.dispatchOnDependentViewChanged(true);
        }
        return handled;
    }

    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        boolean handled = false;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            Behavior viewBehavior;
            View view = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)view.getLayoutParams();
            if (!lp.isNestedScrollAccepted() || (viewBehavior = lp.getBehavior()) == null) continue;
            handled |= viewBehavior.onNestedPreFling(this, view, target, velocityX, velocityY);
        }
        return handled;
    }

    public int getNestedScrollAxes() {
        return this.mNestedScrollingParentHelper.getNestedScrollAxes();
    }

    protected void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        SparseArray<Parcelable> behaviorStates = ss.behaviorStates;
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            Parcelable savedState;
            View child = this.getChildAt(i);
            int childId = child.getId();
            LayoutParams lp = this.getResolvedLayoutParams(child);
            Behavior b = lp.getBehavior();
            if (childId == -1 || b == null || (savedState = (Parcelable)behaviorStates.get(childId)) == null) continue;
            b.onRestoreInstanceState(this, child, savedState);
        }
    }

    protected Parcelable onSaveInstanceState() {
        SavedState ss = new SavedState(super.onSaveInstanceState());
        SparseArray behaviorStates = new SparseArray();
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            Parcelable state;
            View child = this.getChildAt(i);
            int childId = child.getId();
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            Behavior b = lp.getBehavior();
            if (childId == -1 || b == null || (state = b.onSaveInstanceState(this, child)) == null) continue;
            behaviorStates.append(childId, (Object)state);
        }
        ss.behaviorStates = behaviorStates;
        return ss;
    }

    static {
        if (Build.VERSION.SDK_INT >= 21) {
            TOP_SORTED_CHILDREN_COMPARATOR = new ViewElevationComparator();
            INSETS_HELPER = new CoordinatorLayoutInsetsHelperLollipop();
        } else {
            TOP_SORTED_CHILDREN_COMPARATOR = null;
            INSETS_HELPER = null;
        }
        CONSTRUCTOR_PARAMS = new Class[]{Context.class, AttributeSet.class};
        sConstructors = new ThreadLocal();
    }

    protected static class SavedState
    extends View.BaseSavedState {
        SparseArray<Parcelable> behaviorStates;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel source) {
                return new SavedState(source);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcel source) {
            super(source);
            int size = source.readInt();
            int[] ids = new int[size];
            source.readIntArray(ids);
            Parcelable[] states = source.readParcelableArray(CoordinatorLayout.class.getClassLoader());
            this.behaviorStates = new SparseArray(size);
            for (int i = 0; i < size; ++i) {
                this.behaviorStates.append(ids[i], (Object)states[i]);
            }
        }

        public SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            int size = this.behaviorStates != null ? this.behaviorStates.size() : 0;
            dest.writeInt(size);
            int[] ids = new int[size];
            Parcelable[] states = new Parcelable[size];
            for (int i = 0; i < size; ++i) {
                ids[i] = this.behaviorStates.keyAt(i);
                states[i] = (Parcelable)this.behaviorStates.valueAt(i);
            }
            dest.writeIntArray(ids);
            dest.writeParcelableArray(states, flags);
        }
    }

    final class HierarchyChangeListener
    implements ViewGroup.OnHierarchyChangeListener {
        HierarchyChangeListener() {
        }

        public void onChildViewAdded(View parent, View child) {
            if (CoordinatorLayout.this.mOnHierarchyChangeListener != null) {
                CoordinatorLayout.this.mOnHierarchyChangeListener.onChildViewAdded(parent, child);
            }
        }

        public void onChildViewRemoved(View parent, View child) {
            CoordinatorLayout.this.dispatchDependentViewRemoved(child);
            if (CoordinatorLayout.this.mOnHierarchyChangeListener != null) {
                CoordinatorLayout.this.mOnHierarchyChangeListener.onChildViewRemoved(parent, child);
            }
        }
    }

    final class ApplyInsetsListener
    implements OnApplyWindowInsetsListener {
        ApplyInsetsListener() {
        }

        public WindowInsetsCompat onApplyWindowInsets(View v, WindowInsetsCompat insets) {
            CoordinatorLayout.this.setWindowInsets(insets);
            return insets.consumeSystemWindowInsets();
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        Behavior mBehavior;
        boolean mBehaviorResolved = false;
        public int gravity = 0;
        public int anchorGravity = 0;
        public int keyline = -1;
        int mAnchorId = -1;
        View mAnchorView;
        View mAnchorDirectChild;
        private boolean mDidBlockInteraction;
        private boolean mDidAcceptNestedScroll;
        private boolean mDidChangeAfterNestedScroll;
        final Rect mLastChildRect = new Rect();
        Object mBehaviorTag;

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        LayoutParams(Context context, AttributeSet attrs) {
            super(context, attrs);
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CoordinatorLayout_LayoutParams);
            this.gravity = a.getInteger(R.styleable.CoordinatorLayout_LayoutParams_android_layout_gravity, 0);
            this.mAnchorId = a.getResourceId(R.styleable.CoordinatorLayout_LayoutParams_layout_anchor, -1);
            this.anchorGravity = a.getInteger(R.styleable.CoordinatorLayout_LayoutParams_layout_anchorGravity, 0);
            this.keyline = a.getInteger(R.styleable.CoordinatorLayout_LayoutParams_layout_keyline, -1);
            this.mBehaviorResolved = a.hasValue(R.styleable.CoordinatorLayout_LayoutParams_layout_behavior);
            if (this.mBehaviorResolved) {
                this.mBehavior = CoordinatorLayout.parseBehavior(context, attrs, a.getString(R.styleable.CoordinatorLayout_LayoutParams_layout_behavior));
            }
            a.recycle();
        }

        public LayoutParams(LayoutParams p) {
            super((ViewGroup.MarginLayoutParams)p);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams p) {
            super(p);
        }

        public LayoutParams(ViewGroup.LayoutParams p) {
            super(p);
        }

        public int getAnchorId() {
            return this.mAnchorId;
        }

        public void setAnchorId(int id2) {
            this.invalidateAnchor();
            this.mAnchorId = id2;
        }

        public Behavior getBehavior() {
            return this.mBehavior;
        }

        public void setBehavior(Behavior behavior) {
            if (this.mBehavior != behavior) {
                this.mBehavior = behavior;
                this.mBehaviorTag = null;
                this.mBehaviorResolved = true;
            }
        }

        void setLastChildRect(Rect r) {
            this.mLastChildRect.set(r);
        }

        Rect getLastChildRect() {
            return this.mLastChildRect;
        }

        boolean checkAnchorChanged() {
            return this.mAnchorView == null && this.mAnchorId != -1;
        }

        boolean didBlockInteraction() {
            if (this.mBehavior == null) {
                this.mDidBlockInteraction = false;
            }
            return this.mDidBlockInteraction;
        }

        boolean isBlockingInteractionBelow(CoordinatorLayout parent, View child) {
            if (this.mDidBlockInteraction) {
                return true;
            }
            return this.mDidBlockInteraction |= this.mBehavior != null ? this.mBehavior.blocksInteractionBelow(parent, child) : false;
        }

        void resetTouchBehaviorTracking() {
            this.mDidBlockInteraction = false;
        }

        void resetNestedScroll() {
            this.mDidAcceptNestedScroll = false;
        }

        void acceptNestedScroll(boolean accept) {
            this.mDidAcceptNestedScroll = accept;
        }

        boolean isNestedScrollAccepted() {
            return this.mDidAcceptNestedScroll;
        }

        boolean getChangedAfterNestedScroll() {
            return this.mDidChangeAfterNestedScroll;
        }

        void setChangedAfterNestedScroll(boolean changed) {
            this.mDidChangeAfterNestedScroll = changed;
        }

        void resetChangedAfterNestedScroll() {
            this.mDidChangeAfterNestedScroll = false;
        }

        boolean dependsOn(CoordinatorLayout parent, View child, View dependency) {
            return dependency == this.mAnchorDirectChild || this.mBehavior != null && this.mBehavior.layoutDependsOn(parent, child, dependency);
        }

        void invalidateAnchor() {
            this.mAnchorDirectChild = null;
            this.mAnchorView = null;
        }

        View findAnchorView(CoordinatorLayout parent, View forChild) {
            if (this.mAnchorId == -1) {
                this.mAnchorDirectChild = null;
                this.mAnchorView = null;
                return null;
            }
            if (this.mAnchorView == null || !this.verifyAnchorView(forChild, parent)) {
                this.resolveAnchorView(forChild, parent);
            }
            return this.mAnchorView;
        }

        boolean isDirty(CoordinatorLayout parent, View child) {
            return this.mBehavior != null && this.mBehavior.isDirty(parent, child);
        }

        private void resolveAnchorView(View forChild, CoordinatorLayout parent) {
            View directChild;
            this.mAnchorView = parent.findViewById(this.mAnchorId);
            if (this.mAnchorView != null) {
                directChild = this.mAnchorView;
                for (ViewParent p = this.mAnchorView.getParent(); p != parent && p != null; p = p.getParent()) {
                    if (p == forChild) {
                        if (parent.isInEditMode()) {
                            this.mAnchorDirectChild = null;
                            this.mAnchorView = null;
                            return;
                        }
                        throw new IllegalStateException("Anchor must not be a descendant of the anchored view");
                    }
                    if (!(p instanceof View)) continue;
                    directChild = (View)p;
                }
            } else {
                if (parent.isInEditMode()) {
                    this.mAnchorDirectChild = null;
                    this.mAnchorView = null;
                    return;
                }
                throw new IllegalStateException("Could not find CoordinatorLayout descendant view with id " + parent.getResources().getResourceName(this.mAnchorId) + " to anchor view " + forChild);
            }
            this.mAnchorDirectChild = directChild;
        }

        private boolean verifyAnchorView(View forChild, CoordinatorLayout parent) {
            if (this.mAnchorView.getId() != this.mAnchorId) {
                return false;
            }
            View directChild = this.mAnchorView;
            for (ViewParent p = this.mAnchorView.getParent(); p != parent; p = p.getParent()) {
                if (p == null || p == forChild) {
                    this.mAnchorDirectChild = null;
                    this.mAnchorView = null;
                    return false;
                }
                if (!(p instanceof View)) continue;
                directChild = (View)p;
            }
            this.mAnchorDirectChild = directChild;
            return true;
        }
    }

    public static abstract class Behavior<V extends View> {
        public Behavior() {
        }

        public Behavior(Context context, AttributeSet attrs) {
        }

        public boolean onInterceptTouchEvent(CoordinatorLayout parent, V child, MotionEvent ev) {
            return false;
        }

        public boolean onTouchEvent(CoordinatorLayout parent, V child, MotionEvent ev) {
            return false;
        }

        public final int getScrimColor(CoordinatorLayout parent, V child) {
            return -16777216;
        }

        public final float getScrimOpacity(CoordinatorLayout parent, V child) {
            return 0.0f;
        }

        public boolean blocksInteractionBelow(CoordinatorLayout parent, V child) {
            return this.getScrimOpacity(parent, child) > 0.0f;
        }

        public boolean layoutDependsOn(CoordinatorLayout parent, V child, View dependency) {
            return false;
        }

        public boolean onDependentViewChanged(CoordinatorLayout parent, V child, View dependency) {
            return false;
        }

        public void onDependentViewRemoved(CoordinatorLayout parent, V child, View dependency) {
        }

        public boolean isDirty(CoordinatorLayout parent, V child) {
            return false;
        }

        public boolean onMeasureChild(CoordinatorLayout parent, V child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
            return false;
        }

        public boolean onLayoutChild(CoordinatorLayout parent, V child, int layoutDirection) {
            return false;
        }

        public static void setTag(View child, Object tag) {
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            lp.mBehaviorTag = tag;
        }

        public static Object getTag(View child) {
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            return lp.mBehaviorTag;
        }

        public boolean onStartNestedScroll(CoordinatorLayout coordinatorLayout, V child, View directTargetChild, View target, int nestedScrollAxes) {
            return false;
        }

        public void onNestedScrollAccepted(CoordinatorLayout coordinatorLayout, V child, View directTargetChild, View target, int nestedScrollAxes) {
        }

        public void onStopNestedScroll(CoordinatorLayout coordinatorLayout, V child, View target) {
        }

        public void onNestedScroll(CoordinatorLayout coordinatorLayout, V child, View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        }

        public void onNestedPreScroll(CoordinatorLayout coordinatorLayout, V child, View target, int dx, int dy, int[] consumed) {
        }

        public boolean onNestedFling(CoordinatorLayout coordinatorLayout, V child, View target, float velocityX, float velocityY, boolean consumed) {
            return false;
        }

        public boolean onNestedPreFling(CoordinatorLayout coordinatorLayout, V child, View target, float velocityX, float velocityY) {
            return false;
        }

        public WindowInsetsCompat onApplyWindowInsets(CoordinatorLayout coordinatorLayout, V child, WindowInsetsCompat insets) {
            return insets;
        }

        public void onRestoreInstanceState(CoordinatorLayout parent, V child, Parcelable state) {
        }

        public Parcelable onSaveInstanceState(CoordinatorLayout parent, V child) {
            return View.BaseSavedState.EMPTY_STATE;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface DefaultBehavior {
        public Class<? extends Behavior> value();
    }

    static class ViewElevationComparator
    implements Comparator<View> {
        ViewElevationComparator() {
        }

        @Override
        public int compare(View lhs, View rhs) {
            float rz;
            float lz = ViewCompat.getZ((View)lhs);
            if (lz > (rz = ViewCompat.getZ((View)rhs))) {
                return -1;
            }
            if (lz < rz) {
                return 1;
            }
            return 0;
        }
    }

    class OnPreDrawListener
    implements ViewTreeObserver.OnPreDrawListener {
        OnPreDrawListener() {
        }

        public boolean onPreDraw() {
            CoordinatorLayout.this.dispatchOnDependentViewChanged(false);
            return true;
        }
    }
}

