/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.CipherBlockChaining;
import com.sun.crypto.provider.CipherFeedback;
import com.sun.crypto.provider.CipherTextStealing;
import com.sun.crypto.provider.ConstructKeys;
import com.sun.crypto.provider.CounterMode;
import com.sun.crypto.provider.ElectronicCodeBook;
import com.sun.crypto.provider.FeedbackCipher;
import com.sun.crypto.provider.GaloisCounterMode;
import com.sun.crypto.provider.ISO10126Padding;
import com.sun.crypto.provider.OutputFeedback;
import com.sun.crypto.provider.PCBC;
import com.sun.crypto.provider.PKCS5Padding;
import com.sun.crypto.provider.Padding;
import com.sun.crypto.provider.RC2Crypt;
import com.sun.crypto.provider.SunJCE;
import com.sun.crypto.provider.SymmetricCipher;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import java.util.Locale;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;

final class CipherCore {
    private byte[] buffer = null;
    private int blockSize = 0;
    private int unitBytes = 0;
    private int buffered = 0;
    private int minBytes = 0;
    private int diffBlocksize = 0;
    private Padding padding = null;
    private FeedbackCipher cipher = null;
    private int cipherMode = 0;
    private boolean decrypting = false;
    private static final int ECB_MODE = 0;
    private static final int CBC_MODE = 1;
    private static final int CFB_MODE = 2;
    private static final int OFB_MODE = 3;
    private static final int PCBC_MODE = 4;
    private static final int CTR_MODE = 5;
    private static final int CTS_MODE = 6;
    static final int GCM_MODE = 7;
    private boolean requireReinit = false;
    private byte[] lastEncKey = null;
    private byte[] lastEncIv = null;

    CipherCore(SymmetricCipher symmetricCipher, int n) {
        this.blockSize = n;
        this.unitBytes = n;
        this.diffBlocksize = n;
        this.buffer = new byte[this.blockSize * 2];
        this.cipher = new ElectronicCodeBook(symmetricCipher);
        this.padding = new PKCS5Padding(this.blockSize);
    }

    void setMode(String string) throws NoSuchAlgorithmException {
        if (string == null) {
            throw new NoSuchAlgorithmException("null mode");
        }
        String string2 = string.toUpperCase(Locale.ENGLISH);
        if (string2.equals("ECB")) {
            return;
        }
        SymmetricCipher symmetricCipher = this.cipher.getEmbeddedCipher();
        if (string2.equals("CBC")) {
            this.cipherMode = 1;
            this.cipher = new CipherBlockChaining(symmetricCipher);
        } else if (string2.equals("CTS")) {
            this.cipherMode = 6;
            this.cipher = new CipherTextStealing(symmetricCipher);
            this.minBytes = this.blockSize + 1;
            this.padding = null;
        } else if (string2.equals("CTR")) {
            this.cipherMode = 5;
            this.cipher = new CounterMode(symmetricCipher);
            this.unitBytes = 1;
            this.padding = null;
        } else if (string2.equals("GCM")) {
            if (this.blockSize != 16) {
                throw new NoSuchAlgorithmException("GCM mode can only be used for AES cipher");
            }
            this.cipherMode = 7;
            this.cipher = new GaloisCounterMode(symmetricCipher);
            this.padding = null;
        } else if (string2.startsWith("CFB")) {
            this.cipherMode = 2;
            this.unitBytes = CipherCore.getNumOfUnit(string, "CFB".length(), this.blockSize);
            this.cipher = new CipherFeedback(symmetricCipher, this.unitBytes);
        } else if (string2.startsWith("OFB")) {
            this.cipherMode = 3;
            this.unitBytes = CipherCore.getNumOfUnit(string, "OFB".length(), this.blockSize);
            this.cipher = new OutputFeedback(symmetricCipher, this.unitBytes);
        } else if (string2.equals("PCBC")) {
            this.cipherMode = 4;
            this.cipher = new PCBC(symmetricCipher);
        } else {
            throw new NoSuchAlgorithmException("Cipher mode: " + string + " not found");
        }
    }

    int getMode() {
        return this.cipherMode;
    }

    private static int getNumOfUnit(String string, int n, int n2) throws NoSuchAlgorithmException {
        int n3 = n2;
        if (string.length() > n) {
            int n4;
            try {
                Integer n5 = Integer.valueOf(string.substring(n));
                n4 = n5;
                n3 = n4 >> 3;
            }
            catch (NumberFormatException numberFormatException) {
                throw new NoSuchAlgorithmException("Algorithm mode: " + string + " not implemented");
            }
            if (n4 % 8 != 0 || n3 > n2) {
                throw new NoSuchAlgorithmException("Invalid algorithm mode: " + string);
            }
        }
        return n3;
    }

    void setPadding(String string) throws NoSuchPaddingException {
        if (string == null) {
            throw new NoSuchPaddingException("null padding");
        }
        if (string.equalsIgnoreCase("NoPadding")) {
            this.padding = null;
        } else if (string.equalsIgnoreCase("ISO10126Padding")) {
            this.padding = new ISO10126Padding(this.blockSize);
        } else if (!string.equalsIgnoreCase("PKCS5Padding")) {
            throw new NoSuchPaddingException("Padding: " + string + " not implemented");
        }
        if (this.padding != null && (this.cipherMode == 5 || this.cipherMode == 6 || this.cipherMode == 7)) {
            this.padding = null;
            String string2 = null;
            switch (this.cipherMode) {
                case 5: {
                    string2 = "CTR";
                    break;
                }
                case 7: {
                    string2 = "GCM";
                    break;
                }
                case 6: {
                    string2 = "CTS";
                    break;
                }
            }
            if (string2 != null) {
                throw new NoSuchPaddingException(string2 + " mode must be used with NoPadding");
            }
        }
    }

    int getOutputSize(int n) {
        return this.getOutputSizeByOperation(n, true);
    }

    private int getOutputSizeByOperation(int n, boolean bl) {
        int n2 = this.buffered + n + this.cipher.getBufferedLength();
        switch (this.cipherMode) {
            case 7: {
                if (bl) {
                    int n3 = ((GaloisCounterMode)this.cipher).getTagLen();
                    n2 = !this.decrypting ? (n2 += n3) : (n2 -= n3);
                }
                if (n2 >= 0) break;
                n2 = 0;
                break;
            }
            default: {
                if (this.padding == null || this.decrypting) break;
                if (this.unitBytes != this.blockSize) {
                    if (n2 < this.diffBlocksize) {
                        n2 = this.diffBlocksize;
                        break;
                    }
                    int n4 = (n2 - this.diffBlocksize) % this.blockSize;
                    n2 += this.blockSize - n4;
                    break;
                }
                n2 += this.padding.padLength(n2);
            }
        }
        return n2;
    }

    byte[] getIV() {
        byte[] byArray = this.cipher.getIV();
        return byArray == null ? null : (byte[])byArray.clone();
    }

    AlgorithmParameters getParameters(String string) {
        AlgorithmParameterSpec algorithmParameterSpec;
        if (this.cipherMode == 0) {
            return null;
        }
        AlgorithmParameters algorithmParameters = null;
        byte[] byArray = this.getIV();
        if (byArray == null) {
            byArray = this.cipherMode == 7 ? new byte[GaloisCounterMode.DEFAULT_IV_LEN] : new byte[this.blockSize];
            SunJCE.getRandom().nextBytes(byArray);
        }
        if (this.cipherMode == 7) {
            string = "GCM";
            algorithmParameterSpec = new GCMParameterSpec(((GaloisCounterMode)this.cipher).getTagLen() * 8, byArray);
        } else if (string.equals("RC2")) {
            RC2Crypt rC2Crypt = (RC2Crypt)this.cipher.getEmbeddedCipher();
            algorithmParameterSpec = new RC2ParameterSpec(rC2Crypt.getEffectiveKeyBits(), byArray);
        } else {
            algorithmParameterSpec = new IvParameterSpec(byArray);
        }
        try {
            algorithmParameters = AlgorithmParameters.getInstance(string, SunJCE.getInstance());
            algorithmParameters.init(algorithmParameterSpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("Cannot find " + string + " AlgorithmParameters implementation in SunJCE provider");
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new RuntimeException(algorithmParameterSpec.getClass() + " not supported");
        }
        return algorithmParameters;
    }

    void init(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.init(n, key, (AlgorithmParameterSpec)null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void init(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.decrypting = n == 2 || n == 4;
        byte[] byArray = CipherCore.getKeyBytes(key);
        int n2 = -1;
        byte[] byArray2 = null;
        if (algorithmParameterSpec != null) {
            if (this.cipherMode == 7) {
                if (!(algorithmParameterSpec instanceof GCMParameterSpec)) throw new InvalidAlgorithmParameterException("Unsupported parameter: " + algorithmParameterSpec);
                n2 = ((GCMParameterSpec)algorithmParameterSpec).getTLen();
                if (n2 < 96 || n2 > 128 || (n2 & 7) != 0) {
                    throw new InvalidAlgorithmParameterException("Unsupported TLen value; must be one of {128, 120, 112, 104, 96}");
                }
                n2 >>= 3;
                byArray2 = ((GCMParameterSpec)algorithmParameterSpec).getIV();
            } else if (algorithmParameterSpec instanceof IvParameterSpec) {
                byArray2 = ((IvParameterSpec)algorithmParameterSpec).getIV();
                if (byArray2 == null || byArray2.length != this.blockSize) {
                    throw new InvalidAlgorithmParameterException("Wrong IV length: must be " + this.blockSize + " bytes long");
                }
            } else {
                if (!(algorithmParameterSpec instanceof RC2ParameterSpec)) throw new InvalidAlgorithmParameterException("Unsupported parameter: " + algorithmParameterSpec);
                byArray2 = ((RC2ParameterSpec)algorithmParameterSpec).getIV();
                if (byArray2 != null && byArray2.length != this.blockSize) {
                    throw new InvalidAlgorithmParameterException("Wrong IV length: must be " + this.blockSize + " bytes long");
                }
            }
        }
        if (this.cipherMode == 0) {
            if (byArray2 != null) {
                throw new InvalidAlgorithmParameterException("ECB mode cannot use IV");
            }
        } else if (byArray2 == null) {
            if (this.decrypting) {
                throw new InvalidAlgorithmParameterException("Parameters missing");
            }
            if (secureRandom == null) {
                secureRandom = SunJCE.getRandom();
            }
            byArray2 = this.cipherMode == 7 ? new byte[GaloisCounterMode.DEFAULT_IV_LEN] : new byte[this.blockSize];
            secureRandom.nextBytes(byArray2);
        }
        this.buffered = 0;
        this.diffBlocksize = this.blockSize;
        String string = key.getAlgorithm();
        if (this.cipherMode == 7) {
            if (n2 == -1) {
                n2 = GaloisCounterMode.DEFAULT_TAG_LEN;
            }
            if (this.decrypting) {
                this.minBytes = n2;
            } else {
                boolean bl = this.requireReinit = Arrays.equals(byArray2, this.lastEncIv) && MessageDigest.isEqual(byArray, this.lastEncKey);
                if (this.requireReinit) {
                    throw new InvalidAlgorithmParameterException("Cannot reuse iv for GCM encryption");
                }
                this.lastEncIv = byArray2;
                this.lastEncKey = byArray;
            }
            ((GaloisCounterMode)this.cipher).init(this.decrypting, string, byArray, byArray2, n2);
        } else {
            this.cipher.init(this.decrypting, string, byArray, byArray2);
        }
        this.requireReinit = false;
    }

    void init(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec algorithmParameterSpec = null;
        String string = null;
        if (algorithmParameters != null) {
            try {
                if (this.cipherMode == 7) {
                    string = "GCM";
                    algorithmParameterSpec = algorithmParameters.getParameterSpec(GCMParameterSpec.class);
                } else {
                    string = "IV";
                    algorithmParameterSpec = algorithmParameters.getParameterSpec(IvParameterSpec.class);
                }
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new InvalidAlgorithmParameterException("Wrong parameter type: " + string + " expected");
            }
        }
        this.init(n, key, algorithmParameterSpec, secureRandom);
    }

    static byte[] getKeyBytes(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("No key given");
        }
        if (!"RAW".equalsIgnoreCase(key.getFormat())) {
            throw new InvalidKeyException("Wrong format: RAW bytes needed");
        }
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException("RAW key bytes missing");
        }
        return byArray;
    }

    byte[] update(byte[] byArray, int n, int n2) {
        if (this.requireReinit) {
            throw new IllegalStateException("Must use either different key or iv for GCM encryption");
        }
        byte[] byArray2 = null;
        try {
            byArray2 = new byte[this.getOutputSizeByOperation(n2, false)];
            int n3 = this.update(byArray, n, n2, byArray2, 0);
            if (n3 == byArray2.length) {
                return byArray2;
            }
            return Arrays.copyOf(byArray2, n3);
        }
        catch (ShortBufferException shortBufferException) {
            throw new ProviderException("Unexpected exception", shortBufferException);
        }
    }

    int update(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        if (this.requireReinit) {
            throw new IllegalStateException("Must use either different key or iv for GCM encryption");
        }
        int n4 = this.buffered + n2 - this.minBytes;
        if (this.padding != null && this.decrypting) {
            n4 -= this.blockSize;
        }
        int n5 = n4 = n4 > 0 ? n4 - n4 % this.unitBytes : 0;
        if (byArray2 == null || byArray2.length - n3 < n4) {
            throw new ShortBufferException("Output buffer must be (at least) " + n4 + " bytes long");
        }
        int n6 = 0;
        if (n4 != 0) {
            if (n4 <= this.buffered) {
                n6 = this.decrypting ? this.cipher.decrypt(this.buffer, 0, n4, byArray2, n3) : this.cipher.encrypt(this.buffer, 0, n4, byArray2, n3);
                this.buffered -= n4;
                if (this.buffered != 0) {
                    System.arraycopy(this.buffer, n4, this.buffer, 0, this.buffered);
                }
            } else if (byArray != byArray2 && this.buffered == 0) {
                n6 = this.decrypting ? this.cipher.decrypt(byArray, n, n4, byArray2, n3) : this.cipher.encrypt(byArray, n, n4, byArray2, n3);
                n += n4;
                n2 -= n4;
            } else {
                byte[] byArray3 = new byte[n4];
                int n7 = n4 - this.buffered;
                if (this.buffered != 0) {
                    System.arraycopy(this.buffer, 0, byArray3, 0, this.buffered);
                    this.buffered = 0;
                }
                if (n7 != 0) {
                    System.arraycopy(byArray, n, byArray3, n4 - n7, n7);
                    n += n7;
                    n2 -= n7;
                }
                n6 = this.decrypting ? this.cipher.decrypt(byArray3, 0, n4, byArray2, n3) : this.cipher.encrypt(byArray3, 0, n4, byArray2, n3);
            }
            if (this.unitBytes != this.blockSize) {
                this.diffBlocksize = n4 < this.diffBlocksize ? (this.diffBlocksize -= n4) : this.blockSize - (n4 - this.diffBlocksize) % this.blockSize;
            }
        }
        if (n2 > 0) {
            System.arraycopy(byArray, n, this.buffer, this.buffered, n2);
            this.buffered += n2;
        }
        return n6;
    }

    byte[] doFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        byte[] byArray2 = null;
        try {
            byArray2 = new byte[this.getOutputSizeByOperation(n2, true)];
            int n3 = this.doFinal(byArray, n, n2, byArray2, 0);
            if (n3 < byArray2.length) {
                return Arrays.copyOf(byArray2, n3);
            }
            return byArray2;
        }
        catch (ShortBufferException shortBufferException) {
            throw new ProviderException("Unexpected exception", shortBufferException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int doFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        int n5;
        if (this.requireReinit) {
            throw new IllegalStateException("Must use either different key or iv for GCM encryption");
        }
        int n6 = this.getOutputSizeByOperation(n2, true);
        int n7 = byArray2.length - n3;
        int n4 = n5 = this.decrypting ? n6 - this.blockSize : n6;
        if (byArray2 == null || n7 < n5) {
            throw new ShortBufferException("Output buffer must be (at least) " + n5 + " bytes long");
        }
        int n9 = this.buffered + n2;
        int n10 = n9 + this.cipher.getBufferedLength();
        int n11 = 0;
        if (this.unitBytes != this.blockSize) {
            n11 = n10 < this.diffBlocksize ? this.diffBlocksize - n10 : this.blockSize - (n10 - this.diffBlocksize) % this.blockSize;
        } else if (this.padding != null) {
            n11 = this.padding.padLength(n10);
        }
        if (this.decrypting && this.padding != null && n11 > 0 && n11 != this.blockSize) {
            throw new IllegalBlockSizeException("Input length must be multiple of " + this.blockSize + " when decrypting with padded cipher");
        }
        byte[] byArray3 = byArray;
        int n12 = n;
        int n13 = n2;
        if (byArray == byArray2 || this.buffered != 0 || !this.decrypting && this.padding != null) {
            if (this.decrypting || this.padding == null) {
                n11 = 0;
            }
            byArray3 = new byte[n9 + n11];
            n12 = 0;
            if (this.buffered != 0) {
                System.arraycopy(this.buffer, 0, byArray3, 0, this.buffered);
            }
            if (n2 != 0) {
                System.arraycopy(byArray, n, byArray3, this.buffered, n2);
            }
            if (n11 != 0) {
                this.padding.padWithLen(byArray3, this.buffered + n2, n11);
            }
            n13 = byArray3.length;
        }
        int n42 = 0;
        if (this.decrypting) {
            if (n7 < n6) {
                this.cipher.save();
            }
            byte[] byArray4 = new byte[n6];
            n42 = this.finalNoPadding(byArray3, n12, byArray4, 0, n13);
            if (this.padding != null) {
                int n14 = this.padding.unpad(byArray4, 0, n42);
                if (n14 < 0) {
                    throw new BadPaddingException("Given final block not properly padded");
                }
                n42 = n14;
            }
            if (n7 < n42) {
                this.cipher.restore();
                throw new ShortBufferException("Output buffer too short: " + n7 + " bytes given, " + n42 + " bytes needed");
            }
            System.arraycopy(byArray4, 0, byArray2, n3, n42);
        } else {
            boolean bl;
            try {
                n42 = this.finalNoPadding(byArray3, n12, byArray2, n3, n13);
                bl = this.cipherMode == 7;
            }
            catch (Throwable throwable) {
                this.requireReinit = this.cipherMode == 7;
                throw throwable;
            }
            this.requireReinit = bl;
        }
        this.buffered = 0;
        this.diffBlocksize = this.blockSize;
        if (this.cipherMode != 0) {
            this.cipher.reset();
        }
        return n42;
    }

    private int finalNoPadding(byte[] byArray, int n, byte[] byArray2, int n2, int n3) throws IllegalBlockSizeException, AEADBadTagException, ShortBufferException {
        if (this.cipherMode != 7 && (byArray == null || n3 == 0)) {
            return 0;
        }
        if (this.cipherMode != 2 && this.cipherMode != 3 && this.cipherMode != 7 && n3 % this.unitBytes != 0 && this.cipherMode != 6) {
            if (this.padding != null) {
                throw new IllegalBlockSizeException("Input length (with padding) not multiple of " + this.unitBytes + " bytes");
            }
            throw new IllegalBlockSizeException("Input length not multiple of " + this.unitBytes + " bytes");
        }
        int n4 = 0;
        n4 = this.decrypting ? this.cipher.decryptFinal(byArray, n, n3, byArray2, n2) : this.cipher.encryptFinal(byArray, n, n3, byArray2, n2);
        return n4;
    }

    byte[] wrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] byArray = null;
        try {
            byte[] byArray2 = key.getEncoded();
            if (byArray2 == null || byArray2.length == 0) {
                throw new InvalidKeyException("Cannot get an encoding of the key to be wrapped");
            }
            byArray = this.doFinal(byArray2, 0, byArray2.length);
        }
        catch (BadPaddingException badPaddingException) {
            // empty catch block
        }
        return byArray;
    }

    Key unwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] byArray2;
        try {
            byArray2 = this.doFinal(byArray, 0, byArray.length);
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException("The wrapped key is not padded correctly");
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new InvalidKeyException("The wrapped key does not have the correct length");
        }
        return ConstructKeys.constructKey(byArray2, string, n);
    }

    void updateAAD(byte[] byArray, int n, int n2) {
        if (this.requireReinit) {
            throw new IllegalStateException("Must use either different key or iv for GCM encryption");
        }
        this.cipher.updateAAD(byArray, n, n2);
    }
}

