/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PApplet;
import processing.core.PImage;
import processing.sound.SoundFile;

public class FarTer
extends PApplet {
    float bx;
    float by;
    int boxW = 250;
    int boxH = 50;
    boolean overBox = false;
    boolean locked = false;
    PImage img;
    SoundFile[] files;

    public void setup() {
        this.img = this.loadImage("bg.png");
        this.bx = (float)this.width / 2.0f;
        this.by = (float)this.height / 2.0f;
        this.rectMode(2);
        this.rect(this.bx, this.by, this.boxW, this.boxH);
        this.files = new SoundFile[2];
        int i = 0;
        while (i < this.files.length) {
            this.files[i] = new SoundFile((PApplet)this, String.valueOf(i + 1) + ".wav");
            ++i;
        }
    }

    public void draw() {
        this.background(0);
        if ((float)this.mouseX > this.bx - (float)this.boxW && (float)this.mouseX < this.bx + (float)this.boxW && (float)this.mouseY > this.by - (float)this.boxH && (float)this.mouseY < this.by + (float)this.boxH) {
            this.overBox = true;
            if (!this.locked) {
                this.stroke(255);
                this.strokeWeight(8.0f);
                this.fill(0.0f, 153.0f, 255.0f);
            }
        } else {
            this.stroke(0.0f, 153.0f, 255.0f);
            this.fill(0.0f, 153.0f, 255.0f);
            this.overBox = false;
        }
        this.rect(this.bx, this.by, this.boxW, this.boxH);
    }

    public void mousePressed() {
        this.files[0].stop();
        if (this.overBox) {
            this.locked = true;
            this.fill(0.0f, 204.0f, 102.0f);
            this.files[1].play();
        } else {
            this.locked = false;
        }
    }

    public void mouseDragged() {
        if (this.locked) {
            this.bx = this.mouseX;
            this.by = this.mouseY;
            if (this.bx > (float)(this.width - this.boxW)) {
                this.bx = this.width - this.boxW;
            }
            if (this.bx < (float)(0 + this.boxW)) {
                this.bx = 0 + this.boxW / 2;
            }
            if (this.by > (float)(this.height - this.boxH)) {
                this.by = this.height - this.boxH;
            }
            if (this.by < (float)(0 + this.boxH)) {
                this.by = 0 + this.boxH;
            }
        }
    }

    public void mouseReleased() {
        this.locked = false;
        this.files[1].stop();
        this.files[0].play(250.0f / this.by);
    }

    public void settings() {
        this.size(250, 800);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"FarTer"};
        if (passedArgs != null) {
            PApplet.main((String[])FarTer.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }
}

