import processing.core.*; 
import processing.data.*; 
import processing.event.*; 
import processing.opengl.*; 

import processing.sound.*; 

import java.util.HashMap; 
import java.util.ArrayList; 
import java.io.File; 
import java.io.BufferedReader; 
import java.io.PrintWriter; 
import java.io.InputStream; 
import java.io.OutputStream; 
import java.io.IOException; 

public class FarTer extends PApplet {



float bx;
float by;
int boxW = 250;
int boxH = 50;
boolean overBox = false;
boolean locked = false;
PImage img;

SoundFile[] files;

public void setup() {
  
  img = loadImage("bg.png");
  bx = width/2.0f;
  by = height/2.0f;
  rectMode(RADIUS);
  rect(bx, by, boxW, boxH);
  
  
  
  // Create an array of 5 empty soundfiles
  files = new SoundFile[2];

  for (int i = 0; i < files.length; i++) {
    files[i] = new SoundFile(this, (i+1) + ".wav");
  }
}

public void draw() {
  background(0);
  // If the determined trigger moment in time matches up with 
  // the computer clock events get triggered.
  // Test if the cursor is over the box 
  if (mouseX > bx-boxW && mouseX < bx+boxW && 
      mouseY > by-boxH && mouseY < by+boxH) {
    overBox = true;  
    if(!locked) { 
      
      stroke(255);
      strokeWeight(8);
      fill(0, 153, 255);
    } 
  } else {
    stroke(0, 153, 255);
    fill(0, 153, 255);
    overBox = false;
  }
  
  // Draw the box
  rect(bx, by, boxW, boxH);
}
  
public void mousePressed() {
  files[0].stop();
  if(overBox) { 
    locked = true; 
    fill(0, 204, 102);
    files[1].play();
  } else {
    locked = false;
  }
}

public void mouseDragged() {
  
  if(locked) {
    bx = mouseX; 
    by = mouseY;
    if(bx > width-boxW){
      bx = width-(boxW);
    } 
    if(bx < 0+boxW){
      bx = 0+(boxW/2);
    }
    if(by > height-boxH){
      by = height-(boxH);
    } 
    if(by < 0+boxH){
      by = 0+(boxH);
    }
  }
}

public void mouseReleased() {
  locked = false;
  files[1].stop();
  files[0].play(250/by);
}
  public void settings() {  size(250, 800); }
  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "FarTer" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
