import QtQuick 2.0
import Sailfish.Silica 1.0

import MemoryLeek 1.0

Page
{
	id: page

	RecordingPageViewModel
	{
		id: context

		onRecordingCompleted: pageStack.replace(Qt.resolvedUrl("MatchingPage.qml"), { "samples": context.data })
	}

	Item
	{
		anchors
		{
			centerIn: parent
		}

		width: visualizer.width
		height: visualizer.height

		AudioDataVisualizer
		{
			id: visualizer
			data: context.data
			width: page.width
			height: 200
			color: Theme.secondaryColor
			opacity: 0.7
		}

		Label
		{
			anchors
			{
				centerIn: visualizer
			}

			font
			{
				pixelSize: Theme.fontSizeLarge
			}

			color: Theme.highlightColor
			text: "Recording"
		}
	}
}
