//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID10d579c2_9afe_4f12_b640_3cd220061eee
{
    public class Class_AdjustColorsMasked : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image = 1,
            Exposure = 2,
            OverallR = 3,
            OverallG = 4,
            OverallB = 5,
            OverallA = 6,
            Saturation = 7,
            ExposureSMLX = 8,
            ExposureSMLY = 9,
            ExposureSMLZ = 10,
            ShadowsR = 11,
            ShadowsG = 12,
            ShadowsB = 13,
            ShadowsA = 14,
            MidtonesR = 15,
            MidtonesG = 16,
            MidtonesB = 17,
            MidtonesA = 18,
            LightsR = 19,
            LightsG = 20,
            LightsB = 21,
            LightsA = 22,
            SaturationSMLX = 23,
            SaturationSMLY = 24,
            SaturationSMLZ = 25,
            ClampShadowValue = 26,
            ClampShadowBias = 27,
            ClampLightValue = 28,
            ClampLightBias = 29,
            Mask = 30,
            SMLRangeLow = 31,
            SMLRangeHigh = 32
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            return PrepareAndEvalOnChange(context, () =>
            {
                
                //>>> __params
                var Code = inputs[(int)InputId.Code].Eval(context).Text;
                var Image = inputs[(int)InputId.Image].Eval(context).Image; 
                var Exposure = inputs[(int)InputId.Exposure].Eval(context).Value;
                var OverallR = inputs[(int)InputId.OverallR].Eval(context).Value;
                var OverallG = inputs[(int)InputId.OverallG].Eval(context).Value;
                var OverallB = inputs[(int)InputId.OverallB].Eval(context).Value;
                var OverallA = inputs[(int)InputId.OverallA].Eval(context).Value;
                var Overall = new Color4(OverallR, OverallG, OverallB, OverallA);
                var Saturation = inputs[(int)InputId.Saturation].Eval(context).Value;
                var ExposureSMLX = inputs[(int)InputId.ExposureSMLX].Eval(context).Value;
                var ExposureSMLY = inputs[(int)InputId.ExposureSMLY].Eval(context).Value;
                var ExposureSMLZ = inputs[(int)InputId.ExposureSMLZ].Eval(context).Value;
                var ExposureSML = new Vector3(ExposureSMLX, ExposureSMLY, ExposureSMLZ);
                var ShadowsR = inputs[(int)InputId.ShadowsR].Eval(context).Value;
                var ShadowsG = inputs[(int)InputId.ShadowsG].Eval(context).Value;
                var ShadowsB = inputs[(int)InputId.ShadowsB].Eval(context).Value;
                var ShadowsA = inputs[(int)InputId.ShadowsA].Eval(context).Value;
                var Shadows = new Color4(ShadowsR, ShadowsG, ShadowsB, ShadowsA);
                var MidtonesR = inputs[(int)InputId.MidtonesR].Eval(context).Value;
                var MidtonesG = inputs[(int)InputId.MidtonesG].Eval(context).Value;
                var MidtonesB = inputs[(int)InputId.MidtonesB].Eval(context).Value;
                var MidtonesA = inputs[(int)InputId.MidtonesA].Eval(context).Value;
                var Midtones = new Color4(MidtonesR, MidtonesG, MidtonesB, MidtonesA);
                var LightsR = inputs[(int)InputId.LightsR].Eval(context).Value;
                var LightsG = inputs[(int)InputId.LightsG].Eval(context).Value;
                var LightsB = inputs[(int)InputId.LightsB].Eval(context).Value;
                var LightsA = inputs[(int)InputId.LightsA].Eval(context).Value;
                var Lights = new Color4(LightsR, LightsG, LightsB, LightsA);
                var SaturationSMLX = inputs[(int)InputId.SaturationSMLX].Eval(context).Value;
                var SaturationSMLY = inputs[(int)InputId.SaturationSMLY].Eval(context).Value;
                var SaturationSMLZ = inputs[(int)InputId.SaturationSMLZ].Eval(context).Value;
                var SaturationSML = new Vector3(SaturationSMLX, SaturationSMLY, SaturationSMLZ);
                var ClampShadowValue = inputs[(int)InputId.ClampShadowValue].Eval(context).Value;
                var ClampShadowBias = inputs[(int)InputId.ClampShadowBias].Eval(context).Value;
                var ClampShadow = new Vector2(ClampShadowValue, ClampShadowBias);
                var ClampLightValue = inputs[(int)InputId.ClampLightValue].Eval(context).Value;
                var ClampLightBias = inputs[(int)InputId.ClampLightBias].Eval(context).Value;
                var ClampLight = new Vector2(ClampLightValue, ClampLightBias);
                var Mask = inputs[(int)InputId.Mask].Eval(context).Image; 
                var SMLRangeLow = inputs[(int)InputId.SMLRangeLow].Eval(context).Value;
                var SMLRangeHigh = inputs[(int)InputId.SMLRangeHigh].Eval(context).Value;
                var SMLRange = new Vector2(SMLRangeLow, SMLRangeHigh);
                //<<< __params
                
                if(Image == null || Mask == null) {
                    return;
                }
    
                ClearRenderTarget(context, new SharpDX.Color4(0,0, 0, 0));

                //>>> _setup
                using (var ImageView = new ShaderResourceView(context.D3DDevice, Image))
                using (var MaskView = new ShaderResourceView(context.D3DDevice, Mask))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Image").AsShaderResource().SetResource(ImageView);
                    _effect.GetVariableByName("Exposure").AsScalar().Set(Exposure);
                    _effect.GetVariableByName("Overall").AsVector().Set(new Vector4(OverallR, OverallG, OverallB, OverallA));
                    _effect.GetVariableByName("Saturation").AsScalar().Set(Saturation);
                    _effect.GetVariableByName("ExposureSML").AsVector().Set(new Vector3(ExposureSMLX, ExposureSMLY, ExposureSMLZ));
                    _effect.GetVariableByName("Shadows").AsVector().Set(new Vector4(ShadowsR, ShadowsG, ShadowsB, ShadowsA));
                    _effect.GetVariableByName("Midtones").AsVector().Set(new Vector4(MidtonesR, MidtonesG, MidtonesB, MidtonesA));
                    _effect.GetVariableByName("Lights").AsVector().Set(new Vector4(LightsR, LightsG, LightsB, LightsA));
                    _effect.GetVariableByName("SaturationSML").AsVector().Set(new Vector3(SaturationSMLX, SaturationSMLY, SaturationSMLZ));
                    _effect.GetVariableByName("ClampShadow").AsVector().Set(new Vector2(ClampShadowValue, ClampShadowBias));
                    _effect.GetVariableByName("ClampLight").AsVector().Set(new Vector2(ClampLightValue, ClampLightBias));
                    _effect.GetVariableByName("Mask").AsShaderResource().SetResource(MaskView);
                    _effect.GetVariableByName("SMLRange").AsVector().Set(new Vector2(SMLRangeLow, SMLRangeHigh));
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}
