//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID5afe15a6_0014_49e1_855b_d3d83fd20950
{
    public class Class_Displace2d : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Displacement = 1,
            Image = 2,
            Radius = 3,
            SizeX = 4,
            SizeY = 5,
            SampleCount = 6,
            ShiftX = 7,
            ShiftY = 8
        }
        //<<< _inputids
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {

            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Displacement = inputs[(int)InputId.Displacement].Eval(context).Image; if (Displacement == null) return context;
            var Image = inputs[(int)InputId.Image].Eval(context).Image; if (Image == null) return context;
            var Radius = inputs[(int)InputId.Radius].Eval(context).Value;
            var SizeX = inputs[(int)InputId.SizeX].Eval(context).Value;
            var SizeY = inputs[(int)InputId.SizeY].Eval(context).Value;
            var Size = new Vector2(SizeX, SizeY);
            var SampleCount = inputs[(int)InputId.SampleCount].Eval(context).Value;
            var ShiftX = inputs[(int)InputId.ShiftX].Eval(context).Value;
            var ShiftY = inputs[(int)InputId.ShiftY].Eval(context).Value;
            var Shift = new Vector2(ShiftX, ShiftY);
            //<<< _params

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));

                //>>> _setup
                using (var DisplacementView = new ShaderResourceView(context.D3DDevice, Displacement))
                using (var ImageView = new ShaderResourceView(context.D3DDevice, Image))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Displacement").AsShaderResource().SetResource(DisplacementView);
                    _effect.GetVariableByName("Image").AsShaderResource().SetResource(ImageView);
                    _effect.GetVariableByName("Radius").AsScalar().Set(Radius);
                    _effect.GetVariableByName("Size").AsVector().Set(new Vector2(SizeX, SizeY));
                    _effect.GetVariableByName("SampleCount").AsScalar().Set(SampleCount);
                    _effect.GetVariableByName("Shift").AsVector().Set(new Vector2(ShiftX, ShiftY));
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

