using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using Framefield.Core.Rendering;


namespace Framefield.Core.IDe5baefcc_00e9_4593_829a_907334eb8168
{
    public class Class_GetChildren : OperatorPart.Function
    {
        public class Renderer : BaseRenderer
        {
            public int StartIndex { get; set; }
            public int NumChilds { get; set; }

            public override void Render(Mesh mesh, OperatorPartContext context) {
                if (m_RenderCounter >= StartIndex && m_RenderCounter < StartIndex + NumChilds)
                    base.Render(mesh, context);
                ++m_RenderCounter;
            }

            public void ClearRenderCounter() {
                m_RenderCounter = 0;
            }

            private int m_RenderCounter = 0;
        }


        public Class_GetChildren() {
            m_Renderer = new Renderer();
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            var Scene = inputs[0];
            var Index = (float) inputs[1].Eval(context).Value;
            var Number = (float) inputs[2].Eval(context).Value;

            m_Renderer.StartIndex = (int)Index;
            m_Renderer.NumChilds = (int)Number;
            m_Renderer.ClearRenderCounter();

            var prevRenderer = context.Renderer;
            context.Renderer = m_Renderer;
            Scene.Eval(context);

            context.Renderer = prevRenderer;
            return context;
        }

        private Renderer m_Renderer;
    }
}

