//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDd8a02a63_4e91_40dc_86fd_04461a528a19
{
    public class Class_LightScreenPos : OperatorPart.Function, Framefield.Core.OperatorPartTraits.ITimeAccessor
    {
        //>>> _outputids
        private enum OutputId
        {
            ScreenPosX = 0,
            ScreenPosY = 1
        }
        //<<< _outputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            var pointLightContainer = (HashSet<IPointLight>) context.Objects[OperatorPartContext.POINT_LIGHT_CONTAINER_ID];
            if (pointLightContainer.Count > 0)
            {
                var pointLight = pointLightContainer.First();
                Matrix worldToView = context.WorldToCamera*context.CameraProjection;
                Vector4 pos = Vector3.Transform(pointLight.Position, worldToView);
                pos /= pos.W;

                if ((int)OutputId.ScreenPosX == outputIdx)
                    context.Value = pos.X;
                else
                    context.Value = pos.Y;
            }

            return context;
        }
    }
}

