//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDb3dd4c0e_298b_4103_9a91_05a8b5a08f83
{
    public class Class_Compare : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            Value1 = 0,
            Value2 = 1,
            Mode = 2
        }
        //<<< _inputids
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var Value1 = inputs[(int)InputId.Value1].Eval(context).Value;
            var Value2 = inputs[(int)InputId.Value2].Eval(context).Value;
            var Mode = (int) inputs[(int)InputId.Mode].Eval(context).Value;
            //<<< _params
                               
            switch ((int)Mode)
            {
                case 0: context.Value = Math.Min(Value1, Value2); break;
                case 1: context.Value = Math.Max(Value1, Value2); break;
            }
            return context;
        }
    }
}

