//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID911c12d0_a208_4488_9b9a_744bb58b5344
{
    public class Class_ReplaceColor : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image1 = 1,
            Image2 = 2,
            Radius = 3,
            SizeX = 4,
            SizeY = 5,
            ColorR = 6,
            ColorG = 7,
            ColorB = 8,
            ColorA = 9,
            Threshold = 10,
            EdgeColorR = 11,
            EdgeColorG = 12,
            EdgeColorB = 13,
            EdgeColorA = 14,
            Amplify = 15
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Image1 = inputs[(int)InputId.Image1].Eval(context).Image; if (Image1 == null) return context;
            var Image2 = inputs[(int)InputId.Image2].Eval(context).Image; if (Image2 == null) return context;
            var Radius = inputs[(int)InputId.Radius].Eval(context).Value;
            var SizeX = inputs[(int)InputId.SizeX].Eval(context).Value;
            var SizeY = inputs[(int)InputId.SizeY].Eval(context).Value;
            var Size = new Vector2(SizeX, SizeY);
            var ColorR = inputs[(int)InputId.ColorR].Eval(context).Value;
            var ColorG = inputs[(int)InputId.ColorG].Eval(context).Value;
            var ColorB = inputs[(int)InputId.ColorB].Eval(context).Value;
            var ColorA = inputs[(int)InputId.ColorA].Eval(context).Value;
            var Color = new Color4(ColorR, ColorG, ColorB, ColorA);
            var Threshold = inputs[(int)InputId.Threshold].Eval(context).Value;
            var EdgeColorR = inputs[(int)InputId.EdgeColorR].Eval(context).Value;
            var EdgeColorG = inputs[(int)InputId.EdgeColorG].Eval(context).Value;
            var EdgeColorB = inputs[(int)InputId.EdgeColorB].Eval(context).Value;
            var EdgeColorA = inputs[(int)InputId.EdgeColorA].Eval(context).Value;
            var EdgeColor = new Color4(EdgeColorR, EdgeColorG, EdgeColorB, EdgeColorA);
            var Amplify = inputs[(int)InputId.Amplify].Eval(context).Value;
            //<<< _params

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));

                //>>> _setup
                using (var Image1View = new ShaderResourceView(context.D3DDevice, Image1))
                using (var Image2View = new ShaderResourceView(context.D3DDevice, Image2))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Image1").AsShaderResource().SetResource(Image1View);
                    _effect.GetVariableByName("Image2").AsShaderResource().SetResource(Image2View);
                    _effect.GetVariableByName("Radius").AsScalar().Set(Radius);
                    _effect.GetVariableByName("Size").AsVector().Set(new Vector2(SizeX, SizeY));
                    _effect.GetVariableByName("Color").AsVector().Set(new Vector4(ColorR, ColorG, ColorB, ColorA));
                    _effect.GetVariableByName("Threshold").AsScalar().Set(Threshold);
                    _effect.GetVariableByName("EdgeColor").AsVector().Set(new Vector4(EdgeColorR, EdgeColorG, EdgeColorB, EdgeColorA));
                    _effect.GetVariableByName("Amplify").AsScalar().Set(Amplify);
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

