//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using System.Dynamic;
using Framefield.Core.OperatorPartTraits;

namespace Framefield.Core.IDd5769b1d_fe58_4c2f_81f1_25451b9cbf1c
{
    public class Class_ReuseCamera : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            SceneInput = 0,
            Camera = 1
        }
        //<<< _inputids
        //>>> _outputids
        private enum OutputId
        {
            Output = 0
        }
        //<<< _outputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var SceneInput = inputs[(int)InputId.SceneInput];
            var Camera = inputs[(int)InputId.Camera].Eval(context).Dynamic; if (Camera == null) return context;
            //<<< _params


            var cam = Camera.This as ICameraProvider;

            var prevTransform = context.WorldToCamera;
            var prevCamProj = context.CameraProjection;

            if (cam != null)
            {
                context.WorldToCamera = cam.GetLastWorldToCamera();
                context.CameraProjection = cam.GetLastCameraToView();
            }

            SceneInput.Eval(context);

            context.CameraProjection = prevCamProj;
            context.WorldToCamera = prevTransform;

            return context;
        }
    }
}

