//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using SharpDX.DXGI;

namespace Framefield.Core.ID41f9de8f_51a5_4b41_89c8_feeee2ddeff0
{
    public class Class_RiftDistortShader : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image = 1,
            distK0 = 2,
            distK1 = 3,
            distK2 = 4,
            distK3 = 5,
            imageScaleFactor = 6,
            chromaAbX = 7,
            chromaAbY = 8,
            chromaAbZ = 9,
            chromaAbW = 10
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Image = inputs[(int)InputId.Image].Eval(context).Image; if (Image == null) return context;
            var distK0 = inputs[(int)InputId.distK0].Eval(context).Value;
            var distK1 = inputs[(int)InputId.distK1].Eval(context).Value;
            var distK2 = inputs[(int)InputId.distK2].Eval(context).Value;
            var distK3 = inputs[(int)InputId.distK3].Eval(context).Value;
            var imageScaleFactor = inputs[(int)InputId.imageScaleFactor].Eval(context).Value;
            var chromaAbX = inputs[(int)InputId.chromaAbX].Eval(context).Value;
            var chromaAbY = inputs[(int)InputId.chromaAbY].Eval(context).Value;
            var chromaAbZ = inputs[(int)InputId.chromaAbZ].Eval(context).Value;
            var chromaAbW = inputs[(int)InputId.chromaAbW].Eval(context).Value;
            var chromaAb = new Vector4(chromaAbX, chromaAbY, chromaAbZ, chromaAbW);
            //<<< _params


            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 1));

                //>>> _setup
                using (var ImageView = new ShaderResourceView(context.D3DDevice, Image))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Image").AsShaderResource().SetResource(ImageView);
                    _effect.GetVariableByName("distK0").AsScalar().Set(distK0);
                    _effect.GetVariableByName("distK1").AsScalar().Set(distK1);
                    _effect.GetVariableByName("distK2").AsScalar().Set(distK2);
                    _effect.GetVariableByName("distK3").AsScalar().Set(distK3);
                    _effect.GetVariableByName("imageScaleFactor").AsScalar().Set(imageScaleFactor);
                    _effect.GetVariableByName("chromaAb").AsVector().Set(new Vector4(chromaAbX, chromaAbY, chromaAbZ, chromaAbW));
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}



