//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID66b6628e_5d16_44f7_85c5_4ebbd3763b8a
{
    public class Class_SelectFromImages : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Images = 1,
            Selector = 2
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            // params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Images = inputs[(int)InputId.Images];
            var Selector = inputs[(int)InputId.Selector].Eval(context).Value;
            // params

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));
                
                if (Images.Connections.Count == 0)
                    return;                                    
                
                int index1= (int)(Selector % Images.Connections.Count);
                int index2= index1;
                float blendValue = Selector % 1;
                if( blendValue > 0) {
                    index2 ++;
                }           
                
                var image1Input = Images.Connections[index1 % Images.Connections.Count];
                Texture2D image1 = image1Input.Eval(context).Image;
                Texture2D image2;
                
                if( blendValue == 0) {
                    image2= image1;
                }
                else {
                    var image2Input = Images.Connections[index2 % Images.Connections.Count];
                    image2 = image2Input.Eval(context).Image;                                               
                }
                Logger.Info(this,"{0}   {1}", image1, image2);

                // setup
                using (var image1View = new ShaderResourceView(context.D3DDevice, image1))
                using (var image2View = new ShaderResourceView(context.D3DDevice, image2))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Image1").AsShaderResource().SetResource(image1View);
                    _effect.GetVariableByName("Image2").AsShaderResource().SetResource(image2View);
                    _effect.GetVariableByName("BlendValue").AsScalar().Set(blendValue);
                // setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

