//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using System.Net;
using System.IO;

using System.Threading;
using System.Threading.Tasks;
using System.Collections.Specialized;

namespace Framefield.Core.IDc96f7bc0_3fa0_4354_a4ba_09acead9ffa8
{
    public class Class_Split : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            InputText = 0,
            SplitCharacter = 1
        }
        //<<< _inputids
        
        //>>> _outputids
        private enum OutputId
        {
            StringList = 0,
            Count = 1
        }
        //<<< _outputids

        List<List<string>> _tmpList = new List<List<string>>();
        List<String> _resultList = new List<String>();
        String _oldString = "";

        
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var InputText = inputs[(int)InputId.InputText].Eval(context).Text;
            var SplitCharacter = inputs[(int)InputId.SplitCharacter].Eval(context).Text;
            //<<< _params
            
            if( _oldString != InputText) {
                Changed = true;
            }
            
            if( Changed) {
                if( SplitCharacter == "\\n") {
                    SplitCharacter = "\n";
                }
                _resultList = InputText.Split( SplitCharacter[0] ).ToList();            
                context.Value = _resultList.Count;
            }
            
            

            context.Dynamic = _resultList;
            return context;
        }
    }
    
}

