//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDbdfc4867_e710_4022_a82b_6e630d5c2e56
{
    public class Class_Steps : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image1 = 1,
            Steps = 2,
            MinR = 3,
            MinG = 4,
            MinB = 5,
            MinA = 6,
            MaxR = 7,
            MaxG = 8,
            MaxB = 9,
            MaxA = 10
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            return PrepareAndEvalOnChange(context, () =>
            {
                //>>> __params
                var Code = inputs[(int)InputId.Code].Eval(context).Text;
                var Image1 = inputs[(int)InputId.Image1].Eval(context).Image; if (Image1 == null) return;
                var Steps = inputs[(int)InputId.Steps].Eval(context).Value;
                var MinR = inputs[(int)InputId.MinR].Eval(context).Value;
                var MinG = inputs[(int)InputId.MinG].Eval(context).Value;
                var MinB = inputs[(int)InputId.MinB].Eval(context).Value;
                var MinA = inputs[(int)InputId.MinA].Eval(context).Value;
                var Min = new Color4(MinR, MinG, MinB, MinA);
                var MaxR = inputs[(int)InputId.MaxR].Eval(context).Value;
                var MaxG = inputs[(int)InputId.MaxG].Eval(context).Value;
                var MaxB = inputs[(int)InputId.MaxB].Eval(context).Value;
                var MaxA = inputs[(int)InputId.MaxA].Eval(context).Value;
                var Max = new Color4(MaxR, MaxG, MaxB, MaxA);
                //<<< __params

                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));

                //>>> _setup
                using (var Image1View = new ShaderResourceView(context.D3DDevice, Image1))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Image1").AsShaderResource().SetResource(Image1View);
                    _effect.GetVariableByName("Steps").AsScalar().Set(Steps);
                    _effect.GetVariableByName("Min").AsVector().Set(new Vector4(MinR, MinG, MinB, MinA));
                    _effect.GetVariableByName("Max").AsVector().Set(new Vector4(MaxR, MaxG, MaxB, MaxA));
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

