//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDd88e4cc3_d3bd_47b3_8bfa_4334843e51a8
{
    public class Class_VariableValue : OperatorPart.Function, Framefield.Core.OperatorPartTraits.IVariableAccessor, Framefield.Core.OperatorPartTraits.ITimeAccessor
    {
        //>>> _inputids
        private enum InputId
        {
            Name = 0
        }
        //<<< _inputids

        public string VariableName
        {
            get
            {
                return OperatorPartUtilities.GetInputTextValue(OperatorPart.Connections[(int)InputId.Name]);
            }
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Name = inputs[(int)InputId.Name].Eval(context).Text;
            //<<< _params



            float v;
            if (context.Variables.TryGetValue(Name, out v))
                context.Value = v;
            else
                context.Value = float.NaN;

            return context;
        }
    }
}
