using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;

namespace Framefield.Core.IDb696ebc2_e67b_4ab2_8945_aeb1c888b5a3
{
    
    public class Class_Atan2 : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            VectorX = 0,
            VectorY = 1
        }
        //<<< _inputids
    
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var VectorX = inputs[(int)InputId.VectorX].Eval(context).Value;
            var VectorY = inputs[(int)InputId.VectorY].Eval(context).Value;
            var Vector = new Vector2(VectorX, VectorY);
            //<<< _params
            
            try {
                context.Value = (float)(Math.Atan2( Vector.X, Vector.Y));
            }
            catch {
                context.Value= 0.0f;
            }
            
            return context;
        }
    }
}

