//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDa61dd22f_d97f_4a1b_afb7_61fecb1a9ea7
{
    public class Class_ClampColors : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image = 1,
            Min = 2,
            Max = 3,
            Blend = 4,
            Contrast = 5,
            Brightness = 6,
            Hue = 7,
            Saturation = 8,
            VignetteStrength = 9,
            VignetteShape = 10
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            return PrepareAndEvalOnChange(context, () =>
            {
                //>>> _params
                var Code = inputs[(int)InputId.Code].Eval(context).Text;
                var Image = inputs[(int)InputId.Image].Eval(context).Image; // Needs to be checked for null!
                var Min = inputs[(int)InputId.Min].Eval(context).Value;
                var Max = inputs[(int)InputId.Max].Eval(context).Value;
                var Blend = inputs[(int)InputId.Blend].Eval(context).Value;
                var Contrast = inputs[(int)InputId.Contrast].Eval(context).Value;
                var Brightness = inputs[(int)InputId.Brightness].Eval(context).Value;
                var Hue = inputs[(int)InputId.Hue].Eval(context).Value;
                var Saturation = inputs[(int)InputId.Saturation].Eval(context).Value;
                var VignetteStrength = inputs[(int)InputId.VignetteStrength].Eval(context).Value;
                var VignetteShape = inputs[(int)InputId.VignetteShape].Eval(context).Value;
                var Vignette = new Vector2(VignetteStrength, VignetteShape);
                //<<< _params
                
                if (Image == null)
                    return;

                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));

                //>>> _setup
                using (var ImageView = new ShaderResourceView(context.D3DDevice, Image))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Image").AsShaderResource().SetResource(ImageView);
                    _effect.GetVariableByName("Min").AsScalar().Set(Min);
                    _effect.GetVariableByName("Max").AsScalar().Set(Max);
                    _effect.GetVariableByName("Blend").AsScalar().Set(Blend);
                    _effect.GetVariableByName("Contrast").AsScalar().Set(Contrast);
                    _effect.GetVariableByName("Brightness").AsScalar().Set(Brightness);
                    _effect.GetVariableByName("Hue").AsScalar().Set(Hue);
                    _effect.GetVariableByName("Saturation").AsScalar().Set(Saturation);
                    _effect.GetVariableByName("Vignette").AsVector().Set(new Vector2(VignetteStrength, VignetteShape));
                //<<< _setup

                var prevBlendState = context.BlendState;
                context.BlendState = OperatorPartContext.DefaultRenderer.DisabledBlendState;

                Render(context);

                context.BlendState = prevBlendState;

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}
