//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using Framefield.Core.Rendering;

namespace Framefield.Core.ID0e49b045_1a1a_453f_941f_29bb86c7793e
{
    public class Class_CubeMapper : FXSourceCodeFunction, IFXSceneSourceCode
    {

        class Renderer : BaseRenderer
        {
        }

        public override void Dispose() {
            Utilities.DisposeObj(ref _renderer);
            base.Dispose();
        }

        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Scene = 1,
            CubeMap = 2
        }
        //<<< _inputids

        bool _firstEval = true;
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Scene = inputs[(int)InputId.Scene];
            var CubeMap = inputs[(int)InputId.CubeMap].Eval(context).Image; // Needs to be checked for null!
            //<<< _params

            if (_firstEval)
            {
                for (int i = 0; i < NumCodes(); ++i)
                    Compile(i);
                _firstEval = false;
                Changed = true;
            }
           
            using (var CubeMapView = new ShaderResourceView(context.D3DDevice, CubeMap))
            {
                _effect.GetVariableByName("CubeMap").AsShaderResource().SetResource(CubeMapView);

                using (new PropertyStasher<OperatorPartContext>(context, "Effect", "Renderer"))
                {
                    context.Effect = _effect;
                    context.Renderer = _renderer;
         
                    Scene.Eval(context);
                }
            }
            return context;
        }

        private Renderer _renderer = new Renderer();
    }
}


