//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID6f88c1f1_4d35_46e5_829a_b3008c06bd05
{
    public class Class_Desertscene2 : OperatorPart.Function, IMaterial
    {
        //>>> _inputids
        private enum InputId
        {
            Scene = 0,
            AmbientR = 1,
            AmbientG = 2,
            AmbientB = 3,
            AmbientA = 4,
            DiffuseR = 5,
            DiffuseG = 6,
            DiffuseB = 7,
            DiffuseA = 8,
            SpecularR = 9,
            SpecularG = 10,
            SpecularB = 11,
            SpecularA = 12,
            EmissionR = 13,
            EmissionG = 14,
            EmissionB = 15,
            EmissionA = 16,
            Shininess = 17
        }
        //<<< _inputids
    
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var Scene = inputs[(int)InputId.Scene];
            var AmbientR = inputs[(int)InputId.AmbientR].Eval(context).Value;
            var AmbientG = inputs[(int)InputId.AmbientG].Eval(context).Value;
            var AmbientB = inputs[(int)InputId.AmbientB].Eval(context).Value;
            var AmbientA = inputs[(int)InputId.AmbientA].Eval(context).Value;
            var Ambient = new Color4(AmbientR, AmbientG, AmbientB, AmbientA);
            var DiffuseR = inputs[(int)InputId.DiffuseR].Eval(context).Value;
            var DiffuseG = inputs[(int)InputId.DiffuseG].Eval(context).Value;
            var DiffuseB = inputs[(int)InputId.DiffuseB].Eval(context).Value;
            var DiffuseA = inputs[(int)InputId.DiffuseA].Eval(context).Value;
            var Diffuse = new Color4(DiffuseR, DiffuseG, DiffuseB, DiffuseA);
            var SpecularR = inputs[(int)InputId.SpecularR].Eval(context).Value;
            var SpecularG = inputs[(int)InputId.SpecularG].Eval(context).Value;
            var SpecularB = inputs[(int)InputId.SpecularB].Eval(context).Value;
            var SpecularA = inputs[(int)InputId.SpecularA].Eval(context).Value;
            var Specular = new Color4(SpecularR, SpecularG, SpecularB, SpecularA);
            var EmissionR = inputs[(int)InputId.EmissionR].Eval(context).Value;
            var EmissionG = inputs[(int)InputId.EmissionG].Eval(context).Value;
            var EmissionB = inputs[(int)InputId.EmissionB].Eval(context).Value;
            var EmissionA = inputs[(int)InputId.EmissionA].Eval(context).Value;
            var Emission = new Color4(EmissionR, EmissionG, EmissionB, EmissionA);
            var Shininess = inputs[(int)InputId.Shininess].Eval(context).Value;
            //<<< _params

            // store values for later use of IMaterial
            this.Ambient = Ambient;
            this.Diffuse = Diffuse;
            this.Specular = Specular;
            this.Emission = Emission;
            this.Shininess = Shininess;

            var prevMaterial = (IMaterial) context.Objects[OperatorPartContext.MATERIAL_ID];
            context.Objects[OperatorPartContext.MATERIAL_ID] = this;

            Scene.Eval(context);

            context.Objects[OperatorPartContext.MATERIAL_ID] = prevMaterial;

            return context;
        }

        public Color4 Ambient { get; private set; }
        public Color4 Diffuse { get; private set; }
        public Color4 Specular { get; private set; }
        public Color4 Emission { get; private set; }
        public float Shininess { get; private set; }
    }
}

