//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID016f8d87_bbc5_41e8_92fa_d966d8ef3fd2
{
    public class Class_FractalCityCoast : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Minrad = 1,
            Scale = 2,
            ClampingX = 3,
            ClampingY = 4,
            ClampingZ = 5,
            FoldMin = 6,
            FoldMax = 7,
            IncrementX = 8,
            IncrementY = 9,
            IncrementZ = 10,
            MaxSteps = 11,
            StepSize = 12,
            MinDistance = 13,
            MaxDistance = 14,
            DistToColor = 15,
            Surface1R = 16,
            Surface1G = 17,
            Surface1B = 18,
            Surface1A = 19,
            Surface2R = 20,
            Surface2G = 21,
            Surface2B = 22,
            Surface2A = 23,
            Surface3R = 24,
            Surface3G = 25,
            Surface3B = 26,
            Surface3A = 27,
            DiffuseR = 28,
            DiffuseG = 29,
            DiffuseB = 30,
            DiffuseA = 31,
            SpecularR = 32,
            SpecularG = 33,
            SpecularB = 34,
            SpecularA = 35,
            SpecPower = 36,
            SpecFallOff = 37,
            GlowR = 38,
            GlowG = 39,
            GlowB = 40,
            GlowA = 41,
            AmbientOcclusionR = 42,
            AmbientOcclusionG = 43,
            AmbientOcclusionB = 44,
            AmbientOcclusionA = 45,
            AODistance = 46,
            BackgroundR = 47,
            BackgroundG = 48,
            BackgroundB = 49,
            BackgroundA = 50,
            Fog = 51,
            LightPosX = 52,
            LightPosY = 53,
            LightPosZ = 54,
            SpherePosX = 55,
            SpherePosY = 56,
            SpherePosZ = 57,
            SphereRadius = 58,
            BX = 59,
            BY = 60,
            BZ = 61,
            Image = 62,
            Displace = 63
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Minrad = inputs[(int)InputId.Minrad].Eval(context).Value;
            var Scale = inputs[(int)InputId.Scale].Eval(context).Value;
            var ClampingX = inputs[(int)InputId.ClampingX].Eval(context).Value;
            var ClampingY = inputs[(int)InputId.ClampingY].Eval(context).Value;
            var ClampingZ = inputs[(int)InputId.ClampingZ].Eval(context).Value;
            var Clamping = new Vector3(ClampingX, ClampingY, ClampingZ);
            var FoldMin = inputs[(int)InputId.FoldMin].Eval(context).Value;
            var FoldMax = inputs[(int)InputId.FoldMax].Eval(context).Value;
            var Fold = new Vector2(FoldMin, FoldMax);
            var IncrementX = inputs[(int)InputId.IncrementX].Eval(context).Value;
            var IncrementY = inputs[(int)InputId.IncrementY].Eval(context).Value;
            var IncrementZ = inputs[(int)InputId.IncrementZ].Eval(context).Value;
            var Increment = new Vector3(IncrementX, IncrementY, IncrementZ);
            var MaxSteps = inputs[(int)InputId.MaxSteps].Eval(context).Value;
            var StepSize = inputs[(int)InputId.StepSize].Eval(context).Value;
            var MinDistance = inputs[(int)InputId.MinDistance].Eval(context).Value;
            var MaxDistance = inputs[(int)InputId.MaxDistance].Eval(context).Value;
            var DistToColor = inputs[(int)InputId.DistToColor].Eval(context).Value;
            var Surface1R = inputs[(int)InputId.Surface1R].Eval(context).Value;
            var Surface1G = inputs[(int)InputId.Surface1G].Eval(context).Value;
            var Surface1B = inputs[(int)InputId.Surface1B].Eval(context).Value;
            var Surface1A = inputs[(int)InputId.Surface1A].Eval(context).Value;
            var Surface1 = new Color4(Surface1R, Surface1G, Surface1B, Surface1A);
            var Surface2R = inputs[(int)InputId.Surface2R].Eval(context).Value;
            var Surface2G = inputs[(int)InputId.Surface2G].Eval(context).Value;
            var Surface2B = inputs[(int)InputId.Surface2B].Eval(context).Value;
            var Surface2A = inputs[(int)InputId.Surface2A].Eval(context).Value;
            var Surface2 = new Color4(Surface2R, Surface2G, Surface2B, Surface2A);
            var Surface3R = inputs[(int)InputId.Surface3R].Eval(context).Value;
            var Surface3G = inputs[(int)InputId.Surface3G].Eval(context).Value;
            var Surface3B = inputs[(int)InputId.Surface3B].Eval(context).Value;
            var Surface3A = inputs[(int)InputId.Surface3A].Eval(context).Value;
            var Surface3 = new Color4(Surface3R, Surface3G, Surface3B, Surface3A);
            var DiffuseR = inputs[(int)InputId.DiffuseR].Eval(context).Value;
            var DiffuseG = inputs[(int)InputId.DiffuseG].Eval(context).Value;
            var DiffuseB = inputs[(int)InputId.DiffuseB].Eval(context).Value;
            var DiffuseA = inputs[(int)InputId.DiffuseA].Eval(context).Value;
            var Diffuse = new Color4(DiffuseR, DiffuseG, DiffuseB, DiffuseA);
            var SpecularR = inputs[(int)InputId.SpecularR].Eval(context).Value;
            var SpecularG = inputs[(int)InputId.SpecularG].Eval(context).Value;
            var SpecularB = inputs[(int)InputId.SpecularB].Eval(context).Value;
            var SpecularA = inputs[(int)InputId.SpecularA].Eval(context).Value;
            var Specular = new Color4(SpecularR, SpecularG, SpecularB, SpecularA);
            var SpecPower = inputs[(int)InputId.SpecPower].Eval(context).Value;
            var SpecFallOff = inputs[(int)InputId.SpecFallOff].Eval(context).Value;
            var Spec = new Vector2(SpecPower, SpecFallOff);
            var GlowR = inputs[(int)InputId.GlowR].Eval(context).Value;
            var GlowG = inputs[(int)InputId.GlowG].Eval(context).Value;
            var GlowB = inputs[(int)InputId.GlowB].Eval(context).Value;
            var GlowA = inputs[(int)InputId.GlowA].Eval(context).Value;
            var Glow = new Color4(GlowR, GlowG, GlowB, GlowA);
            var AmbientOcclusionR = inputs[(int)InputId.AmbientOcclusionR].Eval(context).Value;
            var AmbientOcclusionG = inputs[(int)InputId.AmbientOcclusionG].Eval(context).Value;
            var AmbientOcclusionB = inputs[(int)InputId.AmbientOcclusionB].Eval(context).Value;
            var AmbientOcclusionA = inputs[(int)InputId.AmbientOcclusionA].Eval(context).Value;
            var AmbientOcclusion = new Color4(AmbientOcclusionR, AmbientOcclusionG, AmbientOcclusionB, AmbientOcclusionA);
            var AODistance = inputs[(int)InputId.AODistance].Eval(context).Value;
            var BackgroundR = inputs[(int)InputId.BackgroundR].Eval(context).Value;
            var BackgroundG = inputs[(int)InputId.BackgroundG].Eval(context).Value;
            var BackgroundB = inputs[(int)InputId.BackgroundB].Eval(context).Value;
            var BackgroundA = inputs[(int)InputId.BackgroundA].Eval(context).Value;
            var Background = new Color4(BackgroundR, BackgroundG, BackgroundB, BackgroundA);
            var Fog = inputs[(int)InputId.Fog].Eval(context).Value;
            var LightPosX = inputs[(int)InputId.LightPosX].Eval(context).Value;
            var LightPosY = inputs[(int)InputId.LightPosY].Eval(context).Value;
            var LightPosZ = inputs[(int)InputId.LightPosZ].Eval(context).Value;
            var LightPos = new Vector3(LightPosX, LightPosY, LightPosZ);
            var SpherePosX = inputs[(int)InputId.SpherePosX].Eval(context).Value;
            var SpherePosY = inputs[(int)InputId.SpherePosY].Eval(context).Value;
            var SpherePosZ = inputs[(int)InputId.SpherePosZ].Eval(context).Value;
            var SpherePos = new Vector3(SpherePosX, SpherePosY, SpherePosZ);
            var SphereRadius = inputs[(int)InputId.SphereRadius].Eval(context).Value;
            var BX = inputs[(int)InputId.BX].Eval(context).Value;
            var BY = inputs[(int)InputId.BY].Eval(context).Value;
            var BZ = inputs[(int)InputId.BZ].Eval(context).Value;
            var B = new Vector3(BX, BY, BZ);
            var Image = inputs[(int)InputId.Image].Eval(context).Image; // Needs to be checked for null!
            var Displace = inputs[(int)InputId.Displace].Eval(context).Value;
            //<<< _params

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));

                //>>> _setup
                using (var ImageView = new ShaderResourceView(context.D3DDevice, Image))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Minrad").AsScalar().Set(Minrad);
                    _effect.GetVariableByName("Scale").AsScalar().Set(Scale);
                    _effect.GetVariableByName("Clamping").AsVector().Set(new Vector3(ClampingX, ClampingY, ClampingZ));
                    _effect.GetVariableByName("Fold").AsVector().Set(new Vector2(FoldMin, FoldMax));
                    _effect.GetVariableByName("Increment").AsVector().Set(new Vector3(IncrementX, IncrementY, IncrementZ));
                    _effect.GetVariableByName("MaxSteps").AsScalar().Set(MaxSteps);
                    _effect.GetVariableByName("StepSize").AsScalar().Set(StepSize);
                    _effect.GetVariableByName("MinDistance").AsScalar().Set(MinDistance);
                    _effect.GetVariableByName("MaxDistance").AsScalar().Set(MaxDistance);
                    _effect.GetVariableByName("DistToColor").AsScalar().Set(DistToColor);
                    _effect.GetVariableByName("Surface1").AsVector().Set(new Vector4(Surface1R, Surface1G, Surface1B, Surface1A));
                    _effect.GetVariableByName("Surface2").AsVector().Set(new Vector4(Surface2R, Surface2G, Surface2B, Surface2A));
                    _effect.GetVariableByName("Surface3").AsVector().Set(new Vector4(Surface3R, Surface3G, Surface3B, Surface3A));
                    _effect.GetVariableByName("Diffuse").AsVector().Set(new Vector4(DiffuseR, DiffuseG, DiffuseB, DiffuseA));
                    _effect.GetVariableByName("Specular").AsVector().Set(new Vector4(SpecularR, SpecularG, SpecularB, SpecularA));
                    _effect.GetVariableByName("Spec").AsVector().Set(new Vector2(SpecPower, SpecFallOff));
                    _effect.GetVariableByName("Glow").AsVector().Set(new Vector4(GlowR, GlowG, GlowB, GlowA));
                    _effect.GetVariableByName("AmbientOcclusion").AsVector().Set(new Vector4(AmbientOcclusionR, AmbientOcclusionG, AmbientOcclusionB, AmbientOcclusionA));
                    _effect.GetVariableByName("AODistance").AsScalar().Set(AODistance);
                    _effect.GetVariableByName("Background").AsVector().Set(new Vector4(BackgroundR, BackgroundG, BackgroundB, BackgroundA));
                    _effect.GetVariableByName("Fog").AsScalar().Set(Fog);
                    _effect.GetVariableByName("LightPos").AsVector().Set(new Vector3(LightPosX, LightPosY, LightPosZ));
                    _effect.GetVariableByName("SpherePos").AsVector().Set(new Vector3(SpherePosX, SpherePosY, SpherePosZ));
                    _effect.GetVariableByName("SphereRadius").AsScalar().Set(SphereRadius);
                    _effect.GetVariableByName("B").AsVector().Set(new Vector3(BX, BY, BZ));
                    _effect.GetVariableByName("Image").AsShaderResource().SetResource(ImageView);
                    _effect.GetVariableByName("Displace").AsScalar().Set(Displace);
                //<<< _setup
                var worldToView = context.WorldToCamera*context.CameraProjection;
                var viewToWorld = Matrix.Invert(worldToView);
                _effect.GetVariableByName("ViewToWorld").AsMatrix().SetMatrix(viewToWorld);
                _effect.GetVariableByName("WorldToView").AsMatrix().SetMatrix(worldToView);

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

