//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using System.Windows.Forms;
using Framefield.Core.Inputs;


namespace Framefield.Core.ID087f634a_3f0d_4480_aa0a_76da48f3e498
{
    public class Class_KeyInput2 : OperatorPart.Function, Framefield.Core.OperatorPartTraits.IAsyncDependend
    {
        public bool AsyncChanged { get { return _asyncChanged; } }

        //>>> _inputids
        private enum InputId
        {
            Key = 0,
            Hold = 1
        }
        //<<< _inputids 

        public Class_KeyInput2()
        {
            Input.Keyboard.KeyPressedEvent += HandleKeyboardKeyPressedEvent;
            Input.Keyboard.KeyReleasedEvent += HandleKeyboardKeyReleasedEvent;
        }

        public override void Dispose()
        {
            Input.Keyboard.KeyPressedEvent -= HandleKeyboardKeyPressedEvent;
            Input.Keyboard.KeyReleasedEvent -= HandleKeyboardKeyReleasedEvent;
        }

        void HandleKeyboardKeyPressedEvent(object o, KeyboardInput.KeyEventArgs e)
        {
            _asyncChanged = true;
            _lastKey = e.Keys;
        }
        void HandleKeyboardKeyReleasedEvent(object o, KeyboardInput.KeyEventArgs e)
        {
            _asyncChanged = true;
            if(!_hold) 
                _lastKey = 0;;
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Key = inputs[(int)InputId.Key].Eval(context).Text;
            var Hold = (int) inputs[(int)InputId.Hold].Eval(context).Value;
            //<<< _params
            
            _hold = Hold < 0.5f;

            try
            {
                _key = (Keys)_keysConverter.ConvertFromString(Key);
            }
            catch (Exception) {
            }

            //context.Value = Input.Keyboard.IsKeyDown(_key) ? (int)_key : 0;
            context.Value = (int)_lastKey;
            _asyncChanged = false;
            return context;
        }

        bool _asyncChanged = false;
        KeysConverter _keysConverter = new KeysConverter();
        Keys _key;
        Keys _lastKey;
        bool _hold=false;
    }

}

