//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using Framefield.Core.Rendering;
using SharpDX.DXGI;

            


namespace Framefield.Core.ID190ebf7e_085f_47c9_ad54_7abf55e30bc5
{
    public class Class_RenderImagesToFile : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            Input = 0,
            Path = 1,
            SizeWidth = 2,
            SizeHeight = 3,
            FPS = 4,
            TimeRangeStart = 5,
            TimeRangeEnd = 6,
            Format = 7,
            Trigger = 8,
            ExistingFiles = 9,
            FilenameFormat = 10,
            ImageFormat = 11
        }
        //<<< _inputids

        public Class_RenderImagesToFile() {
            _sequenceCreator = new SequenceCreator();
        }

        public override void Dispose() {
            _sequenceCreator.Dispose();
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var Input = inputs[(int)InputId.Input];
            var Path = inputs[(int)InputId.Path].Eval(context).Text;
            var SizeWidth = inputs[(int)InputId.SizeWidth].Eval(context).Value;
            var SizeHeight = inputs[(int)InputId.SizeHeight].Eval(context).Value;
            var Size = new Vector2(SizeWidth, SizeHeight);
            var FPS = inputs[(int)InputId.FPS].Eval(context).Value;
            var TimeRangeStart = inputs[(int)InputId.TimeRangeStart].Eval(context).Value;
            var TimeRangeEnd = inputs[(int)InputId.TimeRangeEnd].Eval(context).Value;
            var TimeRange = new Vector2(TimeRangeStart, TimeRangeEnd);
            var Format = inputs[(int)InputId.Format].Eval(context).Text;
            var Trigger = inputs[(int)InputId.Trigger].Eval(context).Value;
            var ExistingFiles = (int) inputs[(int)InputId.ExistingFiles].Eval(context).Value;
            var FilenameFormat = inputs[(int)InputId.FilenameFormat].Eval(context).Text;
            var ImageFormat = (int) inputs[(int)InputId.ImageFormat].Eval(context).Value;
            //<<< _params

            bool flankDetected = Trigger >= 0.5 && _oldTrigger <= 0.5;
            _oldTrigger = Trigger;
            
            //var oldImageBufferFormat = context.ImageBufferFormat;
            //context.ImageBufferFormat = (SharpDX.DXGI.Format)ImageFormat;

            //Input.Eval(context);
            //context.ImageBufferFormat = oldImageBufferFormat;
            
            var bufferFormat = SharpDX.DXGI.Format.R16G16B16A16_Float;
            
            if( (int)ImageFormat == 28) {
                bufferFormat = SharpDX.DXGI.Format.R8G8B8A8_UNorm;
            }
            else if ((int)ImageFormat == 11) {
                bufferFormat = SharpDX.DXGI.Format.R16G16B16A16_UNorm;
            }
            

            if (flankDetected && !_renderingActive) {
                _sequenceCreator.Setup(Input, height:SizeHeight, 
                width:SizeWidth, 
                startTime:TimeRangeStart, 
                endTime:TimeRangeEnd, 
                frameRate:FPS, 
                fileExtension:Format, 
                skipExistingFiles: ExistingFiles != 0,
                directory: Path,
                filenameFormat: FilenameFormat,
                imageFormat:  bufferFormat // (SharpDX.DXGI.Format)ImageFormat
                );
                _renderingActive = true;
            }

            if (_renderingActive) {
                float progress = _sequenceCreator.RenderFrame();
                if (progress >= 1.0)
                    _renderingActive = false;

                context.Value = progress;
            }
            return context;
        }

        SequenceCreator _sequenceCreator;
        float _oldTrigger = 0;
        bool _renderingActive = false;
    }
}

